/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.chemica.model;

import java.awt.Color;
import org.pfaa.chemica.model.Chemical;
import org.pfaa.chemica.model.ChemicalConditionProperties;
import org.pfaa.chemica.model.ChemicalPhaseProperties;
import org.pfaa.chemica.model.Condition;
import org.pfaa.chemica.model.Formula;
import org.pfaa.chemica.model.Fusion;
import org.pfaa.chemica.model.Hazard;
import org.pfaa.chemica.model.IndustrialMaterial;
import org.pfaa.chemica.model.Mixture;
import org.pfaa.chemica.model.SimpleChemical;
import org.pfaa.chemica.model.Thermo;
import org.pfaa.chemica.model.Vaporization;

public interface Element
extends Chemical,
Formula.PartFactory {
    public double getAtomicWeight();

    public int getDefaultOxidationState();

    public Formula.Part _(int var1);

    public static enum Elements implements Element
    {
        H("hydrogen", 1.0, 1),
        Li("lithium", 6.94, 1, new ChemicalPhaseProperties.Solid(new Color(240, 240, 240), 0.534, new Thermo(170.0, -883.0, 1977.0, -1487.0, -1.61, -31.2, 414.0), new Hazard(3, 2, 2, Hazard.SpecialCode.WATER_REACTIVE)), new Fusion(454.0), new ChemicalPhaseProperties.Liquid(0.512, new Thermo(32.5, -2.64, -6.33, 4.23, 0.00569, -7.12, 74.3).addSegment(700.0, 26.0, 5.63, -4.01, 0.874, 0.344, -4.2, 66.4)), new Vaporization(1603.0), new ChemicalPhaseProperties.Gas(new Thermo(23.3, -2.77, 0.767, -0.0036, -0.0352, 152.0, 166.0))),
        Be("beryllium", 9.01, 2, new ChemicalPhaseProperties.Solid(new Color(40, 40, 40), 1.85, new Thermo(21.2, 5.69, 0.968, -0.00175, -0.588, -8.55, 30.1).addSegment(1527.0, 30.0, -3.96E-4, 1.69E-4, -2.6E-5, -1.05E-4, -6.97, 40.8), new Hazard(3, 1, 0)), new Fusion(1560.0), new ChemicalPhaseProperties.Liquid(1.69, new Thermo(25.4, 2.16, -0.00257, 2.87E-4, 0.00396, 5.44, 44.5)), new Vaporization(3243.0), new ChemicalPhaseProperties.Gas(new Thermo(28.6, -5.38, 1.04, -0.0121, -426.0, 308.0, 164.0))),
        B("boron", 10.8, 3, new ChemicalPhaseProperties.Solid(new Color(82, 53, 7), 2.37, new Thermo(10.2, 29.2, -18.0, 4.21, -0.551, -6.04, 7.09).addSegment(1800.0, 25.1, 1.98, 0.338, -0.04, -2.64, -14.4, 25.6), new Hazard(3, 3, 2, Hazard.SpecialCode.WATER_REACTIVE)), new Fusion(2349.0), new ChemicalPhaseProperties.Liquid(2.08, new Thermo(48.9, 26.5, 31.8)), new Vaporization(4200.0), new ChemicalPhaseProperties.Gas(new Thermo(20.7, 0.226, -0.112, 0.0169, 0.00871, 554.0, 178.0))),
        C("carbon", 12.0, 4, new ChemicalPhaseProperties.Solid(Color.black, 2.27, new Thermo(0.0, 6.0, 9.25).addSegment(300.0, 10.7), new Hazard(0, 1, 0)), null, null, new Vaporization(3915.0), new ChemicalPhaseProperties.Gas(new Thermo(21.2, -0.812, 0.449, -0.0433, -0.0131, 710.0, 184.0))),
        Na("sodium", 23.0, 1, new ChemicalPhaseProperties.Solid(new Color(212, 216, 220), 0.968, new Thermo(72.6, -9.49, -731.0, 1415.0, -1.26, -21.8, 155.0), new Hazard(3, 3, 2, Hazard.SpecialCode.WATER_REACTIVE)), new Fusion(371.0), new ChemicalPhaseProperties.Liquid(0.927, new Thermo(40.3, -28.2, 20.7, -3.64, -0.0799, -8.78, 114.0)), new Vaporization(2.46, 1874.0, -416.0), new ChemicalPhaseProperties.Gas(new Thermo(20.8, 0.277, -0.392, 0.12, -0.00888, 101.0, 179.0))),
        Mg("magnesium", 24.3, 2, new ChemicalPhaseProperties.Solid(new Color(157, 157, 157), 1.74, new Thermo(26.5, -1.53, 8.06, 0.572, -0.174, -8.5, 63.9), new Hazard(0, 1, 1)), new Fusion(923.0), new ChemicalPhaseProperties.Liquid(1.58, new Thermo(4.79, 34.5, 34.3)), new Vaporization(1363.0), new ChemicalPhaseProperties.Gas(new Thermo(20.8, 0.0356, -0.0319, 0.00911, 4.61E-4, 141.0).addSegment(2200.0, 47.6, -15.4, 2.88, -0.121, -27.0, 97.4, 177.0))),
        Al("aluminum", 31.0, 5, new ChemicalPhaseProperties.Solid(new Color(177, 177, 177), 2.7, new Thermo(28.1, -5.41, 8.56, 3.43, -0.277, -9.15, 61.9), new Hazard(0, 1, 1)), new Fusion(933.0), new ChemicalPhaseProperties.Liquid(2.38, new Thermo(10.6, 39.6, 31.8)), new Vaporization(5.74, 13204.0, -24.3), new ChemicalPhaseProperties.Gas(new Thermo(20.4, 0.661, -0.314, 0.0451, 0.0782, 324.0, 189.0))),
        Si("silicon", 28.1, 4, new ChemicalPhaseProperties.Solid(new Color(206, 227, 231), 2.33, new Thermo(22.8, 3.9, -0.0829, 0.0421, -0.354, -8.16, 43.3)), new Fusion(1687.0), new ChemicalPhaseProperties.Liquid(2.57, new Thermo(48.5, 44.5, 27.2))),
        P("phosphorus", 31.0, 5, new ChemicalPhaseProperties.Solid(Color.white, 1.82, new Thermo(16.5, 43.3, -58.7, 25.6, -0.0867, -6.66, 50.0), new Hazard(4, 4, 2)), new Fusion(317.2), new ChemicalPhaseProperties.Liquid(1.74, new Thermo(26.3, 1.04, -6.12, 1.09, 3.0, -7.23, 74.9)), new Vaporization(553.0), new ChemicalPhaseProperties.Gas(new Thermo(20.4, 1.05, -1.1, 0.378, 0.011, 310.0, 188.0).addSegment(2200.0, -2.11, 9.31, -0.558, -0.02, 29.3, 354.0, 190.0))),
        S("sulfur", 32.1, 4, new ChemicalPhaseProperties.Solid(new Color(230, 230, 25), 2.0, new Thermo(21.2, 3.87, 22.3, -10.3, -0.0123, -7.09, 55.5), new Hazard()), new Fusion(388.0), new ChemicalPhaseProperties.Liquid(1.82, new Thermo(4541.0, 26066.0, -55521.0, 42012.0, 54.6, 788.0, -10826.0).addSegment(432.0, -37.9, 133.0, -95.3, 24.0, 7.65, 29.8, -13.2)), new Vaporization(718.0), new ChemicalPhaseProperties.Gas(new Thermo(27.5, -13.3, 10.1, -2.66, -0.00558, 269.0, 204.0).addSegment(1400.0, 16.6, 2.4, -0.256, 0.00582, 3.56, 278.0, 195.0))),
        Cl("chlorine", 34.5, -1),
        K("potassium", 39.1, 1, new ChemicalPhaseProperties.Solid(new Color(219, 219, 219), 0.862, new Thermo(-63.5, -3226.0, 14644.0, -16229.0, 16.3, 120.0, 534.0), new Hazard(3, 3, 2, Hazard.SpecialCode.WATER_REACTIVE)), new Fusion(337.0), new ChemicalPhaseProperties.Liquid(0.828, new Thermo(40.3, -30.5, 26.5, -5.73, -0.0635, -8.81, 128.0)), new Vaporization(new Vaporization.AntoineCoefficients(4.46, 4692.0, 24.2)), new ChemicalPhaseProperties.Gas(new Thermo(20.7, 0.392, -0.417, 0.146, 0.00376, 82.8, 185.0).addSegment(1800.0, 58.7, -27.4, 6.73, -0.421, -25.9, 32.4, 198.0))),
        Ca("calcium", 40.1, 2, new ChemicalPhaseProperties.Solid(new Color(228, 237, 237), 1.55, new Thermo(19.8, 10.1, 14.5, -5.53, 0.178, -5.86, 62.9), new Hazard(3, 1, 2, Hazard.SpecialCode.WATER_REACTIVE)), new Fusion(1115.0), new ChemicalPhaseProperties.Liquid(1.38, new Thermo(7.79, 45.5, 35.0)), new Vaporization(new Vaporization.AntoineCoefficients(2.78, 3121.0, -595.0)), new ChemicalPhaseProperties.Gas(new Thermo(122.0, -75.0, 19.2, -1.4, -64.5, 42.2, 217.0))),
        Ti("titanium", 47.9, 4, new ChemicalPhaseProperties.Solid(new Color(230, 230, 230), 4.51, new Thermo(23.1, 5.54, -2.06, 1.61, -0.0561, -0.433, 64.1), new Hazard(1, 1, 2)), new Fusion(1941.0), new ChemicalPhaseProperties.Liquid(4.11, new Thermo(13.7, 39.2, -22.1)), new Vaporization(3560.0), new ChemicalPhaseProperties.Gas(new Thermo(9.27, 6.09, 0.577, -0.11, 6.5, 483.0, 204.0))),
        V("vanadium", 50.9, 5, new ChemicalPhaseProperties.Solid(new Color(145, 170, 190), 6.0, new Thermo(26.3, 1.4, 2.21, 0.404, -0.176, -8.52, 59.3), new Hazard(2, 1, 0)), new Fusion(2183.0), new ChemicalPhaseProperties.Liquid(5.5, new Thermo(17.3, 36.1, 46.2)), new Vaporization(3680.0), new ChemicalPhaseProperties.Gas(new Thermo(32.0, -9.12, 2.94, -0.19, 1.41, 505.0, 220.0))),
        Cr("chromium", 52.0, 3, new ChemicalPhaseProperties.Solid(new Color(212, 216, 220), 7.19, new Thermo(7.49, 71.5, -91.7, 46.0, 0.138, -4.23, 15.8).addSegment(600.0, 18.5, 5.48, 7.9, -1.15, 1.27, -2.68, 48.1), new Hazard(2, 1, 1)), new Fusion(2180.0), new ChemicalPhaseProperties.Liquid(6.3, new Thermo(21.6, 36.2, 39.3)), new Vaporization(2944.0), new ChemicalPhaseProperties.Gas(new Thermo(13.7, -3.42, 0.394, -16.7, 383.0, 183.0, 397.0))),
        Mn("manganese", 54.9, 4, new ChemicalPhaseProperties.Solid(new Color(212, 216, 220), 7.21, new Thermo(27.2, 5.24, 7.78, -2.12, -0.282, -9.37, 61.5).addSegment(980.0, 52.3, -28.7, 21.5, -4.98, -2.43, -21.2, 90.7).addSegment(1361.0, 19.1, 31.4, -15.0, 3.21, 1.87, -2.76, 48.8).addSegment(1412.0, -534.0, 679.0, -296.0, 46.4, 161.0, 469.0, -394.0)), new Fusion(1519.0), new ChemicalPhaseProperties.Liquid(5.95, new Thermo(16.3, 43.5, 46.0)), new Vaporization(2334.0), new ChemicalPhaseProperties.Gas(new Thermo(188.0, -97.8, 20.2, -1.27, -177.0, 1.55, 220.0))),
        Fe("iron", 55.8, 3, new ChemicalPhaseProperties.Solid(Color.gray, 7.87, new Thermo(24.0, 8.37, 2.77E-4, -8.6E-5, -5.0E-6, 0.268, 62.1), new Hazard(1, 1, 0)), new Fusion(1811.0), new ChemicalPhaseProperties.Liquid(6.98, new Thermo(12.0, 35.0, 46.0)), new Vaporization(3134.0), new ChemicalPhaseProperties.Gas(new Thermo(11.3, 6.99, -1.11, 0.122, 5.69, 424.0, 206.0))),
        Co("cobalt", 58.9, 2, new ChemicalPhaseProperties.Solid(Color.gray, 8.9, new Thermo(11.0, 54.4, -55.5, 25.8, 0.165, -4.7, 30.3).addSegment(700.0, -205.0, 516.0, -422.0, 130.0, 18.0, 94.6, -273.0).addSegment(1394.0, -12418.0, 15326.0, -7087.0, 1167.0, 3320.0, 10139.0, -10473.0)), new Fusion(1768.0), new ChemicalPhaseProperties.Liquid(7.75, new Thermo(45.6, -3.81, 1.03, -0.0967, -3.33, -8.14, 78.0)), new Vaporization(3200.0), new ChemicalPhaseProperties.Gas(new Thermo(40.7, -8.46, 1.54, -0.0652, -11.1, 397.0, 213.0))),
        Ni("nickel", 58.7, 2, new ChemicalPhaseProperties.Solid(new Color(160, 160, 140), 8.91, new Thermo(13.7, 82.5, -175.0, 162.0, -0.0924, -6.83, 27.7).addSegment(600.0, 1248.0, -1258.0, 0.0, 0.0, -165.0, -789.0, 1213.0).addSegment(700.0, 16.5, 18.7, -6.64, 1.72, 1.87, -0.468, 51.7), new Hazard(2, 4, 1)), new Fusion(1728.0), new ChemicalPhaseProperties.Liquid(7.81, new Thermo(17.5, 41.5, 38.9)), new Vaporization(3186.0), new ChemicalPhaseProperties.Gas(new Thermo(27.1, -2.59, 0.295, 0.0152, 0.0418, 421.0, 214.0))),
        Cu("copper", 63.5, 2, new ChemicalPhaseProperties.Solid(new Color(208, 147, 29), 8.96, new Thermo(17.7, 28.1, -31.3, 14.0, 0.0686, -6.06, 47.9), new Hazard(1, 1, 0)), new Fusion(1358.0), new ChemicalPhaseProperties.Liquid(8.02, new Thermo(17.5, 41.5, 32.8)), new Vaporization(2835.0), new ChemicalPhaseProperties.Gas(new Thermo(-80.5, 49.4, -7.58, 0.0405, 133.0, 520.0, 194.0))),
        Zn("zinc", 63.5, 2, new ChemicalPhaseProperties.Solid(new Color(230, 230, 230), 7.14, new Thermo(25.6, -4.41, 20.4, -7.4, -0.0458, -7.56, 72.9), new Hazard(2, 0, 0)), new Fusion(673.0), new ChemicalPhaseProperties.Liquid(6.57, new Thermo(6.52, 50.8, 31.4)), new Vaporization(1180.0), new ChemicalPhaseProperties.Gas(new Thermo(18.2, 2.31, -0.737, 0.08, 1.07, 127.0, 185.0))),
        Ga("gallium", 69.7, 3, new ChemicalPhaseProperties.Solid(new Color(212, 216, 220), 5.91, new Thermo(102.0, -348.0, 603.0, -361.0, -1.49, -24.7, 236.0), new Hazard(1, 0, 0)), new Fusion(303.0), new ChemicalPhaseProperties.Liquid(6.1, new Thermo(24.6, 2.7, -1.27, 0.197, 0.286, -0.909, 89.9)), new Vaporization(2673.0), new ChemicalPhaseProperties.Gas(new Thermo(20.3, 0.57, -0.21, 0.0258, 3.05, 273.0, 201.0))),
        As("arsenic", 74.9, 3, new ChemicalPhaseProperties.Solid(new Color(112, 112, 112), 5.73, new Thermo(0.0, 35.1, 21.6, 9.79), new Hazard(3, 2, 0)), null, null, new Vaporization(887.0), new ChemicalPhaseProperties.Gas(new Thermo(74.3))),
        O("oxygen", 16.0, -2),
        F("fluorine", 19.0, -1),
        Sr("strontium", 87.6, 2, new ChemicalPhaseProperties.Solid(new Color(212, 216, 220), 2.64, new Thermo(23.9, 9.3, 0.92, 0.0352, 0.00493, -7.53, 81.8), new Hazard(4, 0, 2, Hazard.SpecialCode.WATER_REACTIVE)), new Fusion(1050.0), new ChemicalPhaseProperties.Liquid(2.38, new Thermo(0.91, 50.9, 39.5)), new Vaporization(1650.0), new ChemicalPhaseProperties.Gas(new Thermo(19.4, 3.74, -3.19, 0.871, 0.054, 158.0, 187.0).addSegment(2700.0, -39.0, -1.7, 7.99, -0.852, 188.0, 355.0, 243.0))),
        Y("yttrium", 88.9, 3, new ChemicalPhaseProperties.Solid(new Color(212, 216, 220), 4.47, new Thermo(0.0, 44.4, 24.4, 6.99)), new Fusion(1799.0), new ChemicalPhaseProperties.Liquid(4.24, new Thermo(50.7)), new Vaporization(3203.0), new ChemicalPhaseProperties.Gas(new Thermo(164.0))),
        Zr("zirconium", 91.2, 4, new ChemicalPhaseProperties.Solid(new Color(212, 216, 220), 6.52, new Thermo(29.0, -12.6, 20.7, -5.91, -0.157, -8.79, 76.0), new Hazard(1, 1, 0)), new Fusion(2128.0), new ChemicalPhaseProperties.Liquid(5.8, new Thermo(17.4, 47.6, 41.8)), new Vaporization(4650.0), new ChemicalPhaseProperties.Gas(new Thermo(39.5, -6.52, 2.26, -0.194, -12.5, 578.0, 212.0))),
        Nb("niobium", 92.9, 5, new ChemicalPhaseProperties.Solid(new Color(135, 150, 160), 8.57, new Thermo(22.0, 9.89, -5.65, 1.76, 0.0218, -6.88, 60.5), new Hazard(1, 1, 0)), new Fusion(2750.0), new ChemicalPhaseProperties.Liquid(Double.NaN, new Thermo(29.7, 47.3, 33.5)), new Vaporization(5017.0), new ChemicalPhaseProperties.Gas(new Thermo(-14637.0, 5142.0, -675.0, 31.5, 47657.0, 42523.0, 6194.0))),
        Mo("molybdenum", 96.0, 4, new ChemicalPhaseProperties.Solid(new Color(105, 105, 105), 10.3, new Thermo(24.7, 3.96, -1.27, 1.15, -0.17, -8.11, 56.4).addSegment(1900.0, 1231.0, -963.0, 284.0, -28.0, -712.0, -1486.0, 574.0), new Hazard(1, 3, 0)), new Fusion(2896.0), new ChemicalPhaseProperties.Liquid(9.33, new Thermo(41.6, 43.1, 37.7)), new Vaporization(4912.0), new ChemicalPhaseProperties.Gas(new Thermo(67.9, -40.5, 11.7, -0.819, -22.1, 601.0, 232.0))),
        Rb("rubidium", 85.5, 1, new ChemicalPhaseProperties.Solid(new Color(175, 175, 175), 1.53, new Thermo(9.45, 65.3, 45.5, -26.8, -0.108, -6.43, 66.3), new Hazard(2, 3, 0, Hazard.SpecialCode.WATER_REACTIVE)), new Fusion(312.0), new ChemicalPhaseProperties.Liquid(1.46, new Thermo(35.5, -12.9, 8.55, -0.00283, -1.19E-4, -7.9, 130.0)), new Vaporization(961.0), new ChemicalPhaseProperties.Gas(new Thermo(20.6, 0.462, -0.495, 0.174, 0.00439, 74.7, 195.0).addSegment(1800.0, 74.1, -39.2, 9.91, -0.679, -35.1, 4.97, 214.0))),
        Ag("silver", 108.0, 1, new ChemicalPhaseProperties.Solid(new Color(213, 213, 213), 10.5, new Thermo(0.0, 42.6, 23.4, 6.28), new Hazard(1, 1, 0)), new Fusion(1235.0), new ChemicalPhaseProperties.Liquid(9.32, new Thermo(24.7, 52.3, 339.0, -45.0)), new Vaporization(1.95, 2505.0, -1195.0), new ChemicalPhaseProperties.Gas(new Thermo(285.0, 173.0, Double.NaN))),
        Cd("cadmium", 112.0, 2, new ChemicalPhaseProperties.Solid(new Color(190, 190, 210), 8.65, new Thermo(0.0, 51.8, 22.8, 10.3), new Hazard(2, 2, 0)), new Fusion(594.0), new ChemicalPhaseProperties.Liquid(8.0, new Thermo(Double.NaN, 62.2, 29.7)), new Vaporization(1040.0), new ChemicalPhaseProperties.Gas(new Thermo(112.0, 168.0, 20.8))),
        Sn("tin", 119.0, 4, new ChemicalPhaseProperties.Solid(new Color(212, 216, 220), 7.28, new Thermo(0.0, 51.2, 23.1, 19.6), new Hazard(1, 3, 3)), new Fusion(505.0), new ChemicalPhaseProperties.Liquid(6.97, new Thermo(65.1)), new Vaporization(6.6, 16867.0, 15.5), new ChemicalPhaseProperties.Gas(new Thermo(168.0))),
        Sb("antimony", 122.0, 3, new ChemicalPhaseProperties.Solid(new Color(212, 216, 220), 6.7, new Thermo(0.0, 45.7, 23.1, 7.45), new Hazard(4, 4, 2)), new Fusion(904.0), new ChemicalPhaseProperties.Liquid(6.53, new Thermo(67.6)), new Vaporization(2.26, 4475.0, -152.0), new ChemicalPhaseProperties.Gas(new Thermo(168.0))),
        Cs("caesium", 133.0, 1, new ChemicalPhaseProperties.Solid(new Color(170, 160, 115), 1.93, new Thermo(57.0, -50.0, 48.6, -16.7, -1.22, -19.3, 160.0), new Hazard(4, 3, 3, Hazard.SpecialCode.WATER_REACTIVE)), new Fusion(302.0), new ChemicalPhaseProperties.Liquid(1.84, new Thermo(30.0, 0.506, 0.348, -0.0995, 0.197, -6.23, 129.0)), new Vaporization(3.7, 3453.0, -26.8), new ChemicalPhaseProperties.Gas(new Thermo(76.5, 175.0, 20.8).addSegment(1000.0, 34.5, -13.8, 4.13, -0.138, -3.95, 58.2, 211.0).addSegment(4000.0, -181.0, 80.0, -9.19, 0.33, 374.0, 518.0, 242.0))),
        Ba("barium", 137.0, 2, new ChemicalPhaseProperties.Solid(new Color(70, 70, 70), 3.51, new Thermo(83.8, -406.0, 915.0, -520.0, -14.6, 248.0).addSegment(583.0, 76.7, -188.0, 296.0, -114.0, -4.34, -25.6, 189.0).addSegment(768.0, 26.2, 28.6, -23.7, 6.95, 1.04, -5.8, 90.0), new Hazard(2, 1, 2)), new Fusion(1000.0), new ChemicalPhaseProperties.Liquid(3.34, new Thermo(55.0, -18.7, 2.76, 1.28, 3.02, -8.42, 135.0)), new Vaporization(4.08, 7599.0, -45.7), new ChemicalPhaseProperties.Gas(new Thermo(-623.0, 430.0, -97.0, 7.47, 488.0, 1077.0, 19.0).addSegment(4000.0, 770.0, -284.0, 41.4, -2.13, -1693.0, -1666.0, -26.3))),
        Ta("tantalum", 181.0, 5, new ChemicalPhaseProperties.Solid(new Color(185, 190, 200), 16.7, new Thermo(20.7, 17.3, -15.7, 5.61, 0.0616, -6.6, 62.4).addSegment(1300.0, -43.9, 73.0, -27.4, 4.0, 26.3, 60.2, 25.7), new Hazard(1, 1, 0)), new Fusion(3290.0), new ChemicalPhaseProperties.Liquid(15.0, new Thermo(30.8, 50.4, 41.8)), new Vaporization(5731.0), new ChemicalPhaseProperties.Gas(new Thermo(29.5, 3.42, -0.566, 0.0697, -4.93, 763.0, 208.0))),
        W("tungsten", 184.0, 6, new ChemicalPhaseProperties.Solid(new Color(140, 140, 140), 19.3, new Thermo(24.0, 2.64, 1.26, -0.255, -0.0484, -7.43, 60.5).addSegment(1900.0, -22.6, 90.3, -44.3, 7.18, -24.1, -9.98, -14.2), new Hazard(1, 2, 1)), new Fusion(3695.0), new ChemicalPhaseProperties.Liquid(17.6, new Thermo(46.9, 45.7, 35.6)), new Vaporization(6203.0), new ChemicalPhaseProperties.Gas(new Thermo(174.0))),
        Re("rhenium", 186.0, 7, new ChemicalPhaseProperties.Solid(new Color(212, 216, 220), 21.0, new Thermo(0.0, 36.9, 26.4, 2.22)), new Fusion(3459.0), new ChemicalPhaseProperties.Liquid(18.9, new Thermo(54.4))),
        Au("gold", 197.0, 3, new ChemicalPhaseProperties.Solid(new Color(255, 215, 0), 19.3, new Thermo(0.0, 47.4, 23.2, 6.16, -0.618, -0.0355), new Hazard(2, 0, 0)), new Fusion(1337.0), new ChemicalPhaseProperties.Liquid(17.3, new Thermo(57.8)), new Vaporization(5.47, 17292.0, -71.0), new ChemicalPhaseProperties.Gas(new Thermo(366.0, 180.0, 20.8))),
        Hg("mercury", 201.0, 2, new ChemicalPhaseProperties.Solid(new Color(155, 155, 155), 14.25, new Thermo(-2.18, 66.1, 21.5, 29.2)), new Fusion(234.0), new ChemicalPhaseProperties.Liquid(new Color(188, 188, 188), 13.5, new Thermo(0.0, 75.9, 28.0), new Hazard(3, 0, 0), new ChemicalPhaseProperties.Liquid.Yaws(-0.275, 137.0, 4.18E-6, -1.2E-9)), new Vaporization(4.86, 3007.0, -10.0), new ChemicalPhaseProperties.Gas(new Thermo(20.7, 0.179, -0.0801, 0.0105, 0.00701, 55.2, 200.0))),
        Pb("lead", 207.0, 2, new ChemicalPhaseProperties.Solid(new Color(65, 65, 65), 11.3, new Thermo(25.0, 5.44, 4.06, -1.24, -0.0107, -7.77, 93.2), new Hazard(2, 0, 0)), new Fusion(601.0), new ChemicalPhaseProperties.Liquid(10.7, new Thermo(38.0, -14.6, 7.26, -1.03, -0.331, -7.94, 119.0)), new Vaporization(2022.0), new ChemicalPhaseProperties.Gas(new Thermo(-85.7, 69.3, -13.3, 0.84, 63.1, 333.0, 170.0))),
        Bi("bismuth", 209.0, 3, new ChemicalPhaseProperties.Solid(new Color(213, 213, 213), 9.78, new Thermo(0.0, 56.7, 21.1, 14.7)), new Fusion(545.0), new ChemicalPhaseProperties.Liquid(10.1, new Thermo(0.0, 77.4, 31.8)), new Vaporization(1837.0), new ChemicalPhaseProperties.Gas(new Thermo(175.0))),
        Ce("cerium", 140.0, 3, new ChemicalPhaseProperties.Solid(new Color(212, 216, 220), 6.77, new Thermo(0.0, 72.0, 24.6, 0.005), new Hazard(2, 3, 2)), new Fusion(1068.0), new ChemicalPhaseProperties.Liquid(6.55, new Thermo(77.1)), new Vaporization(3716.0), new ChemicalPhaseProperties.Gas(new Thermo(184.0))),
        La("lanthanum", 139.0, 3, new ChemicalPhaseProperties.Solid(new Color(212, 216, 220), 6.16, new Thermo(0.0, 56.9, 24.7, 4.0), new Hazard(2, 3, 2)), new Fusion(1193.0), new ChemicalPhaseProperties.Liquid(5.94, new Thermo(62.1)), new Vaporization(3737.0), new ChemicalPhaseProperties.Gas(new Thermo(169.0))),
        Nd("neodynium", 144.0, 3, new ChemicalPhaseProperties.Solid(new Color(212, 216, 220), 7.01, new Thermo(0.0, 71.6, 26.2, 4.0), new Hazard(2, 3, 2)), new Fusion(1297.0), new ChemicalPhaseProperties.Liquid(6.89, new Thermo(77.1)), new Vaporization(3347.0), new ChemicalPhaseProperties.Gas(new Thermo(163.0))),
        Pr("praseodynium", 141.0, 3, new ChemicalPhaseProperties.Solid(new Color(212, 216, 220), 6.77, new Thermo(0.0, 73.2, 26.0, 4.0), new Hazard(2, 3, 2)), new Fusion(1208.0), new ChemicalPhaseProperties.Liquid(6.5, new Thermo(78.9)), new Vaporization(3403.0), new ChemicalPhaseProperties.Gas(new Thermo(176.0))),
        Th("thorium", 232.0, 4, new ChemicalPhaseProperties.Solid(new Color(64, 69, 70), 11.7, new Thermo(0.0, 51.8, 24.3, 10.2)), new Fusion(2115.0), new ChemicalPhaseProperties.Liquid(Double.NaN, new Thermo(58.3)), new Vaporization(5061.0), new ChemicalPhaseProperties.Gas(new Thermo(160.0))),
        U("uranium", 238.0, 6, new ChemicalPhaseProperties.Solid(new Color(95, 95, 95), 19.1, new Thermo(0.0, 50.2, 9.68, 41.0, -2.65, 53.7).addSegment(672.0, 41.0, 2.93).addSegment(772.0, 42.0, 4.79)), new Fusion(1405.0), new ChemicalPhaseProperties.Liquid(17.3, new Thermo(56.7)), new Vaporization(4404.0), new ChemicalPhaseProperties.Gas(new Thermo(200.0)));

        private Chemical delegate;
        private double atomicWeight;
        private int defaultOxidationState;

        private Elements(String oreDictKey, double atomicWeight, int defaultOxidationState, ChemicalPhaseProperties.Solid solid, Fusion fusion, ChemicalPhaseProperties.Liquid liquid, Vaporization vaporization, ChemicalPhaseProperties.Gas gas) {
            Formula formula = new Formula(this._(1));
            this.delegate = new SimpleChemical(formula, oreDictKey, solid, fusion, liquid, vaporization, gas);
            this.atomicWeight = atomicWeight;
            this.defaultOxidationState = defaultOxidationState;
        }

        private Elements(String oreDictKey, double atomicWeight, int defaultOxidationState, ChemicalPhaseProperties.Solid solid, Fusion fusion, ChemicalPhaseProperties.Liquid liquid, Vaporization vaporization) {
            this(oreDictKey, atomicWeight, defaultOxidationState, solid, fusion, liquid, vaporization, null);
        }

        private Elements(String oreDictKey, double atomicWeight, int defaultOxidationState, ChemicalPhaseProperties.Solid solid, Fusion fusion, ChemicalPhaseProperties.Liquid liquid) {
            this(oreDictKey, atomicWeight, defaultOxidationState, solid, fusion, liquid, null);
        }

        private Elements(String oreDictKey, double atomicWeight, int defaultOxidationState, ChemicalPhaseProperties.Solid solid, Fusion fusion) {
            this(oreDictKey, atomicWeight, defaultOxidationState, solid, fusion, null);
        }

        private Elements(String oreDictKey, double atomicWeight, int defaultOxidationState, ChemicalPhaseProperties.Solid solid) {
            this(oreDictKey, atomicWeight, defaultOxidationState, solid, null);
        }

        private Elements(String oreDictKey, double atomicWeight, int defaultOxidationState) {
            this(oreDictKey, atomicWeight, defaultOxidationState, null);
        }

        @Override
        public Fusion getFusion() {
            return this.delegate.getFusion();
        }

        @Override
        public Vaporization getVaporization() {
            return this.delegate.getVaporization();
        }

        @Override
        public String getOreDictKey() {
            return this.delegate.getOreDictKey();
        }

        @Override
        public ChemicalConditionProperties getProperties(Condition condition) {
            return this.delegate.getProperties(condition);
        }

        @Override
        public Mixture mix(IndustrialMaterial material, double weight) {
            return this.delegate.mix(material, weight);
        }

        @Override
        public Formula getFormula() {
            return this.delegate.getFormula();
        }

        @Override
        public Formula.Part _(int quantity) {
            return new Formula.Part(this, quantity);
        }

        @Override
        public Formula.Part getPart() {
            return this._(1);
        }

        @Override
        public double getAtomicWeight() {
            return this.atomicWeight;
        }

        @Override
        public int getDefaultOxidationState() {
            return this.defaultOxidationState;
        }
    }
}

