/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.chemica.model;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import org.pfaa.chemica.model.Condition;

public class Hazard {
    public final int health;
    public final int flammability;
    public final int instability;
    public final SpecialCode special;
    private static final double[] IGNITION_TEMP_LIMITS = new double[]{Double.POSITIVE_INFINITY, 500.0, 400.0, 298.0, 200.0};
    private static final double[] EXPLOSION_TEMP_LIMITS = new double[]{Double.POSITIVE_INFINITY, 500.0, 400.0, 300.0, 298.0};

    public Hazard(int health, int flammability, int instability, SpecialCode special) {
        if (health < 0 || health > 4) {
            throw new IllegalArgumentException("'health' must be in [0,4]");
        }
        if (flammability < 0 || flammability > 4) {
            throw new IllegalArgumentException("'flammability' must be in [0,4]");
        }
        if (instability < 0 || instability > 4) {
            throw new IllegalArgumentException("'instability' must be in [0,4]");
        }
        this.health = health;
        this.flammability = flammability;
        this.instability = instability;
        this.special = special;
    }

    public Hazard(int health, int flammability, int instability) {
        this(health, flammability, instability, SpecialCode.NONE);
    }

    public Hazard() {
        this(1, 0, 0);
    }

    public boolean isFlammable(Condition condition) {
        return condition.temperature >= IGNITION_TEMP_LIMITS[this.flammability];
    }

    public int getExplosionRadius(Condition condition) {
        if (condition.temperature >= EXPLOSION_TEMP_LIMITS[this.instability]) {
            return this.instability;
        }
        return 0;
    }

    private PotionEffect createPotionEffect(Potion potion, int durationAmplifier) {
        return new PotionEffect(potion.field_76415_H, 20 * (int)Math.pow(2.0, this.health + durationAmplifier));
    }

    public List<PotionEffect> getContactEffects() {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        if (this.health >= 2) {
            effects.add(this.createPotionEffect(Potion.field_76436_u, 0));
        }
        return effects;
    }

    public List<PotionEffect> getIngestionEffects() {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        if (this.health >= 1) {
            effects.add(this.createPotionEffect(Potion.field_76431_k, 1));
        }
        if (this.health >= 2) {
            effects.add(this.createPotionEffect(Potion.field_76436_u, 1));
        }
        return effects;
    }

    public static enum SpecialCode {
        NONE,
        OXIDIZER,
        WATER_REACTIVE,
        SIMPLE_ASPHYXIANT,
        CORROSIVE,
        BIOHAZARD,
        POISONOUS,
        RADIOACTIVE,
        CRYOGENIC;

    }
}

