/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.geologica;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.pfaa.chemica.model.IndustrialMaterial;
import org.pfaa.geologica.GeoMaterial;
import org.pfaa.geologica.integration.GTIntegration;
import org.pfaa.geologica.processing.Aggregate;

public class GeologicaConfiguration {
    private Configuration config;

    public GeologicaConfiguration(Configuration config) {
        this.config = config;
    }

    public GeologicaConfiguration(File file) {
        this(new Configuration(file));
    }

    public int getHarvestLevel(Class<? extends IndustrialMaterial> composition, GeoMaterial.Strength strength) {
        String key = composition.getSimpleName() + "." + strength.ordinal() + "_" + (Object)((Object)strength);
        Property prop = this.config.get("HarvestLevels", key, this.getDefaultHarvestLevel(composition, strength), "Harvest level for " + (Object)((Object)strength) + " " + composition.getSimpleName());
        return prop.getInt();
    }

    private int getDefaultHarvestLevel(Class<? extends IndustrialMaterial> composition, GeoMaterial.Strength strength) {
        int level = 0;
        switch (strength) {
            case WEAK: {
                level = 0;
                break;
            }
            case MEDIUM: {
                level = 1;
                break;
            }
            case STRONG: {
                level = 1;
                if (Aggregate.class.isAssignableFrom(composition)) break;
                ++level;
                break;
            }
            case VERY_STRONG: {
                level = 2;
                break;
            }
        }
        return level;
    }

    public void save() {
        this.config.save();
    }

    public float getInitialStoneToolDamage(GeoMaterial.Strength strength) {
        Property prop = this.config.get("InitialStoneToolDamage", strength.name(), (double)GeologicaConfiguration.getDefaultInitialStoneToolDamage(strength), "Fraction damaged for " + (Object)((Object)strength) + " stone tools");
        return (float)prop.getDouble(0.0);
    }

    private static float getDefaultInitialStoneToolDamage(GeoMaterial.Strength strength) {
        float damage;
        if (GTIntegration.isGregtechInstalled()) {
            return GTIntegration.getDefaultInitialStoneToolDamage(strength);
        }
        switch (strength) {
            case WEAK: {
                damage = 0.75f;
                break;
            }
            case MEDIUM: {
                damage = 0.5f;
                break;
            }
            default: {
                damage = 0.0f;
            }
        }
        return damage;
    }

    public float getRockHardness(GeoMaterial.Strength strength) {
        Property prop = this.config.get("RockHardness", strength.ordinal() + "_" + strength.name(), (double)GeologicaConfiguration.getDefaultRockHardness(strength), "Hardness for " + (Object)((Object)strength) + " rocks");
        Property mult = this.config.get("RockHardness", "multiplier", 1.0, "Multiplier of all rock hardness values");
        return (float)prop.getDouble(0.0) * (float)mult.getDouble(1.0);
    }

    public float getRockResistance(GeoMaterial.Strength strength) {
        Property mult = this.config.get("RockResistance", "multiplier", 5.0, "Multiplier that transforms hardness to resistance");
        return this.getRockHardness(strength) * (float)mult.getDouble(5.0);
    }

    private static float getDefaultRockHardness(GeoMaterial.Strength strength) {
        float hardness = 0.0f;
        switch (strength) {
            case WEAK: {
                hardness = 1.0f;
                break;
            }
            case MEDIUM: {
                hardness = 2.0f;
                break;
            }
            case STRONG: {
                hardness = 3.0f;
                break;
            }
            case VERY_STRONG: {
                hardness = 4.0f;
                break;
            }
        }
        return hardness;
    }

    public boolean isVanillaOreOverrideEnabled() {
        Property bool = this.config.get("Toggles", "overrideVanillaOreBlocks", false, "Whether to replace vanilla ore blocks with blocks that drop ore blocks, instead of items (DEPRECATED; do not change)");
        return bool.getBoolean(false);
    }

    public boolean isVanillaOreGemDropEnabled() {
        Property bool = this.config.get("Toggles", "vanillaOreDropsGems", true, "Whether vanilla ore blocks should drop gems, as they do in vanilla");
        return bool.getBoolean(false);
    }
}

