/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.geologica.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.pfaa.chemica.model.IndustrialMaterial;
import org.pfaa.geologica.GeoMaterial;
import org.pfaa.geologica.GeologicaBlocks;
import org.pfaa.geologica.block.GeoBlock;
import org.pfaa.geologica.processing.Aggregate;

public class IntactGeoBlock
extends GeoBlock {
    private static Set<Block> stoneBlocks;

    public IntactGeoBlock(GeoMaterial.Strength strength, Class<? extends IndustrialMaterial> composition, Material material) {
        super(strength, composition, material);
    }

    public Item func_149650_a(int meta, Random random, int par3) {
        Item dropped = super.func_149650_a(meta, random, par3);
        GeoMaterial material = this.getGeoMaterial(meta);
        if (material.getComposition() instanceof Aggregate && this.field_149764_J == Material.field_151576_e) {
            dropped = this.dropRock(meta);
        }
        return dropped;
    }

    private Item dropRock(int meta) {
        Item dropped = null;
        GeoMaterial material = this.getGeoMaterial(meta);
        switch (material.getStrength()) {
            case WEAK: {
                dropped = Item.func_150898_a((Block)GeologicaBlocks.WEAK_RUBBLE);
                break;
            }
            case MEDIUM: {
                dropped = Item.func_150898_a((Block)GeologicaBlocks.MEDIUM_COBBLE);
                break;
            }
            case STRONG: {
                dropped = Item.func_150898_a((Block)GeologicaBlocks.STRONG_COBBLE);
                break;
            }
            case VERY_STRONG: {
                dropped = Item.func_150898_a((Block)this);
                break;
            }
        }
        return dropped;
    }

    protected boolean func_149700_E() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getHostIcon(IndustrialMaterial host, IBlockAccess world, int x, int y, int z) {
        if (host == Aggregate.Aggregates.STONE) {
            return IntactGeoBlock.getAdjacentStoneIcon(world, x, y, z);
        }
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new HostTileEntity();
    }

    public boolean hasTileEntity(int metadata) {
        return metadata < this.getMetaCount() ? this.getGeoMaterial(metadata).getHost() instanceof Aggregate : false;
    }

    @SideOnly(value=Side.CLIENT)
    private static IIcon getAdjacentStoneIcon(IBlockAccess world, int x, int y, int z) {
        HostTileEntity te;
        if (stoneBlocks == null) {
            IntactGeoBlock.initStoneBlocks();
        }
        if ((te = (HostTileEntity)world.func_147438_o(x, y, z)) == null) {
            return null;
        }
        ItemStack host = te.getHost();
        if (host == null) {
            host = IntactGeoBlock.getAdjacentStone(world, x, y, z);
            if (host == null) {
                return null;
            }
            te.setHost(host);
        }
        Block block = ((ItemBlock)host.func_77973_b()).field_150939_a;
        return block.func_149691_a(0, host.func_77960_j());
    }

    private static void initStoneBlocks() {
        stoneBlocks = new HashSet<Block>();
        ArrayList ores = OreDictionary.getOres((String)"stone");
        for (ItemStack ore : ores) {
            Item item = ore.func_77973_b();
            if (!(item instanceof ItemBlock)) continue;
            stoneBlocks.add(((ItemBlock)item).field_150939_a);
        }
    }

    private static ItemStack getAdjacentStone(IBlockAccess world, int x, int y, int z) {
        for (int ix = x - 1; ix <= x + 1; ++ix) {
            for (int iy = y - 1; iy <= y + 1; ++iy) {
                for (int iz = z - 1; iz <= z + 1; ++iz) {
                    Block block = world.func_147439_a(ix, iy, iz);
                    if (!stoneBlocks.contains(block)) continue;
                    int meta = world.func_72805_g(ix, iy, iz);
                    return new ItemStack(block, 1, meta);
                }
            }
        }
        return null;
    }

    public static class HostTileEntity
    extends TileEntity {
        private ItemStack host;

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            NBTTagCompound hostTag = nbt.func_74775_l("host");
            if (hostTag != null) {
                this.host = ItemStack.func_77949_a((NBTTagCompound)hostTag);
            }
        }

        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            if (this.host != null) {
                NBTTagCompound hostTag = new NBTTagCompound();
                this.host.func_77955_b(hostTag);
                nbt.func_74782_a("host", (NBTBase)hostTag);
            }
        }

        public ItemStack getHost() {
            return this.host;
        }

        public void setHost(ItemStack host) {
            this.host = host;
        }
    }
}

