/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.geologica.client.registration;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.item.Item;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.pfaa.block.CompositeBlockAccessors;
import org.pfaa.geologica.GeologicaBlocks;
import org.pfaa.geologica.client.registration.CompositeBlockRenderer;
import org.pfaa.geologica.client.registration.StairsCompositeBlockRenderer;
import org.pfaa.geologica.client.render.CompositeBlockItemRenderer;
import org.pfaa.geologica.client.render.FallingCompositeBlockRenderer;
import org.pfaa.geologica.registration.CommonRegistrant;

public class ClientRegistrant
extends CommonRegistrant {
    private CompositeBlockRenderer compositeBlockRenderer;
    private CompositeBlockRenderer stairsCompositeBlockRenderer;

    @Override
    public void register() {
        super.register();
        this.registerRenderers();
    }

    private void registerRenderers() {
        CompositeBlockItemRenderer renderer = new CompositeBlockItemRenderer();
        for (Block block : GeologicaBlocks.getBlocks()) {
            if (!(block instanceof CompositeBlockAccessors)) continue;
            MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)block), (IItemRenderer)renderer);
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityFallingBlock.class, (Render)new FallingCompositeBlockRenderer());
        this.compositeBlockRenderer = new CompositeBlockRenderer(RenderingRegistry.getNextAvailableRenderId());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this.compositeBlockRenderer);
        this.stairsCompositeBlockRenderer = new StairsCompositeBlockRenderer(RenderingRegistry.getNextAvailableRenderId());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this.stairsCompositeBlockRenderer);
    }

    @Override
    public int getCompositeBlockRendererId() {
        return this.compositeBlockRenderer.getRenderId();
    }

    @Override
    public int getStairsCompositeBlockRendererId() {
        return this.stairsCompositeBlockRenderer.getRenderId();
    }
}

