/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.geologica.processing;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.pfaa.chemica.model.Chemical;
import org.pfaa.chemica.model.ChemicalPhaseProperties;
import org.pfaa.chemica.model.CompoundDictionary;
import org.pfaa.chemica.model.Condition;
import org.pfaa.chemica.model.ConditionProperties;
import org.pfaa.chemica.model.Formula;
import org.pfaa.chemica.model.Mixture;
import org.pfaa.chemica.model.MixtureComponent;
import org.pfaa.chemica.model.SimpleChemical;
import org.pfaa.geologica.processing.OreMineral;
import org.pfaa.geologica.processing.SimpleMineral;

public class SimpleOreMineral
extends SimpleMineral
implements OreMineral {
    private Color overrideColor;

    public SimpleOreMineral(Chemical concentrate, OreMineral.Substitution ... substitutions) {
        this(concentrate, (Color)null, substitutions);
    }

    public SimpleOreMineral(Chemical concentrate, Color overrideColor, OreMineral.Substitution ... substitutions) {
        this(SimpleOreMineral.substitute(concentrate, substitutions), overrideColor);
    }

    public SimpleOreMineral(Mixture mixture) {
        this(mixture.getComponents());
    }

    public SimpleOreMineral(List<MixtureComponent> components, Color overrideColor) {
        super(components);
        this.overrideColor = overrideColor;
    }

    public SimpleOreMineral(List<MixtureComponent> components) {
        this(components, null);
    }

    @Override
    public String name() {
        return this.getOreDictKey() + "Ore";
    }

    @Override
    public String getOreDictKey() {
        return this.getConcentrate().getOreDictKey();
    }

    @Override
    public Chemical getConcentrate() {
        return (Chemical)this.getComponents().get((int)0).material;
    }

    private static List<MixtureComponent> substitute(Chemical concentrate, OreMineral.Substitution[] substitutions) {
        ArrayList<MixtureComponent> components = new ArrayList<MixtureComponent>();
        components.add(new MixtureComponent(concentrate, 1.0));
        for (OreMineral.Substitution substitution : substitutions) {
            Formula formula = concentrate.getFormula().substituteFirstPart(substitution.getMaterial());
            Chemical compound = CompoundDictionary.lookup(formula);
            if (compound == null) {
                compound = new SimpleChemical(formula, substitution.material.getOreDictKey(), new ChemicalPhaseProperties.Solid());
            }
            components.add(new MixtureComponent(compound, substitution.weight));
        }
        return components;
    }

    @Override
    public ConditionProperties getProperties(Condition condition) {
        ConditionProperties props = super.getProperties(condition);
        if (this.overrideColor != null) {
            props = props.recolor(this.overrideColor);
        }
        return props;
    }
}

