/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.pfaa.geologica.Geologica;

public class RecipeUtils {
    public static void oreDictifyRecipes(Map<ItemStack, String> replacements, ItemStack[] exclusions) {
        ItemStack[] replaceStacks = replacements.keySet().toArray(new ItemStack[0]);
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        ArrayList<IRecipe> recipesToRemove = new ArrayList<IRecipe>();
        ArrayList<IRecipe> recipesToAdd = new ArrayList<IRecipe>();
        for (IRecipe recipe : recipes) {
            Object[] ingredients;
            ItemStack output = recipe.func_77571_b();
            if (output != null && RecipeUtils.hasItem(false, exclusions, output) || !RecipeUtils.hasItem(true, ingredients = RecipeUtils.getIngredients(recipe), replaceStacks)) continue;
            try {
                recipesToAdd.add(RecipeUtils.createOreRecipe(recipe, replacements));
                recipesToRemove.add(recipe);
            }
            catch (Exception e) {
                Geologica.log.warn("Failed to ore dictify recipe for '" + output.func_77977_a() + "'");
            }
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
    }

    private static Object[] getIngredients(IRecipe obj) {
        if (obj instanceof ShapedRecipes) {
            return ((ShapedRecipes)obj).field_77574_d;
        }
        if (obj instanceof ShapelessRecipes) {
            return ((ShapelessRecipes)obj).field_77579_b.toArray();
        }
        if (obj instanceof ShapedOreRecipe) {
            return ((ShapedOreRecipe)obj).getInput();
        }
        if (obj instanceof ShapelessOreRecipe) {
            return ((ShapelessOreRecipe)obj).getInput().toArray();
        }
        return new Object[0];
    }

    private static boolean hasItem(boolean strict, Object[] recipe, ItemStack ... ingredients) {
        for (Object recipeIngredient : recipe) {
            if (!(recipeIngredient instanceof ItemStack)) continue;
            for (ItemStack ingredient : ingredients) {
                if (!OreDictionary.itemMatches((ItemStack)ingredient, (ItemStack)((ItemStack)recipeIngredient), (boolean)strict)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasItem(boolean strict, List<ItemStack> recipe, ItemStack ... ingredients) {
        return RecipeUtils.hasItem(strict, recipe.toArray(new ItemStack[0]), ingredients);
    }

    private static <T extends IRecipe> T createOreRecipe(Class<T> klass, IRecipe recipe, Map<ItemStack, String> replacements) throws Exception {
        Constructor<T> constructor = klass.getDeclaredConstructor(recipe.getClass(), Map.class);
        constructor.setAccessible(true);
        IRecipe replacedRecipe = (IRecipe)constructor.newInstance(recipe, replacements);
        return (T)replacedRecipe;
    }

    private static IRecipe createOreRecipe(IRecipe recipe, Map<ItemStack, String> replacements) throws Exception {
        if (recipe instanceof ShapedRecipes) {
            return RecipeUtils.createOreRecipe(ShapedOreRecipe.class, recipe, replacements);
        }
        if (recipe instanceof ShapelessRecipes) {
            return RecipeUtils.createOreRecipe(ShapelessOreRecipe.class, recipe, replacements);
        }
        if (recipe instanceof ShapedOreRecipe) {
            return RecipeUtils.recreateOreRecipe((ShapedOreRecipe)recipe, replacements);
        }
        if (recipe instanceof ShapelessOreRecipe) {
            return RecipeUtils.recreateOreRecipe((ShapelessOreRecipe)recipe, replacements);
        }
        throw new IllegalArgumentException("Unknown recipe type");
    }

    private static IRecipe recreateOreRecipe(ShapelessOreRecipe recipe, Map<ItemStack, String> replacements) {
        Object[] ingredients = recipe.getInput().toArray();
        RecipeUtils.replaceIngredients(ingredients, replacements);
        return new ShapelessOreRecipe(recipe.func_77571_b(), ingredients);
    }

    private static IRecipe recreateOreRecipe(ShapedOreRecipe recipe, Map<ItemStack, String> replacements) {
        Object[] ingredients = (Object[])recipe.getInput().clone();
        RecipeUtils.replaceIngredients(ingredients, replacements);
        return RecipeUtils.recreateOreRecipe(recipe, recipe.func_77571_b(), ingredients);
    }

    public static IRecipe recreateOreRecipe(ShapedOreRecipe template, ItemStack output, Object[] input) {
        int width = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)template, (String[])new String[]{"width"});
        int height = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)template, (String[])new String[]{"height"});
        for (int i = 0; i < input.length; ++i) {
            if (!(input[i] instanceof String)) continue;
            input[i] = OreDictionary.getOres((String)((String)input[i]));
        }
        ShapedOreRecipe recipe = new ShapedOreRecipe(output, new Object[]{Character.valueOf('x'), Blocks.field_150467_bQ});
        ObfuscationReflectionHelper.setPrivateValue(ShapedOreRecipe.class, (Object)recipe, (Object)input, (String[])new String[]{"input"});
        ObfuscationReflectionHelper.setPrivateValue(ShapedOreRecipe.class, (Object)recipe, (Object)width, (String[])new String[]{"width", "width"});
        ObfuscationReflectionHelper.setPrivateValue(ShapedOreRecipe.class, (Object)recipe, (Object)height, (String[])new String[]{"height", "height"});
        return recipe;
    }

    private static void replaceIngredients(Object[] ingredients, Map<ItemStack, String> replacements) {
        block0: for (int i = 0; i < ingredients.length; ++i) {
            if (!(ingredients[i] instanceof ItemStack)) continue;
            ItemStack ingredient = (ItemStack)ingredients[i];
            for (Map.Entry<ItemStack, String> replace : replacements.entrySet()) {
                if (!OreDictionary.itemMatches((ItemStack)replace.getKey(), (ItemStack)ingredient, (boolean)true)) continue;
                ingredients[i] = replace.getValue();
                continue block0;
            }
        }
    }
}

