/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.chemica.fluid;

import java.awt.Color;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.pfaa.chemica.model.Chemical;
import org.pfaa.chemica.model.Condition;
import org.pfaa.chemica.model.ConditionProperties;
import org.pfaa.chemica.model.IndustrialMaterial;
import org.pfaa.chemica.model.Phase;

public class IndustrialFluid
extends Fluid {
    private Color color;
    private double pressure;
    private IndustrialMaterial material;
    private boolean opaque;

    public IndustrialFluid(String fluidName, IndustrialMaterial material) {
        super(fluidName);
        this.material = material;
    }

    public int getColor() {
        return this.color.getRGB();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isSuperHeated() {
        return this.getTemperature() >= 750;
    }

    public IndustrialMaterial getIndustrialMaterial() {
        return this.material;
    }

    public Condition getCondition() {
        return new Condition(this.getTemperature(), this.getPressure());
    }

    private void setCondition(Condition condition) {
        this.setTemperature((int)condition.temperature);
        this.setPressure(condition.pressure);
    }

    public double getPressure() {
        return this.pressure;
    }

    public void setPressure(double pressure) {
        this.pressure = pressure;
    }

    public static IndustrialFluid getCanonicalFluidForPhase(IndustrialMaterial material, Condition condition) {
        IndustrialFluid fluid;
        ConditionProperties props = material.getProperties(condition);
        if (props == null || props.phase == Phase.SOLID) {
            return null;
        }
        String name = (props.phase.name() + "_" + material.name()).toLowerCase();
        Fluid existingFluid = FluidRegistry.getFluid((String)name);
        if (existingFluid instanceof IndustrialFluid) {
            fluid = (IndustrialFluid)existingFluid;
        } else {
            Condition rounded = IndustrialFluid.roundCondition(material, props.phase);
            fluid = IndustrialFluid.createFluidForCondition(name, material, rounded);
            FluidRegistry.registerFluid((Fluid)fluid);
        }
        return fluid;
    }

    private static IndustrialFluid createFluidForCondition(String name, IndustrialMaterial material, Condition condition) {
        ConditionProperties props = material.getProperties(condition);
        IndustrialFluid fluid = new IndustrialFluid(name, material);
        fluid.setGaseous(props.phase == Phase.GAS);
        fluid.setDensity((int)IndustrialFluid.convertToForgeDensity(props.density));
        fluid.setCondition(condition);
        if (Double.isNaN(props.viscosity)) {
            if (fluid.isSuperHeated()) {
                fluid.setViscosity(FluidRegistry.LAVA.getViscosity());
            }
        } else {
            fluid.setViscosity((int)(props.viscosity / props.density * 1000.0));
        }
        fluid.setLuminosity(props.luminosity);
        fluid.setColor(props.color);
        fluid.setOpaque(props.opaque);
        return fluid;
    }

    private static double convertToForgeDensity(double density) {
        return (density <= 0.001225 ? density - 0.001225 : density) * 1000.0;
    }

    private static Condition roundCondition(IndustrialMaterial material, Phase phase) {
        double temperature = 298.0;
        if (material instanceof Chemical) {
            Chemical chemical = (Chemical)material;
            temperature = IndustrialFluid.getTemperatureClosestToStandard(chemical, phase);
        }
        return new Condition(temperature, 101.0);
    }

    private static double getTemperatureClosestToStandard(Chemical chemical, Phase phase) {
        switch (phase) {
            case SOLID: {
                return Math.min(chemical.getFusion().getTemperature(), 298.0);
            }
            case LIQUID: {
                return Math.max(chemical.getFusion().getTemperature(), 298.0);
            }
            case GAS: {
                return Math.max(chemical.getVaporization().getTemperature(), 298.0);
            }
        }
        return 298.0;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    public ConditionProperties getProperties() {
        return this.material.getProperties(this.getCondition());
    }

    public boolean isPollutant() {
        return true;
    }
}

