/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.chemica.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pfaa.chemica.model.Element;

public final class Formula {
    private List<Part> parts;
    private int hydration;
    private String smiles;

    public Formula(PartFactory ... parts) {
        this(Arrays.asList(parts));
    }

    private Formula(List<? extends PartFactory> parts) {
        ArrayList<Part> reifiedParts = new ArrayList<Part>();
        for (PartFactory partFactory : parts) {
            reifiedParts.add(partFactory.getPart());
        }
        this.parts = reifiedParts;
    }

    private Formula(Formula other) {
        this.parts = new ArrayList<Part>(other.parts);
        this.hydration = other.hydration;
        this.smiles = other.smiles;
    }

    public Part getFirstPart() {
        return this.parts.get(0);
    }

    public Part getLastPart() {
        return this.parts.get(this.parts.size() - 1);
    }

    public Formula setFirstPart(Part newPart) {
        Formula copy = new Formula(this);
        copy.parts.set(0, newPart);
        return copy;
    }

    public Formula substituteFirstPart(Element substitute) {
        return this.setFirstPart(substitute._(this.getFirstPart().stoichiometry));
    }

    public Formula setLastPart(Part newPart) {
        Formula copy = new Formula(this);
        copy.parts.set(copy.parts.size() - 1, newPart);
        return copy;
    }

    public String toString() {
        String name = "";
        for (Part part : this.parts) {
            name = name + part.toString();
        }
        return name;
    }

    public double getMolarMass() {
        double mass = 0.0;
        for (Part part : this.parts) {
            mass += part.getMolarMass();
        }
        return mass;
    }

    public Formula hydrate(int hydration) {
        Formula copy = new Formula(this);
        copy.hydration += hydration;
        return copy;
    }

    public List<Part> getParts() {
        return this.parts;
    }

    public int getHydration() {
        return this.hydration;
    }

    public Formula setSmiles(String smiles) {
        this.smiles = smiles;
        return this;
    }

    public static interface PartFactory {
        public Part getPart();
    }

    public static final class Part
    implements PartFactory {
        public final Element element;
        public final int stoichiometry;
        public final List<Part> parts;

        private Part(Element element, int stoichiometry, List<Part> parts) {
            this.parts = Collections.unmodifiableList(parts);
            this.stoichiometry = stoichiometry;
            this.element = element;
        }

        public Part(Element element, int stoichiometry) {
            this.element = element;
            this.stoichiometry = stoichiometry;
            this.parts = Collections.EMPTY_LIST;
        }

        public Part(PartFactory ... parts) {
            ArrayList<Part> reifiedParts = new ArrayList<Part>();
            for (PartFactory part : parts) {
                reifiedParts.add(part.getPart());
            }
            this.parts = Collections.unmodifiableList(reifiedParts);
            this.stoichiometry = 1;
            this.element = null;
        }

        public Part _(int stoichiometry) {
            return new Part(this.element, stoichiometry, this.parts);
        }

        public double getMolarMass() {
            double mass = 0.0;
            if (this.element != null) {
                mass = this.element.getAtomicWeight();
            } else {
                for (Part part : this.parts) {
                    mass += part.getMolarMass();
                }
            }
            return mass *= (double)this.stoichiometry;
        }

        public String toString() {
            String name = "";
            if (this.element != null) {
                name = this.element.name();
            } else {
                for (Part part : this.parts) {
                    name = name + part.toString();
                }
                if (this.parts.size() > 1) {
                    name = "(" + name + ")";
                }
            }
            if (this.stoichiometry > 1) {
                name = name + this.stoichiometry;
            }
            return name;
        }

        public boolean equals(Object other) {
            return other instanceof Part && other.toString() == this.toString();
        }

        @Override
        public Part getPart() {
            return this;
        }
    }
}

