/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.geologica.registration;

import com.google.common.base.CaseFormat;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.pfaa.RecipeUtils;
import org.pfaa.block.CompositeBlock;
import org.pfaa.chemica.model.Compound;
import org.pfaa.geologica.GeoMaterial;
import org.pfaa.geologica.Geologica;
import org.pfaa.geologica.GeologicaBlocks;
import org.pfaa.geologica.GeologicaItems;
import org.pfaa.geologica.block.BrickGeoBlock;
import org.pfaa.geologica.block.BrokenGeoBlock;
import org.pfaa.geologica.block.ChanceDropRegistry;
import org.pfaa.geologica.block.GeoBlock;
import org.pfaa.geologica.block.LooseGeoBlock;
import org.pfaa.geologica.block.ProxyBlock;
import org.pfaa.geologica.block.SlabBlock;
import org.pfaa.geologica.block.StairsBlock;
import org.pfaa.geologica.block.VanillaOreOverrideBlock;
import org.pfaa.geologica.block.WallBlock;
import org.pfaa.geologica.integration.FMPIntegration;
import org.pfaa.geologica.integration.IC2Integration;
import org.pfaa.geologica.integration.TCIntegration;
import org.pfaa.geologica.integration.TEIntegration;
import org.pfaa.geologica.processing.Aggregate;
import org.pfaa.geologica.processing.IndustrialMineral;
import org.pfaa.geologica.processing.Ore;
import org.pfaa.geologica.processing.OreMineral;

public class RecipeRegistration {
    public static void init() {
        RecipeRegistration.registerOres();
        RecipeRegistration.addSmeltingRecipes();
        RecipeRegistration.addCraftingRecipes();
        RecipeRegistration.addGrindingRecipes();
        RecipeRegistration.addMeltingRecipes();
        RecipeRegistration.addStoneToolRecipes();
        RecipeRegistration.addStoneAbstractionRecipesForBrokenMods();
        RecipeRegistration.registerMicroblocks();
        RecipeRegistration.registerOreDrops();
    }

    private static void addStoneAbstractionRecipesForBrokenMods() {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Blocks.field_150347_e), new Object[]{"cobblestone"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Blocks.field_150348_b), new Object[]{"stone"}));
    }

    private static void addStoneToolRecipes() {
        RecipeRegistration.addStoneToolRecipes(GeologicaBlocks.WEAK_RUBBLE);
        RecipeRegistration.addStoneToolRecipes(GeologicaBlocks.MEDIUM_COBBLE);
        RecipeRegistration.addStoneToolRecipes(GeologicaBlocks.STRONG_COBBLE);
        RecipeRegistration.addStoneToolRecipes(GeologicaBlocks.VERY_STRONG_COBBLE);
        if (Loader.isModLoaded((String)"TConstruct")) {
            TCIntegration.addStoneMaterials();
        }
    }

    private static void addStoneToolRecipes(GeoBlock block) {
        RecipeRegistration.addStoneToolRecipe(block, Items.field_151050_s);
        RecipeRegistration.addStoneToolRecipe(block, Items.field_151049_t);
        RecipeRegistration.addStoneToolRecipe(block, Items.field_151051_r);
        RecipeRegistration.addStoneToolRecipe(block, Items.field_151018_J);
        RecipeRegistration.addStoneToolRecipe(block, Items.field_151052_q);
    }

    private static void addStoneToolRecipe(GeoBlock block, Item tool) {
        ItemStack damaged = new ItemStack(tool, 1, (int)(RecipeRegistration.getInitialStoneToolDamage(block.getStrength()) * (float)tool.func_77612_l()));
        ItemStack material = new ItemStack((Block)block, 1, Short.MAX_VALUE);
        ItemStack cobblestone = new ItemStack(Blocks.field_150347_e, 1, Short.MAX_VALUE);
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe recipe : recipes) {
            ItemStack output = recipe.func_77571_b();
            if (output == null || output.func_77973_b() != tool || !(recipe instanceof ShapedOreRecipe)) continue;
            ShapedOreRecipe shapedRecipe = (ShapedOreRecipe)recipe;
            Object[] origIngredients = shapedRecipe.getInput();
            Object[] ingredients = (Object[])origIngredients.clone();
            for (int i = 0; i < ingredients.length; ++i) {
                if (ingredients[i] instanceof List) {
                    for (ItemStack ingredient : (List)ingredients[i]) {
                        if (ingredient.func_77973_b() != cobblestone.func_77973_b()) continue;
                        ingredients[i] = material;
                        origIngredients[i] = cobblestone;
                    }
                    continue;
                }
                if (!(ingredients[i] instanceof ItemStack) || ((ItemStack)ingredients[i]).func_77973_b() != cobblestone.func_77973_b()) continue;
                ingredients[i] = material;
            }
            recipes.add(RecipeUtils.recreateOreRecipe(shapedRecipe, damaged, ingredients));
            break;
        }
    }

    private static float getInitialStoneToolDamage(GeoMaterial.Strength strength) {
        return Geologica.getConfiguration().getInitialStoneToolDamage(strength);
    }

    private static void registerOres() {
        RecipeRegistration.oreDictifyGeoBlocks();
        RecipeRegistration.oreDictifyStoneBrick();
    }

    private static void addSmeltingRecipes() {
        RecipeRegistration.addSmeltingRecipesByMeta(GeologicaBlocks.WEAK_RUBBLE, GeologicaBlocks.WEAK_STONE, OreMineral.SmeltingTemperature.MEDIUM);
        RecipeRegistration.addSmeltingRecipesByMeta(GeologicaBlocks.MEDIUM_COBBLE, GeologicaBlocks.MEDIUM_STONE, OreMineral.SmeltingTemperature.MEDIUM);
        RecipeRegistration.addSmeltingRecipesByMeta(GeologicaBlocks.STRONG_COBBLE, GeologicaBlocks.STRONG_STONE, OreMineral.SmeltingTemperature.HIGH);
    }

    private static void addCraftingRecipes() {
        RecipeRegistration.addSlabRecipe(GeologicaBlocks.MEDIUM_COBBLE, (Block)GeologicaBlocks.MEDIUM_COBBLE_SLAB);
        RecipeRegistration.addSlabRecipe(GeologicaBlocks.STRONG_COBBLE, (Block)GeologicaBlocks.STRONG_COBBLE_SLAB);
        RecipeRegistration.addSlabRecipe(GeologicaBlocks.MEDIUM_STONE_BRICK, (Block)GeologicaBlocks.MEDIUM_STONE_BRICK_SLAB);
        RecipeRegistration.addSlabRecipe(GeologicaBlocks.STRONG_STONE_BRICK, (Block)GeologicaBlocks.STRONG_STONE_BRICK_SLAB);
        RecipeRegistration.addSlabRecipe(GeologicaBlocks.VERY_STRONG_STONE_BRICK, (Block)GeologicaBlocks.VERY_STRONG_STONE_BRICK_SLAB);
        RecipeRegistration.addSlabRecipe(GeologicaBlocks.MEDIUM_STONE, (Block)GeologicaBlocks.MEDIUM_STONE_SLAB);
        RecipeRegistration.addSlabRecipe(GeologicaBlocks.STRONG_STONE, (Block)GeologicaBlocks.STRONG_STONE_SLAB);
        RecipeRegistration.addSlabRecipe(GeologicaBlocks.VERY_STRONG_STONE, (Block)GeologicaBlocks.VERY_STRONG_STONE_SLAB);
        RecipeRegistration.addWallRecipe(GeologicaBlocks.MEDIUM_COBBLE, GeologicaBlocks.MEDIUM_COBBLE_WALL);
        RecipeRegistration.addWallRecipe(GeologicaBlocks.STRONG_COBBLE, GeologicaBlocks.STRONG_COBBLE_WALL);
        RecipeRegistration.addWallRecipe(GeologicaBlocks.VERY_STRONG_COBBLE, GeologicaBlocks.VERY_STRONG_COBBLE_WALL);
        RecipeRegistration.addWallRecipe(GeologicaBlocks.MEDIUM_STONE_BRICK, GeologicaBlocks.MEDIUM_STONE_BRICK_WALL);
        RecipeRegistration.addWallRecipe(GeologicaBlocks.STRONG_STONE_BRICK, GeologicaBlocks.STRONG_STONE_BRICK_WALL);
        RecipeRegistration.addWallRecipe(GeologicaBlocks.VERY_STRONG_STONE_BRICK, GeologicaBlocks.VERY_STRONG_STONE_BRICK_WALL);
        RecipeRegistration.addBrickRecipe(GeologicaBlocks.MEDIUM_STONE, GeologicaBlocks.MEDIUM_STONE_BRICK);
        RecipeRegistration.addBrickRecipe(GeologicaBlocks.STRONG_STONE, GeologicaBlocks.STRONG_STONE_BRICK);
        RecipeRegistration.addBrickRecipe(GeologicaBlocks.VERY_STRONG_STONE, GeologicaBlocks.VERY_STRONG_STONE_BRICK);
        RecipeRegistration.addStairsRecipe(GeologicaBlocks.MEDIUM_COBBLE_STAIRS__LIMESTONE);
        RecipeRegistration.addStairsRecipe(GeologicaBlocks.STRONG_COBBLE_STAIRS__GRANITE);
        RecipeRegistration.addStairsRecipe(GeologicaBlocks.STRONG_COBBLE_STAIRS__MARBLE);
        RecipeRegistration.addStairsRecipe(GeologicaBlocks.MEDIUM_STONE_BRICK_STAIRS__LIMESTONE);
        RecipeRegistration.addStairsRecipe(GeologicaBlocks.STRONG_STONE_BRICK_STAIRS__GRANITE);
        RecipeRegistration.addStairsRecipe(GeologicaBlocks.STRONG_STONE_BRICK_STAIRS__MARBLE);
    }

    private static void addGrindingRecipes() {
        RecipeRegistration.addStoneGrindingRecipes();
        RecipeRegistration.addCobbleGrindingRecipes();
    }

    private static void addCobbleGrindingRecipes() {
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.ANDESITE, (Block)Blocks.field_150354_m, IndustrialMineral.IndustrialMinerals.FELDSPAR, 0.1);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.BRECCIA, new ItemStack(Blocks.field_150351_n, 2));
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.CARBONATITE, (Block)Blocks.field_150354_m, Compound.Compounds.CaCO3, 0.5);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.CONGLOMERATE, new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Blocks.field_150351_n), 1.0);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.CLAYSTONE, new ItemStack(GeologicaItems.CLAY_DUST, 2));
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.DIORITE, (Block)Blocks.field_150354_m, IndustrialMineral.IndustrialMinerals.FELDSPAR, 0.1);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.GABBRO, (Block)Blocks.field_150354_m, IndustrialMineral.IndustrialMinerals.FELDSPAR, 0.2);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.GNEISS, (Block)Blocks.field_150354_m, IndustrialMineral.IndustrialMinerals.FELDSPAR, 0.1);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.GRANITE, (Block)Blocks.field_150354_m, IndustrialMineral.IndustrialMinerals.QUARTZ, 0.1);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.GREENSCHIST, (Block)Blocks.field_150354_m, IndustrialMineral.IndustrialMinerals.CHRYSOTILE, 0.1);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.HORNFELS, (Block)Blocks.field_150354_m, IndustrialMineral.IndustrialMinerals.MICA, 0.2);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.LIMESTONE, (Block)Blocks.field_150354_m, Compound.Compounds.CaCO3, 0.5);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.MARBLE, (Block)Blocks.field_150354_m, Compound.Compounds.CaCO3, 1.0);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.MUDSTONE, new ItemStack((Block)Blocks.field_150354_m), new ItemStack(GeologicaItems.CLAY_DUST), 0.1);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.PEGMATITE, IndustrialMineral.IndustrialMinerals.FELDSPAR, IndustrialMineral.IndustrialMinerals.QUARTZ, 1.0);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.PERIDOTITE, (Block)Blocks.field_150354_m, IndustrialMineral.IndustrialMinerals.OLIVINE, 0.5);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.RHYOLITE, (Block)Blocks.field_150354_m, IndustrialMineral.IndustrialMinerals.QUARTZ, 0.1);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.SCHIST, (Block)Blocks.field_150354_m, IndustrialMineral.IndustrialMinerals.MICA, 0.2);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.SERPENTINITE, (Block)Blocks.field_150354_m, IndustrialMineral.IndustrialMinerals.CHRYSOTILE, 0.1);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.SLATE, (Block)Blocks.field_150354_m, IndustrialMineral.IndustrialMinerals.MICA, 0.1);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.SKARN, (Block)Blocks.field_150354_m, IndustrialMineral.IndustrialMinerals.WOLLASTONITE, 0.1);
        RecipeRegistration.addCobbleGrindingRecipe(GeoMaterial.QUARTZITE, new ItemStack((Block)Blocks.field_150354_m, 2));
    }

    private static void addStoneGrindingRecipes() {
        RecipeRegistration.addStoneGrindingRecipes(GeologicaBlocks.WEAK_STONE, GeologicaBlocks.WEAK_RUBBLE);
        RecipeRegistration.addStoneGrindingRecipes(GeologicaBlocks.MEDIUM_STONE, GeologicaBlocks.MEDIUM_COBBLE);
        RecipeRegistration.addStoneGrindingRecipes(GeologicaBlocks.STRONG_STONE, GeologicaBlocks.STRONG_COBBLE);
        RecipeRegistration.addStoneGrindingRecipes(GeologicaBlocks.VERY_STRONG_STONE, GeologicaBlocks.VERY_STRONG_COBBLE);
    }

    private static void addMeltingRecipes() {
        RecipeRegistration.addStoneMeltingRecipes(GeologicaBlocks.MEDIUM_STONE);
        RecipeRegistration.addStoneMeltingRecipes(GeologicaBlocks.MEDIUM_COBBLE);
        RecipeRegistration.addStoneMeltingRecipes(GeologicaBlocks.STRONG_STONE);
        RecipeRegistration.addStoneMeltingRecipes(GeologicaBlocks.STRONG_COBBLE);
        RecipeRegistration.addStoneMeltingRecipes(GeologicaBlocks.VERY_STRONG_STONE);
        RecipeRegistration.addStoneMeltingRecipes(GeologicaBlocks.VERY_STRONG_COBBLE);
    }

    private static void addStoneMeltingRecipes(GeoBlock block) {
        RecipeRegistration.addMeltingRecipe(new ItemStack((Block)block), new FluidStack(FluidRegistry.LAVA, 1000), block.getStrength());
    }

    private static void addMeltingRecipe(ItemStack solid, FluidStack liquid, GeoMaterial.Strength strength) {
        TEIntegration.addCrucibleRecipe(solid, liquid, strength);
    }

    private static void addSlabRecipe(CompositeBlock input, Block output) {
        RecipeRegistration.addCraftingRecipesByMeta(input, output, 6, "###");
    }

    private static void addWallRecipe(CompositeBlock input, Block output) {
        RecipeRegistration.addCraftingRecipesByMeta(input, output, 6, "###", "###");
    }

    private static void addBrickRecipe(CompositeBlock input, Block output) {
        RecipeRegistration.addCraftingRecipesByMeta(input, output, 4, "##", "##");
    }

    private static void addCraftingRecipesByMeta(CompositeBlock input, Block output, int outputSize, String ... shape) {
        for (int meta = 0; meta < input.getMetaCount(); ++meta) {
            ItemStack outputStack = new ItemStack(output, outputSize, meta);
            ItemStack inputStack = new ItemStack((Block)input, 1, meta);
            GameRegistry.addRecipe((ItemStack)outputStack, (Object[])new Object[]{shape, Character.valueOf(shape[0].charAt(0)), inputStack});
        }
    }

    private static void addStairsRecipe(StairsBlock output) {
        ItemStack outputStack = new ItemStack((Block)output, 4, output.getModelBlockMeta());
        ItemStack inputStack = new ItemStack(output.getModelBlock(), 1, output.getModelBlockMeta());
        GameRegistry.addRecipe((ItemStack)outputStack, (Object[])new Object[]{"#  ", "## ", "###", Character.valueOf('#'), inputStack});
    }

    private static void addSmeltingRecipesByMeta(CompositeBlock input, Block output, OreMineral.SmeltingTemperature temperature) {
        for (int meta = 0; meta < input.getMetaCount(); ++meta) {
            ItemStack outputStack = new ItemStack(output, 1, meta);
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Block)input, 1, meta), outputStack, 0.0f);
            TEIntegration.addFurnaceRecipe(new ItemStack((Block)input, 1, meta), outputStack, temperature);
        }
    }

    private static void oreDictifyStoneBrick() {
        OreDictionary.registerOre((String)"stoneBricks", (Block)Blocks.field_150417_aV);
    }

    private static void oreDictifyGeoBlocks() {
        for (Block block : GeologicaBlocks.getBlocks()) {
            RecipeRegistration.oreDictify(block);
        }
    }

    private static void oreDictify(Block block) {
        if (block instanceof GeoBlock) {
            RecipeRegistration.oreDictify((GeoBlock)block);
        } else if (block instanceof ProxyBlock) {
            RecipeRegistration.oreDictify((ProxyBlock)block);
        } else if (block instanceof VanillaOreOverrideBlock) {
            RecipeRegistration.oreDictify((VanillaOreOverrideBlock)block);
        }
    }

    private static void oreDictify(GeoBlock block) {
        if (block.hasComposition(Aggregate.class)) {
            RecipeRegistration.oreDictifyAggregate(block);
        } else if (block.hasComposition(Ore.class)) {
            RecipeRegistration.oreDictifyOre(block);
        }
    }

    private static void oreDictifyOre(GeoBlock block) {
        for (GeoMaterial material : block.getGeoMaterials()) {
            RecipeRegistration.oreDictifyOre(block, material);
        }
    }

    private static void oreDictifyOre(GeoBlock block, GeoMaterial substance) {
        ItemStack oreStack = block.getItemStack(substance);
        String postfix = substance.getOreDictKey();
        if (postfix != null && !Geologica.isTechnical()) {
            RecipeRegistration.oreDictifyOre(postfix, oreStack);
        }
        RecipeRegistration.oreDictifyOre(substance.getLowerName(), oreStack);
    }

    private static String oreDictKey(String prefix, String postfix) {
        return prefix + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, postfix);
    }

    private static void oreDictifyOre(String postfix, ItemStack itemStack) {
        String key = RecipeRegistration.oreDictKey("ore", postfix);
        OreDictionary.registerOre((String)key, (ItemStack)itemStack);
        ItemStack smeltingOutput = RecipeRegistration.getSmeltingOutput(key);
        if (smeltingOutput != null) {
            FurnaceRecipes.func_77602_a().func_151394_a(itemStack, smeltingOutput, 0.0f);
        }
    }

    private static ItemStack getSmeltingOutput(String key) {
        ArrayList ores = OreDictionary.getOres((String)key);
        for (ItemStack ore : ores) {
            ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(ore);
            if (output == null) continue;
            return output;
        }
        return null;
    }

    private static String getAggregateOreDictKey(GeoBlock block) {
        if (block.func_149688_o() == Material.field_151571_B) {
            return "clay";
        }
        if (block.func_149688_o() == Material.field_151595_p) {
            return "sand";
        }
        if (block instanceof BrokenGeoBlock) {
            return "cobblestone";
        }
        if (block instanceof BrickGeoBlock) {
            return "stoneBricks";
        }
        if (block instanceof LooseGeoBlock) {
            return "rubble";
        }
        return "stone";
    }

    private static void oreDictify(ProxyBlock block) {
        String prefix = null;
        if (block instanceof StairsBlock) {
            prefix = "stair";
        } else if (block instanceof SlabBlock) {
            prefix = "slab";
        } else if (block instanceof WallBlock) {
            prefix = "wall";
        }
        String postfix = RecipeRegistration.getAggregateOreDictKey((GeoBlock)block.getModelBlock());
        String key = RecipeRegistration.oreDictKey(prefix, postfix);
        OreDictionary.registerOre((String)key, (ItemStack)new ItemStack((Block)block, 1, Short.MAX_VALUE));
    }

    private static void oreDictifyAggregate(GeoBlock block) {
        String key = RecipeRegistration.getAggregateOreDictKey(block);
        OreDictionary.registerOre((String)key, (ItemStack)new ItemStack((Block)block, 1, Short.MAX_VALUE));
        if (block instanceof BrickGeoBlock) {
            OreDictionary.registerOre((String)"stoneBricks", (ItemStack)new ItemStack((Block)block, 1, Short.MAX_VALUE));
        }
    }

    private static void oreDictify(VanillaOreOverrideBlock block) {
        String name = Block.field_149771_c.func_148750_c((Object)block);
        if (name != null) {
            String material = name.substring(name.indexOf(58) + 1, name.length() - 3);
            OreDictionary.registerOre((String)RecipeRegistration.oreDictKey("ore", material), (ItemStack)new ItemStack((Block)block, 1, Short.MAX_VALUE));
        }
    }

    private static GeoBlock getCobbleBlock(GeoMaterial.Strength strength) {
        switch (strength) {
            case WEAK: {
                return GeologicaBlocks.WEAK_RUBBLE;
            }
            case MEDIUM: {
                return GeologicaBlocks.MEDIUM_COBBLE;
            }
            case STRONG: {
                return GeologicaBlocks.STRONG_COBBLE;
            }
            case VERY_STRONG: {
                return GeologicaBlocks.VERY_STRONG_COBBLE;
            }
        }
        return null;
    }

    private static void addCobbleGrindingRecipe(GeoMaterial material, IndustrialMineral.IndustrialMinerals primaryDust, IndustrialMineral.IndustrialMinerals secondaryDust, double secondaryChance) {
        RecipeRegistration.addCobbleGrindingRecipe(material, GeologicaItems.CRUDE_DUST.getItemStack(primaryDust, 2), secondaryDust, secondaryChance);
    }

    private static void addCobbleGrindingRecipe(GeoMaterial material, Block primaryOutput, IndustrialMineral.IndustrialMinerals secondaryDust, double secondaryChance) {
        RecipeRegistration.addCobbleGrindingRecipe(material, new ItemStack(primaryOutput), secondaryDust, secondaryChance);
    }

    private static void addCobbleGrindingRecipe(GeoMaterial material, ItemStack primaryOutput, IndustrialMineral.IndustrialMinerals secondaryDust, double secondaryChance) {
        ItemStack secondaryOutput = GeologicaItems.CRUDE_DUST.getItemStack(secondaryDust);
        RecipeRegistration.addCobbleGrindingRecipe(material, primaryOutput, secondaryOutput, secondaryChance);
    }

    private static void addCobbleGrindingRecipe(GeoMaterial material, Block primaryOutput, Compound.Compounds secondaryDust, double secondaryChance) {
        RecipeRegistration.addCobbleGrindingRecipe(material, new ItemStack(primaryOutput), secondaryDust, secondaryChance);
    }

    private static void addCobbleGrindingRecipe(GeoMaterial material, ItemStack primaryOutput, Compound.Compounds secondaryDust, double secondaryChance) {
    }

    private static void addCobbleGrindingRecipe(GeoMaterial material, ItemStack primaryOutput, ItemStack secondaryOutput, double secondaryChance) {
        ItemStack input = RecipeRegistration.getCobbleBlock(material.getStrength()).getItemStack(material);
        RecipeRegistration.addGrindingRecipe(input, primaryOutput, secondaryOutput, secondaryChance, material.getStrength());
    }

    private static void addCobbleGrindingRecipe(GeoMaterial material, ItemStack primaryOutput) {
        ItemStack input = RecipeRegistration.getCobbleBlock(material.getStrength()).getItemStack(material);
        RecipeRegistration.addGrindingRecipe(input, primaryOutput, null, 0.0, material.getStrength());
    }

    private static void addStoneGrindingRecipes(GeoBlock intact, GeoBlock broken) {
        for (GeoMaterial material : intact.getGeoMaterials()) {
            RecipeRegistration.addGrindingRecipe(intact.getItemStack(material), broken.getItemStack(material), null, 0.0, intact.getStrength());
        }
    }

    private static void addGrindingRecipe(ItemStack input, ItemStack output, ItemStack secondaryOutput, double secondaryChance, GeoMaterial.Strength strength) {
        TEIntegration.addPulverizerRecipe(input, output, secondaryOutput, secondaryChance, strength);
        if (strength == GeoMaterial.Strength.WEAK || strength == GeoMaterial.Strength.MEDIUM) {
            IC2Integration.addMaceratorRecipe(input, output);
        }
    }

    private static void registerMicroblocks() {
        if (Loader.isModLoaded((String)"ForgeMicroblock")) {
            FMPIntegration.registerMicroblock(GeologicaBlocks.WEAK_STONE);
            FMPIntegration.registerMicroblock(GeologicaBlocks.MEDIUM_STONE);
            FMPIntegration.registerMicroblock(GeologicaBlocks.STRONG_STONE);
            FMPIntegration.registerMicroblock(GeologicaBlocks.VERY_STRONG_STONE);
            FMPIntegration.registerMicroblock(GeologicaBlocks.MEDIUM_COBBLE);
            FMPIntegration.registerMicroblock(GeologicaBlocks.STRONG_COBBLE);
            FMPIntegration.registerMicroblock(GeologicaBlocks.VERY_STRONG_COBBLE);
        }
    }

    private static void registerOreDrops() {
        ChanceDropRegistry drops = ChanceDropRegistry.instance();
        RecipeRegistration.registerOreDrop(drops, GeoMaterial.CONGLOMERATE, "nuggetCopper", 1, 3, 0.1f, true);
        RecipeRegistration.registerOreDrop(drops, GeoMaterial.GARNET_SAND, Items.field_151074_bl, 4, 4, 0.1f, true);
        RecipeRegistration.registerOreDrop(drops, GeoMaterial.GARNET_SAND, "nuggetElectrum", 2, 2, 0.05f, true);
        RecipeRegistration.registerOreDrop(drops, GeoMaterial.GARNET_SAND, "nuggetSilver", 1, 2, 0.05f, true);
        if (Geologica.getConfiguration().isVanillaOreGemDropEnabled()) {
            RecipeRegistration.registerOreDrop(drops, GeoMaterial.COAL, Items.field_151044_h, 1, 0, 1.0f, true);
            RecipeRegistration.registerOreDrop(drops, GeoMaterial.DIAMOND, Items.field_151045_i, 1, 0, 1.0f, true);
            RecipeRegistration.registerOreDrop(drops, GeoMaterial.LAPIS, "gemLapis", 4, 5, 1.0f, true);
            RecipeRegistration.registerOreDrop(drops, GeoMaterial.EMERALD, Items.field_151166_bC, 1, 0, 1.0f, true);
            RecipeRegistration.registerOreDrop(drops, GeoMaterial.REDSTONE, Items.field_151137_ax, 4, 2, 1.0f, false);
        }
    }

    private static void registerOreDrop(ChanceDropRegistry drops, GeoMaterial material, String key, int quantity, int bonus, float chance, boolean fortuneMultiplies) {
        ArrayList ores = OreDictionary.getOres((String)key);
        if (ores.size() > 0) {
            ItemStack drop = ((ItemStack)ores.get(0)).func_77946_l();
            drop.field_77994_a = quantity;
            drops.addChanceDrop(material, drop, bonus, chance, fortuneMultiplies);
        }
    }

    private static void registerOreDrop(ChanceDropRegistry drops, GeoMaterial material, Item item, int quantity, int bonus, float chance, boolean fortuneMultiplies) {
        drops.addChanceDrop(material, new ItemStack(item, quantity), bonus, chance, fortuneMultiplies);
    }
}

