/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.chemica.model;

import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class Condition {
    public double temperature;
    public double pressure;
    public static Condition STP = new Condition(298.0, 101.0);

    public Condition(double temperature, double pressure) {
        this.temperature = temperature;
        this.pressure = pressure;
    }

    public static Condition ofWorldCoordinates(World world, int x, int y, int z) {
        double temperature = Condition.getTemperatureAt(world, x, y, z);
        double pressure = Condition.getPressureAt(world, x, y, z);
        return new Condition(temperature, pressure);
    }

    private static double getPressureAt(World world, int x, int y, int z) {
        int sealevel = world.field_73011_w.field_76576_e ? world.field_73011_w.getActualHeight() : world.field_73011_w.func_76557_i();
        return 101.0 - (double)((y - sealevel) * 0) * 101.0 / (double)(world.field_73011_w.getHeight() - sealevel);
    }

    private static float getTemperatureAt(World world, int x, int y, int z) {
        boolean isHeated;
        BiomeGenBase biomegenbase = world.func_72807_a(x, z);
        float biometemp = biomegenbase.func_150564_a(x, y, z);
        double temperature = (biometemp - 0.15f) * 45.0f / 1.85f;
        boolean bl = isHeated = world.func_72972_b(EnumSkyBlock.Block, x, y, z) == 10;
        if (isHeated) {
            temperature = Math.max(temperature, 298.0);
        }
        return (float)temperature;
    }
}

