/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.geologica.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.pfaa.block.CompositeBlock;
import org.pfaa.block.CompositeBlockAccessors;
import org.pfaa.geologica.block.ProxyBlock;

public class SlabBlock
extends BlockSlab
implements CompositeBlockAccessors,
ProxyBlock {
    private CompositeBlock modelBlock;
    private SlabBlock otherSlab;
    private boolean isDoubleSlab;
    private IIcon[] icons;

    public SlabBlock(CompositeBlock modelBlock, SlabBlock singleSlab) {
        super(singleSlab != null, modelBlock.func_149688_o());
        this.modelBlock = modelBlock;
        if (singleSlab != null) {
            this.isDoubleSlab = true;
            this.otherSlab = singleSlab;
            this.otherSlab.otherSlab = this;
            this.func_149647_a(null);
        }
        this.func_149711_c(modelBlock.func_149712_f(null, 0, 0, 0));
        this.func_149752_b(modelBlock.getBlockResistance());
        this.func_149672_a(modelBlock.field_149762_H);
        this.func_149713_g(0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.modelBlock.func_149691_a(side, meta & 7);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return this.getSingleSlabItem();
    }

    protected ItemStack func_149644_j(int meta) {
        return new ItemStack((Block)this, 2, meta & 7);
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a() + "." + this.modelBlock.getBlockNameSuffix(meta & 7);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < this.getMetaCount(); ++i) {
            list.add(new ItemStack(item, 1, this.func_149692_a(i)));
        }
    }

    @Override
    public int getMetaCount() {
        return this.modelBlock.getMetaCount();
    }

    public boolean isDoubleSlab() {
        return this.isDoubleSlab;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack(this.getSingleSlabItem(), 1, world.func_72805_g(x, y, z));
    }

    public SlabBlock getSingleSlab() {
        return this.isDoubleSlab() ? this.otherSlab : this;
    }

    private Item getSingleSlabItem() {
        return Item.func_150898_a((Block)this.getSingleSlab());
    }

    public SlabBlock getDoubleSlab() {
        return this.isDoubleSlab() ? this : this.otherSlab;
    }

    @Override
    public CompositeBlock getModelBlock() {
        return this.modelBlock;
    }

    @Override
    public String getBlockNameSuffix(int meta) {
        return this.modelBlock.getBlockNameSuffix(meta & 7);
    }

    public int func_149645_b() {
        return this.modelBlock.func_149645_b();
    }

    @Override
    public boolean enableOverlay() {
        return this.modelBlock.enableOverlay();
    }

    @Override
    public void disableOverlay() {
        this.modelBlock.disableOverlay();
    }

    @Override
    public void enableDefaultRenderer() {
        this.modelBlock.enableDefaultRenderer();
    }

    @Override
    public void disableDefaultRenderer() {
        this.modelBlock.disableDefaultRenderer();
    }
}

