/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.chemica.fluid;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.lwjgl.opengl.GL11;
import org.pfaa.chemica.block.IndustrialFluidBlock;
import org.pfaa.chemica.fluid.FluidRespirationProperties;
import org.pfaa.chemica.fluid.IndustrialFluid;
import org.pfaa.chemica.model.Compound;
import org.pfaa.chemica.model.IndustrialMaterial;
import org.pfaa.chemica.model.Mixture;
import org.pfaa.chemica.model.MixtureComponent;

public class RespirationHandler {
    public static final RespirationHandler INSTANCE = new RespirationHandler();
    private static final float MIN_PERMISSIBLE_OXYGEN_CONTENT = 0.195f;
    private static final float ATMOSPHERIC_OXYGEN_CONTENT = 0.209f;
    private int playerAir;

    private RespirationHandler() {
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityLivingBase && !(event.entity instanceof EntityPlayer)) {
            FluidRespirationProperties.register((EntityLivingBase)event.entity);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.playerAir = event.player.func_70086_ai();
        } else {
            RespirationHandler.handleRespiration((EntityLivingBase)event.player, this.playerAir);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.entityLiving instanceof EntityPlayer)) {
            RespirationHandler.handleRespiration(event.entityLiving, RespirationHandler.getAirLevel(event.entityLiving));
        }
    }

    private static void handleRespiration(EntityLivingBase entity, int initAirLevel) {
        if (entity.func_70089_S()) {
            IndustrialFluidBlock block = IndustrialFluidBlock.atEyeLevel(entity);
            if (block != null && (block.getFluid().isGaseous() || entity.func_70648_aU())) {
                float oxygenContent = RespirationHandler.getBreathableOxygenContent(block, entity);
                if (oxygenContent < 0.195f) {
                    Random rand = new Random();
                    RespirationHandler.setAirLevel(entity, RespirationHandler.decreaseAirSupply(entity, initAirLevel, rand));
                    if (RespirationHandler.getAirLevel(entity) == -20) {
                        RespirationHandler.setAirLevel(entity, 0);
                        float damage = RespirationHandler.getOxygenDeprivationDamage(oxygenContent);
                        if (damage > 0.0f) {
                            entity.func_70097_a(DamageSource.field_76369_e, damage);
                        } else {
                            RespirationHandler.addOxygenDeprivationEffects(entity, oxygenContent, 20);
                        }
                    } else if (!block.getFluid().isGaseous()) {
                        RespirationHandler.generateBubbleParticles((Entity)entity, rand);
                    }
                }
            } else if (!(entity instanceof EntityPlayer)) {
                RespirationHandler.setAirLevel(entity, 300);
            }
        }
    }

    private static int getAirLevel(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return entity.func_70086_ai();
        }
        return FluidRespirationProperties.getAirLevel(entity);
    }

    private static void setAirLevel(EntityLivingBase entity, int airLevel) {
        if (entity instanceof EntityPlayer) {
            entity.func_70050_g(airLevel);
        } else {
            FluidRespirationProperties.setAirLevel(entity, airLevel);
        }
    }

    private static float getOxygenDeprivationDamage(float oxygenContent) {
        return (double)oxygenContent < 0.06 ? 2.0f : ((double)oxygenContent < 0.08 ? 1.0f : 0.0f);
    }

    private static void addOxygenDeprivationEffects(EntityLivingBase entity, double oxygenContent, int duration) {
        if (oxygenContent < 0.1) {
            entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, duration));
        }
        if (oxygenContent < 0.15) {
            entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, duration));
        }
        if (oxygenContent < (double)0.195f) {
            entity.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, duration));
        }
    }

    private static int decreaseAirSupply(EntityLivingBase entity, int airLevel, Random rand) {
        int j = EnchantmentHelper.func_77501_a((EntityLivingBase)entity);
        return j > 0 && rand.nextInt(j + 1) > 0 ? airLevel : airLevel - 1;
    }

    private static void generateBubbleParticles(Entity entity, Random rand) {
        for (int i = 0; i < 8; ++i) {
            float f = rand.nextFloat() - rand.nextFloat();
            float f1 = rand.nextFloat() - rand.nextFloat();
            float f2 = rand.nextFloat() - rand.nextFloat();
            entity.field_70170_p.func_72869_a("bubble", entity.field_70165_t + (double)f, entity.field_70163_u + (double)f1, entity.field_70161_v + (double)f2, entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderAir(RenderGameOverlayEvent.Pre event) {
        float oxygenContent;
        if (event.type == RenderGameOverlayEvent.ElementType.AIR && (oxygenContent = RespirationHandler.getOxygenContentAtEyeLevel((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) < 0.195f) {
            this.renderAirBar(event.resolution);
            event.setCanceled(true);
        }
    }

    private static float getOxygenContentAtEyeLevel(EntityLivingBase entity) {
        IndustrialFluidBlock block = IndustrialFluidBlock.atEyeLevel(entity);
        return block != null ? RespirationHandler.getBreathableOxygenContent(block.getFluid()) : 0.209f;
    }

    private static float getBreathableOxygenContent(IndustrialFluid fluid) {
        if (!fluid.isGaseous()) {
            return 0.0f;
        }
        IndustrialMaterial material = fluid.getIndustrialMaterial();
        if (material == Compound.Compounds.O2) {
            return 1.0f;
        }
        if (material instanceof Mixture) {
            for (MixtureComponent comp : ((Mixture)material).getComponents()) {
                if (comp.material != Compound.Compounds.O2) continue;
                return (float)comp.weight;
            }
        }
        return 0.0f;
    }

    private static float getBreathableOxygenContent(IndustrialFluidBlock block, EntityLivingBase entity) {
        float oxygenContent = RespirationHandler.getBreathableOxygenContent(block.getFluid());
        if (block.getFluid().isGaseous()) {
            double j0 = entity.field_70163_u + (double)(entity.field_70170_p.field_72995_K ? 0.0f : entity.func_70047_e());
            int i = MathHelper.func_76128_c((double)entity.field_70165_t);
            int j = MathHelper.func_76128_c((double)j0);
            int k = MathHelper.func_76128_c((double)entity.field_70161_v);
            float filled = Math.abs(block.getFilledPercentage(entity.field_70170_p, i, j, k));
            oxygenContent = oxygenContent * filled + 0.209f * (1.0f - filled);
        }
        return oxygenContent;
    }

    @SideOnly(value=Side.CLIENT)
    private void renderAirBar(ScaledResolution res) {
        GL11.glEnable((int)3042);
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        int left = width / 2 + 91;
        int top = height - GuiIngameForge.right_height;
        Minecraft mc = Minecraft.func_71410_x();
        int air = RespirationHandler.getAirLevel((EntityLivingBase)mc.field_71439_g);
        int full = MathHelper.func_76143_f((double)((double)(air - 2) * 10.0 / 300.0));
        int partial = MathHelper.func_76143_f((double)((double)air * 10.0 / 300.0)) - full;
        for (int i = 0; i < full + partial; ++i) {
            mc.field_71456_v.func_73729_b(left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
        }
        GuiIngameForge.right_height += 10;
        GL11.glDisable((int)3042);
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (this.entityInIndustrialFluid(event.world, event.entity)) {
            event.setCanceled(true);
        }
    }

    private boolean entityInIndustrialFluid(World world, Entity entity) {
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)entity.field_70163_u);
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        Block block = world.func_147439_a(i, j, k);
        return block instanceof IndustrialFluidBlock;
    }
}

