/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.chemica.model;

import java.awt.Color;
import org.pfaa.chemica.model.Condition;
import org.pfaa.chemica.model.Hazard;
import org.pfaa.chemica.model.Phase;
import org.pfaa.chemica.model.PhaseProperties;
import org.pfaa.chemica.model.Thermo;

public class ChemicalPhaseProperties
extends PhaseProperties {
    public final Thermo thermo;
    private static final Color COLORLESS = new Color(230, 230, 245);

    public ChemicalPhaseProperties(Phase phase, Color color, double density, Thermo thermo, Hazard hazard, boolean opaque) {
        super(phase, color, density, hazard, opaque);
        this.thermo = thermo;
    }

    public static class Gas
    extends ChemicalPhaseProperties {
        private final double molarMass;
        private final Sutherland sutherland;

        public Gas(Gas gas, double molarMass) {
            this(gas.getColor(), gas.thermo, gas.getHazard(), gas.sutherland, molarMass);
        }

        public Gas(Color color, Thermo thermo, Hazard hazard, Sutherland sutherland, double molarMass) {
            super(Phase.GAS, color, Double.NaN, thermo, hazard, false);
            this.molarMass = molarMass;
            this.sutherland = sutherland;
        }

        public Gas(Color color, Thermo thermo, Hazard hazard, Sutherland sutherland) {
            this(color, thermo, hazard, sutherland, Double.NaN);
        }

        public Gas(Thermo thermo, Hazard hazard, Sutherland sutherland) {
            this(COLORLESS, thermo, hazard, sutherland);
        }

        public Gas(Thermo thermo) {
            this(thermo, new Hazard(), null);
        }

        public Gas() {
            this(new Thermo());
        }

        @Override
        public double getDensity(Condition condition) {
            if (Double.isNaN(this.molarMass)) {
                return super.getDensity(condition);
            }
            return Gas.getDensity(condition, this.molarMass);
        }

        private static double getDensity(Condition condition, double molarMass) {
            return molarMass * condition.pressure / (0.008314 * condition.temperature) / 1000000.0;
        }

        @Override
        public double getViscosity(double temperature) {
            return this.sutherland == null ? super.getViscosity(temperature) : this.sutherland.getViscosity(temperature);
        }

        public static class Sutherland {
            private double refViscosity;
            private double refTemperature;
            private double constant;

            public Sutherland(double refViscosity, double refTemperature, double constant) {
                this.refViscosity = refViscosity / 1000.0;
                this.refTemperature = refTemperature;
                this.constant = constant;
            }

            public double getViscosity(double temperature) {
                return this.refViscosity * ((this.refTemperature + this.constant) / (temperature + this.constant) * Math.pow(temperature / this.refTemperature, 1.5));
            }
        }
    }

    public static class Liquid
    extends ChemicalPhaseProperties {
        private final Yaws yaws;

        public Liquid(Color color, double density, Thermo thermo, Hazard hazard, Yaws yaws) {
            super(Phase.LIQUID, color, density, thermo, hazard, false);
            this.yaws = yaws;
        }

        public Liquid(double density, Thermo thermo, Hazard hazard, Yaws yaws) {
            this(COLORLESS, density, thermo, hazard, yaws);
        }

        public Liquid(double density, Thermo thermo) {
            this(density, thermo, new Hazard(), null);
        }

        public Liquid(Thermo thermo) {
            this(Double.NaN, thermo);
        }

        public Liquid() {
            this(new Thermo());
        }

        @Override
        public double getViscosity(double temperature) {
            return this.yaws == null ? super.getViscosity(temperature) : this.yaws.getViscosity(temperature);
        }

        public static class Yaws {
            private double A;
            private double B;
            private double C;
            private double D;

            public Yaws(double A, double B, double C, double D) {
                this.A = A;
                this.B = B;
                this.C = C;
                this.D = D;
            }

            public double getViscosity(double temperature) {
                double exp = this.A + this.B / temperature + this.C * temperature + this.D * Math.pow(temperature, 2.0);
                return Math.pow(10.0, exp);
            }
        }
    }

    public static class Solid
    extends ChemicalPhaseProperties {
        public Solid(Color color, double density, Thermo thermo, Hazard hazard) {
            super(Phase.SOLID, color, density, thermo, hazard, true);
        }

        public Solid(Color color, double density, Thermo thermo) {
            this(color, density, thermo, new Hazard());
        }

        public Solid(double density, Thermo thermo, Hazard hazard) {
            this(Color.WHITE, density, thermo, hazard);
        }

        public Solid(double density, Thermo thermo) {
            this(density, thermo, new Hazard());
        }

        public Solid(Thermo thermo) {
            this(Double.NaN, thermo);
        }

        public Solid() {
            this(new Thermo());
        }
    }
}

