/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.geologica.fluid;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public final class BucketHandler {
    public static BucketHandler INSTANCE = new BucketHandler();

    private BucketHandler() {
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        ItemStack result = this.fillCustomBucket(event.world, event.target, event.current);
        if (result == null) {
            return;
        }
        event.result = result;
        event.setResult(Event.Result.ALLOW);
    }

    private ItemStack fillCustomBucket(World world, MovingObjectPosition pos, ItemStack container) {
        Block block = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        if (fluid != null) {
            boolean isSource;
            boolean bl = isSource = world.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) == 0;
            if (!isSource) {
                return null;
            }
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            ItemStack bucket = FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)container);
            if (bucket != null) {
                world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                return bucket;
            }
        }
        return null;
    }
}

