/*
 * Decompiled with CFR 0.152.
 */
package com.chrislikesbirds.TileEntity;

import com.chrislikesbirds.Container.EnergyStorageContainer;
import com.chrislikesbirds.GUI.EnergyStorageGUI;
import com.chrislikesbirds.TileEntity.TileEntityGUI;
import com.chrislikesbirds.Util.Formater;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyStorageTileEntity
extends TileEntity
implements IEnergyTile,
IWrenchable,
IEnergySource,
IEnergySink,
IInventory,
INetworkTileEntityEventListener,
INetworkDataProvider,
INetworkUpdateListener,
TileEntityGUI {
    boolean addedToENet;
    boolean loaded;
    boolean init;
    public int energyStored;
    public int energyStorage;
    public int energyOutput;
    public int lastX;
    public int lastY;
    public int lastZ;
    public int facing;
    ItemStack slotItemStack;

    public EnergyStorageTileEntity(int energyStorage, int energyOutput) {
        this.energyStorage = energyStorage;
        this.energyOutput = energyOutput;
    }

    public static String getName() {
        return "tileEnergyStorage";
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.func_145837_r() || this.func_145831_w().func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        this.onLoaded();
    }

    public void init() {
        this.init = true;
        if (!this.addedToENet) {
            this.onLoaded();
        }
    }

    public void onLoaded() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToENet = true;
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToENet = false;
        }
        this.loaded = false;
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.init) {
            this.init();
        }
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.lastX != this.field_145851_c || this.lastZ != this.field_145848_d || this.lastY != this.field_145849_e) {
            this.lastX = this.field_145851_c;
            this.lastY = this.field_145848_d;
            this.lastZ = this.field_145849_e;
            this.onUnloaded();
            this.init();
        }
        if (this.slotItemStack != null && this.slotItemStack.func_77973_b() instanceof IElectricItem && (double)this.energyStored >= ((IElectricItem)this.slotItemStack.func_77973_b()).getTransferLimit(this.slotItemStack)) {
            this.energyStored = (int)((double)this.energyStored - ElectricItem.manager.charge(this.slotItemStack, (double)this.energyStored, 4, false, false));
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.facing == 0 && direction == ForgeDirection.DOWN || this.facing == 1 && direction == ForgeDirection.UP || this.facing == 2 && direction == ForgeDirection.NORTH || this.facing == 3 && direction == ForgeDirection.EAST || this.facing == 4 && direction == ForgeDirection.SOUTH || this.facing == 5 && direction == ForgeDirection.WEST;
    }

    public void onNetworkEvent(int event) {
    }

    public void onNetworkUpdate(String field) {
    }

    public List<String> getNetworkedFields() {
        return Arrays.asList(new String[0]);
    }

    public double getOfferedEnergy() {
        return Math.min(this.energyStored, this.energyOutput);
    }

    public void drawEnergy(double amount) {
        this.energyStored = (int)((double)this.energyStored - amount);
    }

    public int getSourceTier() {
        return 4;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return side != this.facing;
    }

    public short getFacing() {
        return (short)this.facing;
    }

    public void setFacing(short facing) {
        this.facing = facing;
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return null;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return this.facing == 0 && direction != ForgeDirection.DOWN || this.facing == 1 && direction != ForgeDirection.UP || this.facing == 2 && direction != ForgeDirection.NORTH || this.facing == 3 && direction != ForgeDirection.EAST || this.facing == 4 && direction != ForgeDirection.SOUTH || this.facing == 5 && direction != ForgeDirection.WEST;
    }

    public double getDemandedEnergy() {
        return this.energyStorage - this.energyStored;
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.energyStored = (int)((double)this.energyStored + amount);
        return 0.0;
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("storage", this.energyStored);
        nbt.func_74768_a("lastX", this.lastX);
        nbt.func_74768_a("lastY", this.lastY);
        nbt.func_74768_a("lastZ", this.lastZ);
        nbt.func_74768_a("facing", this.facing);
        NBTTagCompound nbtItem = new NBTTagCompound();
        if (this.slotItemStack != null) {
            this.slotItemStack.func_77955_b(nbtItem);
        }
        nbt.func_74782_a("Item", (NBTBase)nbtItem);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStored = nbt.func_74762_e("storage");
        this.lastX = nbt.func_74762_e("lastX");
        this.lastY = nbt.func_74762_e("lastY");
        this.lastZ = nbt.func_74762_e("lastZ");
        this.facing = nbt.func_74762_e("facing");
        NBTTagCompound nbtTag = nbt.func_74775_l("Item");
        this.slotItemStack = ItemStack.func_77949_a((NBTTagCompound)nbtTag);
    }

    public int gaugeEnergyScaled(int i) {
        int l = (int)((long)this.energyStored * (long)i / (long)this.energyStorage);
        return l > i ? i : l;
    }

    public String getEnergyString() {
        String message = this.energyStored != 0 ? Double.toString((double)this.energyStored / (double)this.energyStorage * 100.0) : "0.0";
        return Formater.formatMessage("message.text.energy") + " : " + this.energyStored + "/" + this.energyStorage + " " + (message.length() > 4 ? message.substring(0, 5) : message) + "%";
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        return this.slotItemStack;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (slot == 0 && this.slotItemStack != null) {
            if (this.slotItemStack.field_77994_a <= amount) {
                ItemStack itemstack = this.slotItemStack.func_77946_l();
                this.slotItemStack = null;
                return itemstack;
            }
            ItemStack itemstack = this.slotItemStack.func_77979_a(amount);
            if (this.slotItemStack.field_77994_a == 0) {
                this.slotItemStack = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (slot == 0 && this.slotItemStack != null) {
            ItemStack slotItemStackC = this.slotItemStack.func_77946_l();
            this.slotItemStack = null;
            return slotItemStackC;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 0) {
            this.slotItemStack = stack;
        }
    }

    public String func_145825_b() {
        return "Energy Storage";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) <= 16.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGUI(InventoryPlayer playerInventory) {
        return new EnergyStorageGUI(this, playerInventory);
    }

    @Override
    public Object getGUIContainer(InventoryPlayer playerInventory) {
        return new EnergyStorageContainer(this, playerInventory);
    }
}

