/*
 * Decompiled with CFR 0.152.
 */
package com.chrislikesbirds.IC2;

import com.chrislikesbirds.IC2.ElectricArmorCommon;
import com.chrislikesbirds.Mod.Init;
import com.chrislikesbirds.Value.ConfigValues;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ElectricCarbonNanotubeHelmet
extends ItemArmor
implements ISpecialArmor,
IElectricItem {
    public ElectricCarbonNanotubeHelmet(ItemArmor.ArmorMaterial material) {
        super(material, 3, 0);
        this.func_77637_a(Init.creativeTab);
        this.func_77655_b("itemElectricCarbonNanotubeHelmet");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("carbon_mod:itemElectricCarbonNanotubeHelmet");
    }

    public IIcon getIcon(ItemStack is, int a) {
        return this.field_77791_bV;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return ConfigValues.carbonNanotubeArmorEnergyStorage;
    }

    public int getTier(ItemStack itemStack) {
        return ConfigValues.carbonNanotubeArmorTier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return ConfigValues.carbonNanotubeArmorTransferRate;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 5;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K) {
            for (Integer a : ElectricArmorCommon.potionRemove) {
                if (!player.func_82165_m(a.intValue()) || !ElectricItem.manager.canUse(itemStack, (double)ElectricArmorCommon.potionRemovalCost.get(a).intValue())) continue;
                player.func_82170_o(a.intValue());
            }
            ItemStack helmet = player.func_82169_q(3);
            if (helmet != null && helmet.func_77973_b() != null && helmet.func_77973_b() instanceof ElectricCarbonNanotubeHelmet && player.func_70086_ai() == 0 && ElectricItem.manager.canUse(helmet, (double)ConfigValues.carbonNanotubeAirRestoreCost)) {
                player.func_70050_g(300);
                ElectricItem.manager.discharge(helmet, (double)ConfigValues.carbonNanotubeAirRestoreCost, 4, false, false, false);
            }
            if (player.func_71024_bL().func_75116_a() < ConfigValues.carbonNanotubeFoodEatLevel) {
                InventoryPlayer inventory = player.field_71071_by;
                int count = 0;
                for (ItemStack is : inventory.field_70462_a) {
                    if (is != null && is.func_77973_b() != null && is.func_77973_b() instanceof ItemFood && ElectricItem.manager.canUse(helmet, (double)ConfigValues.carbonNanotubeFoodEatCost)) {
                        ItemFood food = (ItemFood)is.func_77973_b();
                        food.func_77654_b(is, world, player);
                        is.func_77979_a(0);
                        inventory.field_70462_a[count] = is;
                        ElectricItem.manager.discharge(helmet, (double)ConfigValues.carbonNanotubeFoodEatCost, 4, false, false, false);
                    }
                    ++count;
                }
            }
        }
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)(ConfigValues.carbonNanotubeArmorEnergyUse * damage), ConfigValues.carbonNanotubeArmorTier, true, false, false);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase entity, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76355_l() != DamageSource.field_82728_o.func_76355_l() && source.func_76355_l() != DamageSource.field_76366_f.func_76355_l() && source.func_76355_l() != DamageSource.field_76379_h.func_76355_l() && source.func_76355_l() != DamageSource.field_76369_e.func_76355_l() && source.func_76355_l() != DamageSource.field_76380_i.func_76355_l() && source.func_76355_l() != DamageSource.field_76368_d.func_76355_l()) {
            int energyPerDamage = ConfigValues.carbonNanotubeArmorEnergyUse;
            int damageLimit = Integer.MAX_VALUE;
            if (energyPerDamage > 0) {
                damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
            }
            return new ISpecialArmor.ArmorProperties(10, 1.0, damageLimit);
        }
        return new ISpecialArmor.ArmorProperties(10, 1.0, 0);
    }

    public String getArmorTexture(ItemStack is, Entity player, int slot, String type) {
        return "carbon_mod:textures/models/armor/electricCarbonNanotubeArmorLayer1.png";
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_82789_a(ItemStack itemStack1, ItemStack itemStack2) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }
}

