/*
 * Decompiled with CFR 0.152.
 */
package com.chrislikesbirds.IC2;

import com.chrislikesbirds.Mod.Init;
import com.chrislikesbirds.ModUtils.Formater;
import com.chrislikesbirds.ModUtils.StackUtils;
import com.chrislikesbirds.Value.ConfigValues;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;

public class ElectricCarbonNanotubeSword
extends ItemTool
implements IElectricItem {
    private static IIcon itemIconActive = null;
    public static Item.ToolMaterial carbonNanotubeToolMaterial = EnumHelper.addToolMaterial((String)"carbonNanotubeToolMaterial", (int)5, (int)65536, (float)1.0f, (float)10.0f, (int)50);

    public ElectricCarbonNanotubeSword() {
        super(5.0f, carbonNanotubeToolMaterial, new HashSet());
        this.func_77637_a(Init.creativeTab);
        this.func_77655_b("itemElectricCarbonNanotubeSword");
        this.field_77789_bW = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("carbon_mod:itemElectricCarbonNanotubeSword");
        itemIconActive = iconRegister.func_94245_a("carbon_mod:itemElectricCarbonNanotubeSwordActive");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack is, int a) {
        NBTTagCompound nbtData = StackUtils.getOrCreateNbtData(is);
        if (nbtData.func_74767_n("active")) {
            return itemIconActive;
        }
        return this.field_77791_bV;
    }

    public float getDigSpeed(ItemStack tool, Block block, int meta) {
        return block.equals(Blocks.field_150321_G) ? 100.0f : 1.0f;
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        NBTTagCompound nbtData = StackUtils.getOrCreateNbtData(itemStack);
        if (!nbtData.func_74767_n("active")) {
            return true;
        }
        ElectricCarbonNanotubeSword.drain(itemStack, ConfigValues.carbonNanotubeToolsEnergyUse, entityliving);
        return true;
    }

    public void func_77663_a(ItemStack is, World world, Entity player, int slot, boolean par5) {
        NBTTagCompound nbtData = StackUtils.getOrCreateNbtData(is);
        if (nbtData.func_74767_n("active") && nbtData.func_74762_e("heat") < ConfigValues.carbonNanotubeSwordMaxDamage && ElectricItem.manager.canUse(is, (double)ConfigValues.carbonNanotubeToolsEnergyUse)) {
            nbtData.func_74768_a("heat", nbtData.func_74762_e("heat") + 1);
            ElectricCarbonNanotubeSword.drain(is, ConfigValues.carbonNanotubeToolsEnergyUse, (EntityLivingBase)player);
            ElectricCarbonNanotubeSword.updateAttributes(nbtData);
        }
        if (!nbtData.func_74767_n("message") && ElectricItem.manager.canUse(is, (double)ConfigValues.carbonNanotubeToolsEnergyUse)) {
            nbtData.func_74757_a("message", true);
        }
        if (world.field_72995_K && nbtData.func_74767_n("message") && !ElectricItem.manager.canUse(is, (double)ConfigValues.carbonNanotubeToolsEnergyUse)) {
            nbtData.func_74757_a("message", false);
            ((EntityPlayer)player).func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + Formater.formatMessage("message.text.outOfPower")));
        }
        if (nbtData.func_74762_e("Count") > 0) {
            nbtData.func_74768_a("Count", nbtData.func_74762_e("Count") - 1);
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            NBTTagCompound nbtData = StackUtils.getOrCreateNbtData(itemStack);
            if (nbtData.func_74767_n("active")) {
                nbtData.func_74757_a("active", false);
                nbtData.func_74768_a("heat", 0);
                if (world.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + Formater.formatMessage("message.text.deactivate")));
                }
                ElectricCarbonNanotubeSword.updateAttributes(nbtData);
            } else if (!ElectricItem.manager.canUse(itemStack, (double)ConfigValues.carbonNanotubeToolsEnergyUse)) {
                if (world.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + Formater.formatMessage("message.text.outOfPower")));
                }
            } else {
                nbtData.func_74757_a("active", true);
                if (world.field_72995_K) {
                    nbtData.func_74757_a("activateMessage", true);
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + Formater.formatMessage("message.text.activate")));
                }
                ElectricCarbonNanotubeSword.updateAttributes(nbtData);
            }
        } else {
            NBTTagCompound nbtData = StackUtils.getOrCreateNbtData(itemStack);
            if (nbtData.func_74762_e("Count") == 0) {
                nbtData.func_74768_a("Count", 20);
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + Formater.formatMessage("message.text.electricCarbonNanotubeSword") + " " + Formater.formatMessage("message.text.charge") + ":" + Long.toString((long)ElectricItem.manager.getCharge(itemStack)) + "/" + ConfigValues.carbonNanotubeToolsMaxEnergy + " " + (ElectricItem.manager.getCharge(itemStack) != 0.0 ? (Double.toString(ElectricItem.manager.getCharge(itemStack) / (double)ConfigValues.carbonNanotubeToolsMaxEnergy * 100.0).length() > 4 ? Double.toString(ElectricItem.manager.getCharge(itemStack) / (double)ConfigValues.carbonNanotubeToolsMaxEnergy * 100.0).substring(0, 5) + "%" : Double.toString(ElectricItem.manager.getCharge(itemStack) / (double)ConfigValues.carbonNanotubeToolsMaxEnergy * 100.0)) : "0.0%") + " " + EnumChatFormatting.GREEN + Formater.formatMessage("message.text.ConfigValues.carbonNanotubeToolsEnergyUse") + " : " + ConfigValues.carbonNanotubeToolsEnergyUse));
            }
        }
        return itemStack;
    }

    public static void drain(ItemStack itemStack, double amount, EntityLivingBase entity, World world) {
        if (!FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (!ElectricItem.manager.canUse(itemStack, amount)) {
                NBTTagCompound nbtData = StackUtils.getOrCreateNbtData(itemStack);
                nbtData.func_74757_a("active", false);
                nbtData.func_74768_a("heat", 0);
                if (world.field_72995_K) {
                    ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + Formater.formatMessage("message.text.deactivate") + "-" + Formater.formatMessage("message.text.outOfPower")));
                }
                ElectricCarbonNanotubeSword.updateAttributes(nbtData);
            } else {
                ElectricItem.manager.discharge(itemStack, amount, ConfigValues.carbonNanotubeToolsTier, true, false, false);
            }
        }
    }

    public static void drain(ItemStack itemStack, double amount, EntityLivingBase entity) {
        if (!ElectricItem.manager.use(itemStack, amount, entity)) {
            NBTTagCompound nbtData = StackUtils.getOrCreateNbtData(itemStack);
            nbtData.func_74757_a("active", false);
            nbtData.func_74768_a("heat", 0);
            ElectricCarbonNanotubeSword.updateAttributes(nbtData);
        }
    }

    private static void updateAttributes(NBTTagCompound nbtData) {
        boolean active = nbtData.func_74767_n("active");
        int damage = active ? nbtData.func_74762_e("heat") / 1000 : 10;
        NBTTagCompound entry = new NBTTagCompound();
        entry.func_74778_a("AttributeName", SharedMonsterAttributes.field_111264_e.func_111108_a());
        entry.func_74772_a("UUIDMost", field_111210_e.getMostSignificantBits());
        entry.func_74772_a("UUIDLeast", field_111210_e.getLeastSignificantBits());
        entry.func_74778_a("Name", "Tool modifier");
        entry.func_74780_a("Amount", (double)damage);
        entry.func_74768_a("Operation", 0);
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)entry);
        nbtData.func_74782_a("AttributeModifiers", (NBTBase)list);
    }

    public boolean onLeftClickEntity(ItemStack is, EntityPlayer player, Entity entity) {
        NBTTagCompound nbtData = StackUtils.getOrCreateNbtData(is);
        if (!nbtData.func_74767_n("active") && nbtData.func_74767_n("activateMessage")) {
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + Formater.formatMessage("message.text.sneakToActivate")));
            nbtData.func_74757_a("activateMessage", false);
        }
        return false;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return ConfigValues.carbonNanotubeToolsMaxEnergy;
    }

    public int getTier(ItemStack itemStack) {
        return ConfigValues.carbonNanotubeToolsTier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return ConfigValues.carbonNanotubeToolsTransferLimit;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_82789_a(ItemStack itemStack1, ItemStack itemStack2) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }
}

