/*
 * Decompiled with CFR 0.152.
 */
package com.chrislikesbirds.IC2;

import com.chrislikesbirds.Mod.Init;
import com.chrislikesbirds.Value.ConfigValues;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class ElectricCarbonNanotubeBoots
extends ItemArmor
implements ISpecialArmor,
IElectricItem {
    public ElectricCarbonNanotubeBoots(ItemArmor.ArmorMaterial material) {
        super(material, 3, 3);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.func_77637_a(Init.creativeTab);
        this.func_77655_b("itemElectricCarbonNanotubeBoots");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("carbon_mod:itemElectricCarbonNanotubeBoots");
    }

    public IIcon getIcon(ItemStack is, int a) {
        return this.field_77791_bV;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return ConfigValues.carbonNanotubeArmorEnergyStorage;
    }

    public int getTier(ItemStack itemStack) {
        return ConfigValues.carbonNanotubeArmorTier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return ConfigValues.carbonNanotubeArmorTransferRate;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 4;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)(ConfigValues.carbonNanotubeArmorEnergyUse * damage), ConfigValues.carbonNanotubeArmorTier, true, false, false);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase entity, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76355_l() != DamageSource.field_82728_o.func_76355_l() && source.func_76355_l() != DamageSource.field_76366_f.func_76355_l() && source.func_76355_l() != DamageSource.field_76379_h.func_76355_l() && source.func_76355_l() != DamageSource.field_76369_e.func_76355_l() && source.func_76355_l() != DamageSource.field_76380_i.func_76355_l() && source.func_76355_l() != DamageSource.field_76368_d.func_76355_l()) {
            int energyPerDamage = ConfigValues.carbonNanotubeArmorEnergyUse;
            int damageLimit = Integer.MAX_VALUE;
            if (energyPerDamage > 0) {
                damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
            }
            return new ISpecialArmor.ArmorProperties(10, 1.0, damageLimit);
        }
        return new ISpecialArmor.ArmorProperties(10, 1.0, 0);
    }

    public String getArmorTexture(ItemStack is, Entity player, int slot, String type) {
        return "carbon_mod:textures/models/armor/electricCarbonNanotubeArmorLayer1.png";
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        int fallDamage;
        double energyCost;
        EntityPlayer entity;
        ItemStack armor;
        if (event.entity instanceof EntityPlayer && (armor = (entity = (EntityPlayer)event.entity).func_82169_q(0)) != null && armor.func_77973_b() instanceof ElectricCarbonNanotubeBoots && (energyCost = (double)(ConfigValues.carbonNanotubeArmorEnergyUse * (fallDamage = Math.max((int)event.distance - 10, 0)))) <= ElectricItem.manager.getCharge(armor)) {
            ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, false, false);
            event.setCanceled(true);
        }
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_82789_a(ItemStack itemStack1, ItemStack itemStack2) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }
}

