/*
 * Decompiled with CFR 0.152.
 */
package com.chrislikesbirds.TileEntity;

import com.chrislikesbirds.Mod.Init;
import com.chrislikesbirds.ModUtils.StackUtils;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class FisherTileEntity
extends TileEntity
implements IEnergyTile,
IEnergySink,
INetworkDataProvider,
INetworkUpdateListener,
IWrenchable {
    boolean addedToENet;
    boolean loaded;
    boolean init;
    boolean fish;
    int fishRate;
    int energyCostTick;
    int count;
    int energyBuffer;
    int maxEnergy;
    int fishRare;
    int facing;
    int lastX;
    int lastY;
    int lastZ;
    Random rand;

    public FisherTileEntity(int fishRate, int energyCostTick, int maxEnergy, int fishRare, Random rand) {
        this.fishRate = fishRate;
        this.energyCostTick = energyCostTick;
        this.maxEnergy = maxEnergy;
        this.fishRare = fishRare;
        this.rand = rand;
    }

    public static String getName() {
        return "tileEntityFisher";
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.func_145837_r() || this.func_145831_w().func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        this.onLoaded();
    }

    public void init() {
        this.init = true;
        if (!this.addedToENet) {
            this.onLoaded();
        }
    }

    public void onLoaded() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToENet = true;
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToENet = false;
        }
        this.loaded = false;
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.init) {
            this.init();
        }
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.lastX != this.field_145851_c || this.lastZ != this.field_145848_d || this.lastY != this.field_145849_e) {
            this.lastX = this.field_145851_c;
            this.lastY = this.field_145848_d;
            this.lastZ = this.field_145849_e;
            this.onUnloaded();
            this.init();
        }
        if (this.count >= this.fishRate) {
            World w = this.func_145831_w();
            TileEntity[] tileEntity = new TileEntity[]{w.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e), w.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e), w.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e), w.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e), w.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1), w.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)};
            this.count = 0;
            this.fish = true;
            for (TileEntity tile : tileEntity) {
                if (!(tile instanceof IInventory)) continue;
                IInventory inventory = (IInventory)tile;
                if (StackUtils.addToInventory(new ItemStack(Items.field_151115_aP, 1, this.rand.nextInt(this.fishRare) != 1 ? 0 : this.rand.nextInt(4)), inventory) != null) continue;
                this.fish = false;
                break;
            }
            if (this.fish) {
                this.count = this.fishRate;
            }
        } else if (this.energyBuffer >= this.energyCostTick && !this.fish) {
            ++this.count;
            this.energyBuffer -= this.energyCostTick;
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public double getDemandedEnergy() {
        return this.maxEnergy - this.energyBuffer;
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.energyBuffer = (int)((double)this.energyBuffer + amount);
        return 0.0;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return side != this.facing;
    }

    public short getFacing() {
        return (short)this.facing;
    }

    public void setFacing(short facing) {
        this.facing = facing;
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack((Block)Init.fisher);
    }

    public void onNetworkUpdate(String field) {
    }

    public List<String> getNetworkedFields() {
        return Arrays.asList(new String[0]);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("storage", this.energyBuffer);
        nbt.func_74768_a("lastX", this.lastX);
        nbt.func_74768_a("lastY", this.lastY);
        nbt.func_74768_a("lastZ", this.lastZ);
        nbt.func_74768_a("facing", this.facing);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyBuffer = nbt.func_74762_e("storage");
        this.lastX = nbt.func_74762_e("lastX");
        this.lastY = nbt.func_74762_e("lastY");
        this.lastZ = nbt.func_74762_e("lastZ");
        this.facing = nbt.func_74762_e("facing");
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

