/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.api_compat;

import ic2.api.recipe.IFluidHeatManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class FluidHeatRecipeManager
implements IFluidHeatManager {
    private final Map<String, IFluidHeatManager.BurnProperty> recipes = new HashMap<String, IFluidHeatManager.BurnProperty>();
    private final Map<String, IFluidHeatManager.BurnProperty> recipesUnmod = Collections.unmodifiableMap(this.recipes);
    private final Set<Fluid> acceptedFluids = new HashSet<Fluid>();
    private final Set<Fluid> acceptedFluidsUnmod = Collections.unmodifiableSet(this.acceptedFluids);

    @Override
    public boolean acceptsFluid(Fluid fluid) {
        return this.recipes.containsKey(fluid.getName());
    }

    @Override
    public Set<Fluid> getAcceptedFluids() {
        return this.acceptedFluidsUnmod;
    }

    @Override
    public void addFluid(String fluidName, int amount, int heat) {
        Fluid f = FluidRegistry.getFluid((String)fluidName);
        if (f == null) {
            throw new IllegalArgumentException("No such fluid: " + fluidName);
        }
        if (amount == 0 || heat == 0) {
            return;
        }
        if (amount < 0 || heat < 0) {
            throw new IllegalArgumentException("negative amount or heat");
        }
        this.recipes.put(fluidName, new IFluidHeatManager.BurnProperty(amount, heat));
        this.acceptedFluids.add(f);
    }

    @Override
    public IFluidHeatManager.BurnProperty getBurnProperty(Fluid fluid) {
        return this.recipes.get(fluid.getName());
    }

    @Override
    public Map<String, IFluidHeatManager.BurnProperty> getBurnProperties() {
        return this.recipesUnmod;
    }
}

