/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.api_compat;

import ic2.api.recipe.ISemiFluidFuelManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class SemiFluidGeneratorRecipeManager
implements ISemiFluidFuelManager {
    private final Map<String, ISemiFluidFuelManager.BurnProperty> recipes = new HashMap<String, ISemiFluidFuelManager.BurnProperty>();
    private final Map<String, ISemiFluidFuelManager.BurnProperty> recipesUnmod = Collections.unmodifiableMap(this.recipes);
    private final Set<Fluid> acceptedFluids = new HashSet<Fluid>();
    private final Set<Fluid> acceptedFluidsUnmod = Collections.unmodifiableSet(this.acceptedFluids);

    @Override
    public boolean acceptsFluid(Fluid fluid) {
        return this.recipes.containsKey(fluid.getName());
    }

    @Override
    public Set<Fluid> getAcceptedFluids() {
        return this.acceptedFluidsUnmod;
    }

    @Override
    public void addFluid(String fluidName, int amount, double euPerTick) {
        Fluid f = FluidRegistry.getFluid((String)fluidName);
        if (f == null) {
            throw new IllegalArgumentException("No such fluid: " + fluidName);
        }
        if (amount == 0 || euPerTick == 0.0) {
            return;
        }
        if (amount < 0 || euPerTick < 0.0) {
            throw new IllegalArgumentException("negative amount or heat");
        }
        this.recipes.put(fluidName, new ISemiFluidFuelManager.BurnProperty(amount, euPerTick));
        this.acceptedFluids.add(f);
    }

    @Override
    public ISemiFluidFuelManager.BurnProperty getBurnProperty(Fluid fluid) {
        return this.recipes.get(fluid.getName());
    }

    @Override
    public Map<String, ISemiFluidFuelManager.BurnProperty> getBurnProperties() {
        return this.recipesUnmod;
    }
}

