/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.api_compat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class EnergyInterfaceClassAdapter
extends ClassVisitor {
    public static final String IS_ADDED_TO_ENERGY_NET_FIELD_NAME = "IC2_Classic_API_Compat_isAddedToEnergyNet";
    public static final String EXCESS_ENERGY_FIELD_NAME = "IC2_Classic_API_Compat_excessEnergy";
    boolean isSource;
    boolean isSink;
    String className;

    public EnergyInterfaceClassAdapter(ClassVisitor parent) {
        super(327680, parent);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        ArrayList<String> intfList = new ArrayList<String>(interfaces == null ? Collections.emptyList() : Arrays.asList(interfaces));
        if (intfList.contains("ic2/api/energy/tile/IEnergySource") && !intfList.contains("ic2classic/api/energy/tile/IEnergySource")) {
            this.isSource = true;
            intfList.add("ic2classic/api/energy/tile/IEnergySource");
        }
        if (intfList.contains("ic2/api/energy/tile/IEnergySink") && !intfList.contains("ic2classic/api/energy/tile/IEnergySink")) {
            this.isSink = true;
            intfList.add("ic2classic/api/energy/tile/IEnergySink");
        }
        this.className = name;
        super.visit(version, access, name, signature, superName, intfList.toArray(new String[intfList.size()]));
    }

    public void visitEnd() {
        if (this.isSource) {
            this.generateSourceAdapters();
        }
        if (this.isSink) {
            this.generateSinkAdapters();
        }
        if (this.isSource || this.isSink) {
            this.generateEnergyTileAdapters();
        }
        super.visitEnd();
    }

    public void generateEnergyTileAdapters() {
        FieldVisitor fv = this.visitField(1, IS_ADDED_TO_ENERGY_NET_FIELD_NAME, "Z", null, null);
        fv.visitEnd();
        MethodVisitor mv = this.visitMethod(1, "isAddedToEnergyNet", "()Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.className, IS_ADDED_TO_ENERGY_NET_FIELD_NAME, "Z");
        mv.visitInsn(172);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public void generateSourceAdapters() {
        MethodVisitor mv = this.visitMethod(1, "emitsEnergyTo", "(Lnet/minecraft/tileentity/TileEntity;Lic2classic/api/Direction;)Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "ic2classic/api/Direction", "toForgeDirection", "()Lnet/minecraftforge/common/util/ForgeDirection;", false);
        mv.visitMethodInsn(182, this.className, "emitsEnergyTo", "(Lnet/minecraft/tileentity/TileEntity;Lnet/minecraftforge/common/util/ForgeDirection;)Z", false);
        mv.visitInsn(172);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = this.visitMethod(1, "getMaxEnergyOutput", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.className, "getSourceTier", "()I", false);
        mv.visitMethodInsn(184, "ic2classic/api_compat/CompatUtils", "tierToMaxVoltage", "(I)I", false);
        mv.visitInsn(172);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public void generateSinkAdapters() {
        MethodVisitor mv = this.visitMethod(1, "acceptsEnergyFrom", "(Lnet/minecraft/tileentity/TileEntity;Lic2classic/api/Direction;)Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "ic2classic/api/Direction", "toForgeDirection", "()Lnet/minecraftforge/common/util/ForgeDirection;", false);
        mv.visitMethodInsn(182, this.className, "acceptsEnergyFrom", "(Lnet/minecraft/tileentity/TileEntity;Lnet/minecraftforge/common/util/ForgeDirection;)Z", false);
        mv.visitInsn(172);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = this.visitMethod(1, "demandsEnergy", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.className, "getDemandedEnergy", "()D", false);
        mv.visitInsn(142);
        mv.visitInsn(172);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = this.visitMethod(1, "getMaxSafeInput", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.className, "getSinkTier", "()I", false);
        mv.visitMethodInsn(184, "ic2classic/api_compat/CompatUtils", "tierToMaxVoltage", "(I)I", false);
        mv.visitInsn(172);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        this.visitField(1, EXCESS_ENERGY_FIELD_NAME, "D", null, null).visitEnd();
        mv = this.visitMethod(1, "injectEnergy", "(Lic2classic/api/Direction;I)Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(21, 2);
        mv.visitInsn(135);
        mv.visitVarInsn(57, 2);
        mv.visitInsn(3);
        mv.visitVarInsn(54, 4);
        Label dontUseEnergyLabel = new Label();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.className, EXCESS_ENERGY_FIELD_NAME, "D");
        mv.visitVarInsn(24, 2);
        mv.visitInsn(152);
        mv.visitJumpInsn(156, dontUseEnergyLabel);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitFieldInsn(180, this.className, EXCESS_ENERGY_FIELD_NAME, "D");
        mv.visitVarInsn(24, 2);
        mv.visitInsn(99);
        mv.visitFieldInsn(181, this.className, EXCESS_ENERGY_FIELD_NAME, "D");
        mv.visitInsn(4);
        mv.visitVarInsn(54, 4);
        mv.visitLabel(dontUseEnergyLabel);
        mv.visitFrame(-1, 4, new Object[]{this.className, "ic2classic/api/Direction", Opcodes.DOUBLE, Opcodes.INTEGER}, 0, new Object[0]);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "ic2classic/api/Direction", "toForgeDirection", "()Lnet/minecraftforge/common/util/ForgeDirection;", false);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.className, EXCESS_ENERGY_FIELD_NAME, "D");
        mv.visitVarInsn(24, 2);
        mv.visitMethodInsn(182, this.className, "injectEnergy", "(Lnet/minecraftforge/common/util/ForgeDirection;DD)D", false);
        mv.visitFieldInsn(181, this.className, EXCESS_ENERGY_FIELD_NAME, "D");
        mv.visitVarInsn(21, 4);
        mv.visitInsn(172);
        mv.visitMaxs(7, 5);
        mv.visitEnd();
    }
}

