/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.api_compat.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import ic2.api.network.INetworkUpdateListener;
import ic2classic.api_compat.network.ObjectIO;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import net.minecraft.tileentity.TileEntity;

public class MessageUpdateTEField
implements IMessage {
    int x;
    int y;
    int z;
    int dimension;
    String fieldName;
    Object value;

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.dimension = buf.readInt();
        this.fieldName = ObjectIO.readString(buf);
        this.value = ObjectIO.read(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.dimension);
        ObjectIO.writeString(this.fieldName, buf);
        ObjectIO.write(this.value, buf);
    }

    public void applyTo(TileEntity te) {
        try {
            MessageUpdateTEField.getField(te, this.fieldName).set(te, this.value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to set " + this.fieldName + " on " + te.getClass().getName(), e);
        }
        if (te instanceof INetworkUpdateListener) {
            ((INetworkUpdateListener)te).onNetworkUpdate(this.fieldName);
        }
    }

    public static Field getField(TileEntity te, String fieldName) throws ReflectiveOperationException {
        return MessageUpdateTEField.getField(te.getClass(), fieldName);
    }

    public static Field getField(Class<?> clazz, String fieldName) throws ReflectiveOperationException {
        if (clazz == Object.class) {
            throw new NoSuchFieldException();
        }
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException e) {
            return MessageUpdateTEField.getField(clazz.getSuperclass(), fieldName);
        }
    }
}

