/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.api_compat;

import ic2.api.recipe.ICannerEnrichRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class CannerEnrichRecipeManager
implements ICannerEnrichRecipeManager {
    private final List<Map.Entry<ICannerEnrichRecipeManager.Input, RecipeOutput>> entries = new ArrayList<Map.Entry<ICannerEnrichRecipeManager.Input, RecipeOutput>>();

    @Override
    public void addRecipe(FluidStack input, IRecipeInput additive, FluidStack output) {
        if (input == null || additive == null || output == null) {
            throw new NullPointerException();
        }
        RecipeOutput ro = new RecipeOutput(output.writeToNBT(new NBTTagCompound()), new ItemStack[0]);
        this.entries.add(new AbstractMap.SimpleEntry<ICannerEnrichRecipeManager.Input, RecipeOutput>(new ICannerEnrichRecipeManager.Input(input, additive), ro));
    }

    @Override
    public RecipeOutput getOutputFor(FluidStack input, ItemStack additive, boolean adjustInput, boolean acceptTest) {
        if (!(input != null && additive != null || acceptTest)) {
            return null;
        }
        for (Map.Entry<ICannerEnrichRecipeManager.Input, RecipeOutput> entry : this.entries) {
            if (input != null && (!entry.getKey().fluid.isFluidEqual(input) || input.amount < entry.getKey().fluid.amount) || additive != null && !entry.getKey().additive.matches(additive)) continue;
            if (adjustInput) {
                if (input != null) {
                    input.amount -= entry.getKey().fluid.amount;
                }
                if (additive != null) {
                    additive.field_77994_a -= entry.getKey().additive.getAmount();
                }
            }
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Map<ICannerEnrichRecipeManager.Input, FluidStack> getRecipes() {
        return null;
    }
}

