/*
 * Decompiled with CFR 0.152.
 */
package extracells.item;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import extracells.api.IFluidStorageCell;
import extracells.api.IHandlerFluidStorage;
import extracells.registries.ItemEnum;
import extracells.util.inventory.ECFluidFilterInventory;
import extracells.util.inventory.ECPrivateInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class ItemStorageFluid
extends Item
implements IFluidStorageCell {
    public static final String[] suffixes = new String[]{"1k", "4k", "16k", "64k", "256k", "1024k", "4096k"};
    public static final int[] spaces = new int[]{1024, 4096, 16348, 65536, 262144, 0x100000, 0x400000};
    private IIcon[] icons;

    public ItemStorageFluid() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public IIcon func_77617_a(int dmg) {
        int j = MathHelper.func_76125_a((int)dmg, (int)0, (int)suffixes.length);
        return this.icons[j];
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[suffixes.length];
        for (int i = 0; i < suffixes.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("extracells:storage.fluid." + suffixes[i]);
        }
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List listSubItems) {
        for (int i = 0; i < suffixes.length; ++i) {
            listSubItems.add(new ItemStack(item, 1, i));
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        return "extracells.item.storage.fluid." + suffixes[itemStack.func_77960_j()];
    }

    @Override
    public int getMaxTypes(ItemStack unused) {
        return 5;
    }

    @Override
    public int getMaxBytes(ItemStack is) {
        return spaces[Math.max(0, is.func_77960_j())];
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        IMEInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory(itemStack, null, StorageChannel.FLUIDS);
        if (!(handler instanceof IHandlerFluidStorage)) {
            return;
        }
        IHandlerFluidStorage cellHandler = (IHandlerFluidStorage)handler;
        boolean partitioned = cellHandler.isFormatted();
        long usedBytes = cellHandler.usedBytes();
        list.add(String.format(StatCollector.func_74838_a((String)"extracells.tooltip.storage.fluid.bytes"), usedBytes / 250L, cellHandler.totalBytes() / 250));
        list.add(String.format(StatCollector.func_74838_a((String)"extracells.tooltip.storage.fluid.types"), cellHandler.usedTypes(), cellHandler.totalTypes()));
        if (usedBytes != 0L) {
            list.add(String.format(StatCollector.func_74838_a((String)"extracells.tooltip.storage.fluid.content"), usedBytes));
        }
        if (partitioned) {
            list.add(StatCollector.func_74838_a((String)"gui.appliedenergistics2.Partitioned") + " - " + StatCollector.func_74838_a((String)"gui.appliedenergistics2.Precise"));
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (!entityPlayer.func_70093_af()) {
            return itemStack;
        }
        IMEInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory(itemStack, null, StorageChannel.FLUIDS);
        if (!(handler instanceof IHandlerFluidStorage)) {
            return itemStack;
        }
        IHandlerFluidStorage cellHandler = (IHandlerFluidStorage)handler;
        if (cellHandler.usedBytes() == 0 && entityPlayer.field_71071_by.func_70441_a(ItemEnum.STORAGECASING.getDamagedStack(1))) {
            return ItemEnum.STORAGECOMPONET.getDamagedStack(itemStack.func_77960_j() + 4);
        }
        return itemStack;
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.rare;
    }

    public boolean isEditable(ItemStack is) {
        if (is == null) {
            return false;
        }
        return is.func_77973_b() == this;
    }

    public IInventory getUpgradesInventory(ItemStack is) {
        return new ECPrivateInventory("configInventory", 0, 64);
    }

    public IInventory getConfigInventory(ItemStack is) {
        return new ECFluidFilterInventory("configFluidCell", 63, is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        if (is == null) {
            return null;
        }
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        if (is.func_77978_p().func_74764_b("fuzzyMode")) {
            return FuzzyMode.valueOf((String)is.func_77978_p().func_74779_i("fuzzyMode"));
        }
        is.func_77978_p().func_74778_a("fuzzyMode", FuzzyMode.IGNORE_ALL.name());
        return FuzzyMode.IGNORE_ALL;
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        if (is == null) {
            return;
        }
        NBTTagCompound tag = is.func_77942_o() ? is.func_77978_p() : new NBTTagCompound();
        tag.func_74778_a("fuzzyMode", fzMode.name());
        is.func_77982_d(tag);
    }

    @Override
    public ArrayList<Fluid> getFilter(ItemStack stack) {
        ECFluidFilterInventory inventory = new ECFluidFilterInventory("", 63, stack);
        ItemStack[] stacks = inventory.slots;
        ArrayList<Fluid> filter = new ArrayList<Fluid>();
        if (stacks.length == 0) {
            return null;
        }
        for (ItemStack s : stacks) {
            Fluid f;
            if (s == null || (f = FluidRegistry.getFluid((int)s.func_77960_j())) == null) continue;
            filter.add(f);
        }
        return filter;
    }
}

