/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.network.AbstractPacket;
import extracells.part.PartECBase;
import extracells.render.TextureManager;
import extracells.util.inventory.ECPrivateInventory;
import extracells.util.inventory.IInventoryUpdateReceiver;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class PartBattery
extends PartECBase
implements IAEPowerStorage,
IInventoryUpdateReceiver {
    private IIcon batteryIcon = TextureManager.BATTERY_FRONT.getTexture();
    private ItemStack battery;
    IAEItemPowerStorage handler;
    private ECPrivateInventory inventory = new ECPrivateInventory("extracells.part.battery", 1, 1){

        @Override
        public boolean func_94041_b(int i, ItemStack itemStack) {
            return itemStack != null && itemStack.func_77973_b() instanceof IAEItemPowerStorage;
        }
    };

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        IIcon side = TextureManager.BUS_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.BATTERY_FRONT.getTextures()[0], side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderInventoryBusLights(rh, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        IIcon side = TextureManager.BUS_SIDE.getTexture();
        rh.setTexture(side, side, side, this.batteryIcon, side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderStaticBusLights(x, y, z, rh, renderer);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inventory.readFromNBT(data.func_150295_c("inventory", 10));
        this.onInventoryChanged();
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        AbstractPacket.writeString(this.battery != null ? this.battery.func_77973_b().func_77650_f(this.battery).func_94215_i() : "none", data);
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        String iconName = AbstractPacket.readString(data);
        this.batteryIcon = !iconName.equals("none") ? ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b(iconName) : TextureManager.BATTERY_FRONT.getTexture();
        return true;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
    }

    @Override
    public int cableConnectionRenderTo() {
        return 2;
    }

    @Override
    public void onInventoryChanged() {
        this.battery = this.inventory.func_70301_a(0);
        if (this.battery != null && this.battery.func_77973_b() instanceof IAEItemPowerStorage) {
            this.batteryIcon = this.battery.func_77954_c();
            this.handler = (IAEItemPowerStorage)this.battery.func_77973_b();
        } else {
            this.batteryIcon = null;
            this.handler = null;
        }
        IGridNode node = this.getGridNode();
        if (node != null) {
            IGrid grid = node.getGrid();
            if (grid != null) {
                grid.postEvent((MENetworkEvent)new MENetworkPowerStorage((IAEPowerStorage)this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
            this.getHost().markForUpdate();
        }
    }

    public double injectAEPower(double amt, Actionable mode) {
        if (this.handler == null || this.battery == null) {
            return 0.0;
        }
        return this.handler.injectAEPower(mode == Actionable.MODULATE ? this.battery : this.battery.func_77946_l(), amt);
    }

    public double getAEMaxPower() {
        if (this.handler == null || this.battery == null) {
            return 0.0;
        }
        return this.handler.getAEMaxPower(this.battery);
    }

    public double getAECurrentPower() {
        if (this.handler == null || this.battery == null) {
            return 0.0;
        }
        return this.handler.getAECurrentPower(this.battery);
    }

    public boolean isAEPublicPowerStorage() {
        return true;
    }

    public AccessRestriction getPowerFlow() {
        if (this.handler == null || this.battery == null) {
            return AccessRestriction.NO_ACCESS;
        }
        return this.handler.getPowerFlow(this.battery);
    }

    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        if (this.handler == null || this.battery == null) {
            return 0.0;
        }
        return this.handler.extractAEPower(mode == Actionable.MODULATE ? this.battery : this.battery.func_77946_l(), usePowerMultiplier.multiply(amt));
    }
}

