/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.container.ContainerFluidEmitter;
import extracells.gui.GuiFluidEmitter;
import extracells.network.packet.other.IFluidSlotPartOrBlock;
import extracells.network.packet.other.PacketFluidSlot;
import extracells.network.packet.part.PacketFluidEmitter;
import extracells.part.PartECBase;
import extracells.render.TextureManager;
import extracells.util.PermissionUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Random;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PartFluidLevelEmitter
extends PartECBase
implements IStackWatcherHost,
IFluidSlotPartOrBlock {
    private Fluid fluid;
    private RedstoneMode mode = RedstoneMode.HIGH_SIGNAL;
    private IStackWatcher watcher;
    private long wantedAmount;
    private long currentAmount;
    private boolean clientRedstoneOutput = false;

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(TextureManager.LEVEL_FRONT.getTextures()[0]);
        rh.setBounds(7.0f, 7.0f, 11.0f, 9.0f, 9.0f, 14.0f);
        rh.renderInventoryBox(renderer);
        rh.setTexture(TextureManager.LEVEL_FRONT.getTextures()[1]);
        rh.setBounds(7.0f, 7.0f, 14.0f, 9.0f, 9.0f, 16.0f);
        rh.renderInventoryBox(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(TextureManager.LEVEL_FRONT.getTextures()[0]);
        rh.setBounds(7.0f, 7.0f, 11.0f, 9.0f, 9.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(this.clientRedstoneOutput ? TextureManager.LEVEL_FRONT.getTextures()[2] : TextureManager.LEVEL_FRONT.getTextures()[1]);
        rh.setBounds(7.0f, 7.0f, 14.0f, 9.0f, 9.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.fluid != null) {
            data.func_74778_a("fluid", this.fluid.getName());
        } else {
            data.func_82580_o("fluid");
        }
        data.func_74768_a("mode", this.mode.ordinal());
        data.func_74772_a("wantedAmount", this.wantedAmount);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.fluid = FluidRegistry.getFluid((String)data.func_74779_i("fluid"));
        this.mode = RedstoneMode.values()[data.func_74762_e("mode")];
        this.wantedAmount = data.func_74763_f("wantedAmount");
        if (this.wantedAmount < 0L) {
            this.wantedAmount = 0L;
        }
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(7.0, 7.0, 11.0, 9.0, 9.0, 16.0);
    }

    @Override
    public int cableConnectionRenderTo() {
        return 8;
    }

    public void updateWatcher(IStackWatcher newWatcher) {
        this.watcher = newWatcher;
        if (this.fluid != null) {
            this.watcher.add((Object)AEApi.instance().storage().createFluidStack(new FluidStack(this.fluid, 1)));
        }
    }

    public void onStackChange(IItemList o, IAEStack fullStack, IAEStack diffStack, BaseActionSource src, StorageChannel chan) {
        if (chan == StorageChannel.FLUIDS && diffStack != null && ((IAEFluidStack)diffStack).getFluid() == this.fluid) {
            this.currentAmount = fullStack != null ? fullStack.getStackSize() : 0L;
            IGridNode node = this.getGridNode();
            if (node != null) {
                this.setActive(node.isActive());
                this.getHost().markForUpdate();
                this.notifyTargetBlock(this.getHostTile(), this.getSide());
            }
        }
    }

    @Override
    public int isProvidingStrongPower() {
        return this.isPowering() ? 15 : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.isProvidingStrongPower();
    }

    private boolean isPowering() {
        switch (this.mode) {
            case LOW_SIGNAL: {
                return this.wantedAmount >= this.currentAmount;
            }
            case HIGH_SIGNAL: {
                return this.wantedAmount <= this.currentAmount;
            }
        }
        return false;
    }

    @Override
    public void setFluid(int _index, Fluid _fluid, EntityPlayer _player) {
        this.fluid = _fluid;
        if (this.watcher == null) {
            return;
        }
        this.watcher.clear();
        this.updateWatcher(this.watcher);
        new PacketFluidSlot(Lists.newArrayList((Object[])new Fluid[]{this.fluid})).sendPacketToPlayer(_player);
        this.saveData();
    }

    public void toggleMode(EntityPlayer player) {
        switch (this.mode) {
            case LOW_SIGNAL: {
                this.mode = RedstoneMode.HIGH_SIGNAL;
                break;
            }
            default: {
                this.mode = RedstoneMode.LOW_SIGNAL;
            }
        }
        this.notifyTargetBlock(this.getHostTile(), this.getSide());
        new PacketFluidEmitter(this.mode, player).sendPacketToPlayer(player);
        this.saveData();
    }

    public void setWantedAmount(long _wantedAmount, EntityPlayer player) {
        this.wantedAmount = _wantedAmount;
        if (this.wantedAmount < 0L) {
            this.wantedAmount = 0L;
        }
        new PacketFluidEmitter(this.wantedAmount, player).sendPacketToPlayer(player);
        this.notifyTargetBlock(this.getHostTile(), this.getSide());
        this.saveData();
    }

    private void notifyTargetBlock(TileEntity _tile, ForgeDirection _side) {
        _tile.func_145831_w().func_147459_d(_tile.field_145851_c, _tile.field_145848_d, _tile.field_145849_e, Blocks.field_150350_a);
        _tile.func_145831_w().func_147459_d(_tile.field_145851_c + _side.offsetX, _tile.field_145848_d + _side.offsetY, _tile.field_145849_e + _side.offsetZ, Blocks.field_150350_a);
    }

    public void changeWantedAmount(int modifier, EntityPlayer player) {
        this.setWantedAmount(this.wantedAmount + (long)modifier, player);
    }

    public void syncClientGui(EntityPlayer player) {
        new PacketFluidEmitter(this.mode, player).sendPacketToPlayer(player);
        new PacketFluidEmitter(this.wantedAmount, player).sendPacketToPlayer(player);
        new PacketFluidSlot(Lists.newArrayList((Object[])new Fluid[]{this.fluid})).sendPacketToPlayer(player);
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerFluidEmitter(this, player);
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiFluidEmitter(this, player);
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isPowering());
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        this.clientRedstoneOutput = data.readBoolean();
        return true;
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random r) {
        if (this.clientRedstoneOutput) {
            ForgeDirection d = this.getSide();
            double d0 = (double)((float)d.offsetX * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)d.offsetY * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)d.offsetZ * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            world.func_72869_a("reddust", 0.5 + (double)x + d0, 0.5 + (double)y + d1, 0.5 + (double)z + d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        if (PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this)) {
            return super.onActivate(player, pos);
        }
        return false;
    }
}

