/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.crafting.ICraftingWatcher;
import appeng.api.networking.crafting.ICraftingWatcherHost;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import cpw.mods.fml.common.FMLCommonHandler;
import extracells.api.IECTileEntity;
import extracells.crafting.CraftingPattern;
import extracells.gridblock.ECFluidGridBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityFluidCrafter
extends TileEntity
implements IActionHost,
ICraftingProvider,
ICraftingWatcherHost,
IECTileEntity {
    private ECFluidGridBlock gridBlock;
    private IGridNode node = null;
    private List<ICraftingPatternDetails> patternHandlers = new ArrayList<ICraftingPatternDetails>();
    private List<IAEItemStack> requestedItems = new ArrayList<IAEItemStack>();
    private List<IAEItemStack> removeList = new ArrayList<IAEItemStack>();
    private boolean isBusy = false;
    private ICraftingWatcher watcher = null;
    private boolean isFirstGetGridNode = true;
    public final FluidCrafterInventory inventory;
    private Long finishCraftingTime = 0L;
    private ItemStack returnStack = null;
    private ItemStack[] optionalReturnStack = new ItemStack[0];
    private boolean update = false;
    private final TileEntityFluidCrafter instance;

    public TileEntityFluidCrafter() {
        this.gridBlock = new ECFluidGridBlock(this);
        this.inventory = new FluidCrafterInventory();
        this.instance = this;
    }

    public IGridNode getActionableNode() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return null;
        }
        if (this.node == null) {
            this.node = AEApi.instance().createGridNode((IGridBlock)this.gridBlock);
        }
        return this.node;
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        if (FMLCommonHandler.instance().getSide().isClient() && (this.func_145831_w() == null || this.func_145831_w().field_72995_K)) {
            return null;
        }
        if (this.isFirstGetGridNode) {
            this.isFirstGetGridNode = false;
            this.getActionableNode().updateState();
        }
        return this.node;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    public void securityBreak() {
    }

    @Override
    public double getPowerUsage() {
        return 0.0;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public IGridNode getGridNode() {
        return this.getGridNode(ForgeDirection.UNKNOWN);
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (this.isBusy) {
            return false;
        }
        if (patternDetails instanceof CraftingPattern) {
            IAEFluidStack extractFluid;
            Long amount;
            CraftingPattern patter = (CraftingPattern)patternDetails;
            HashMap<Fluid, Long> fluids = new HashMap<Fluid, Long>();
            for (IAEFluidStack stack : patter.getCondensedFluidInputs()) {
                if (fluids.containsKey(stack.getFluid())) {
                    amount = (Long)fluids.get(stack.getFluid()) + stack.getStackSize();
                    fluids.remove(stack.getFluid());
                    fluids.put(stack.getFluid(), amount);
                    continue;
                }
                fluids.put(stack.getFluid(), stack.getStackSize());
            }
            IGrid grid = this.node.getGrid();
            if (grid == null) {
                return false;
            }
            IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
            if (storage == null) {
                return false;
            }
            for (Fluid fluid : fluids.keySet()) {
                amount = (Long)fluids.get(fluid);
                extractFluid = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(fluid, (int)(amount + 0L))), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                if (extractFluid != null && extractFluid.getStackSize() == amount.longValue()) continue;
                return false;
            }
            for (Fluid fluid : fluids.keySet()) {
                amount = (Long)fluids.get(fluid);
                extractFluid = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(fluid, (int)(amount + 0L))), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
            }
            this.finishCraftingTime = System.currentTimeMillis() + 1000L;
            this.returnStack = patter.getOutput(table, this.func_145831_w());
            this.optionalReturnStack = new ItemStack[9];
            for (int i = 0; i < 9; ++i) {
                ItemStack s = table.func_70301_a(i);
                if (s == null || s.func_77973_b() == null) continue;
                this.optionalReturnStack[i] = s.func_77973_b().getContainerItem(s.func_77946_l());
            }
            this.isBusy = true;
        }
        return true;
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.patternHandlers = new ArrayList<ICraftingPatternDetails>();
        for (ItemStack currentPatternStack : this.inventory.inv) {
            ICraftingPatternItem currentPattern;
            if (currentPatternStack == null || currentPatternStack.func_77973_b() == null || !(currentPatternStack.func_77973_b() instanceof ICraftingPatternItem) || (currentPattern = (ICraftingPatternItem)currentPatternStack.func_77973_b()) == null || currentPattern.getPatternForItem(currentPatternStack, this.func_145831_w()) == null || !currentPattern.getPatternForItem(currentPatternStack, this.func_145831_w()).isCraftable()) continue;
            CraftingPattern pattern = new CraftingPattern(currentPattern.getPatternForItem(currentPatternStack, this.func_145831_w()));
            this.patternHandlers.add(pattern);
            if (pattern.getCondensedInputs().length == 0) {
                craftingTracker.setEmitable(pattern.getCondensedOutputs()[0]);
                continue;
            }
            craftingTracker.addCraftingOption((ICraftingMedium)this, (ICraftingPatternDetails)pattern);
        }
        this.updateWatcher();
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.inventory.writeToNBT(tagCompound);
        if (!this.func_145830_o()) {
            return;
        }
        IGridNode node = this.getGridNode();
        if (node != null) {
            NBTTagCompound nodeTag = new NBTTagCompound();
            node.saveToNBT("node0", nodeTag);
            tagCompound.func_74782_a("nodes", (NBTBase)nodeTag);
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
        if (this.func_145830_o()) {
            IGridNode node = this.getGridNode();
            if (tagCompound.func_74764_b("nodes") && node != null) {
                node.loadFromNBT("node0", tagCompound.func_74775_l("nodes"));
                node.updateState();
            }
        }
    }

    public void func_145845_h() {
        if (this.func_145831_w() == null || this.func_145831_w().field_73011_w == null) {
            return;
        }
        if (this.update) {
            this.update = false;
            if (this.getGridNode() != null && this.getGridNode().getGrid() != null) {
                this.getGridNode().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this.instance, this.getGridNode()));
            }
        }
        if (this.isBusy && this.finishCraftingTime <= System.currentTimeMillis() && this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            if (this.node == null || this.returnStack == null) {
                return;
            }
            IGrid grid = this.node.getGrid();
            if (grid == null) {
                return;
            }
            IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
            if (storage == null) {
                return;
            }
            storage.getItemInventory().injectItems((IAEStack)AEApi.instance().storage().createItemStack(this.returnStack), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
            for (ItemStack s : this.optionalReturnStack) {
                if (s == null) continue;
                storage.getItemInventory().injectItems((IAEStack)AEApi.instance().storage().createItemStack(s), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
            }
            this.optionalReturnStack = new ItemStack[0];
            this.isBusy = false;
            this.returnStack = null;
        }
        if (!this.isBusy && this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            for (IAEItemStack stack : this.removeList) {
                this.requestedItems.remove(stack);
            }
            this.removeList.clear();
            if (!this.requestedItems.isEmpty()) {
                block2: for (IAEItemStack s : this.requestedItems) {
                    ICraftingGrid crafting;
                    IGrid grid = this.node.getGrid();
                    if (grid == null || (crafting = (ICraftingGrid)grid.getCache(ICraftingGrid.class)) == null) break;
                    if (!crafting.isRequesting(s)) {
                        this.removeList.add(s);
                        continue;
                    }
                    for (ICraftingPatternDetails details : this.patternHandlers) {
                        IAEFluidStack extractFluid;
                        Long amount;
                        if (!details.getCondensedOutputs()[0].equals(s)) continue;
                        CraftingPattern patter = (CraftingPattern)details;
                        HashMap<Fluid, Long> fluids = new HashMap<Fluid, Long>();
                        for (IAEFluidStack stack : patter.getCondensedFluidInputs()) {
                            if (fluids.containsKey(stack.getFluid())) {
                                amount = (Long)fluids.get(stack.getFluid()) + stack.getStackSize();
                                fluids.remove(stack.getFluid());
                                fluids.put(stack.getFluid(), amount);
                                continue;
                            }
                            fluids.put(stack.getFluid(), stack.getStackSize());
                        }
                        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
                        if (storage == null) continue block2;
                        boolean doBreak = false;
                        for (Fluid fluid : fluids.keySet()) {
                            amount = (Long)fluids.get(fluid);
                            extractFluid = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(fluid, (int)(amount + 0L))), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                            if (extractFluid != null && extractFluid.getStackSize() == amount.longValue()) continue;
                            doBreak = true;
                            break;
                        }
                        if (doBreak) continue block2;
                        for (Fluid fluid : fluids.keySet()) {
                            amount = (Long)fluids.get(fluid);
                            extractFluid = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(fluid, (int)(amount + 0L))), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                        }
                        this.finishCraftingTime = System.currentTimeMillis() + 1000L;
                        this.returnStack = patter.getCondensedOutputs()[0].getItemStack();
                        this.isBusy = true;
                        return;
                    }
                }
            }
        }
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public void updateWatcher(ICraftingWatcher newWatcher) {
        this.watcher = newWatcher;
        this.updateWatcher();
    }

    public void onRequestChange(ICraftingGrid craftingGrid, IAEItemStack what) {
        if (craftingGrid.isRequesting(what)) {
            if (!this.requestedItems.contains(what)) {
                this.requestedItems.add(what);
            }
        } else if (this.requestedItems.contains(what)) {
            this.requestedItems.remove(what);
        }
    }

    private void updateWatcher() {
        this.requestedItems = new ArrayList<IAEItemStack>();
        IGrid grid = null;
        IGridNode node = this.getGridNode();
        ICraftingGrid crafting = null;
        if (node != null && (grid = node.getGrid()) != null) {
            crafting = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        }
        for (ICraftingPatternDetails patter : this.patternHandlers) {
            this.watcher.clear();
            if (patter.getCondensedInputs().length != 0) continue;
            this.watcher.add((Object)patter.getCondensedOutputs()[0]);
            if (crafting == null || !crafting.isRequesting(patter.getCondensedOutputs()[0])) continue;
            this.requestedItems.add(patter.getCondensedOutputs()[0]);
        }
    }

    private class FluidCrafterInventory
    implements IInventory {
        private ItemStack[] inv = new ItemStack[9];

        private FluidCrafterInventory() {
        }

        public int func_70302_i_() {
            return this.inv.length;
        }

        public ItemStack func_70301_a(int slot) {
            return this.inv[slot];
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.inv[slot] = stack;
            if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
            TileEntityFluidCrafter.this.update = true;
        }

        public ItemStack func_70298_a(int slot, int amt) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack != null) {
                if (stack.field_77994_a <= amt) {
                    this.func_70299_a(slot, null);
                } else {
                    stack = stack.func_77979_a(amt);
                    if (stack.field_77994_a == 0) {
                        this.func_70299_a(slot, null);
                    }
                }
            }
            TileEntityFluidCrafter.this.update = true;
            return stack;
        }

        public ItemStack func_70304_b(int slot) {
            return null;
        }

        public int func_70297_j_() {
            return 1;
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public void readFromNBT(NBTTagCompound tagCompound) {
            NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inv.length) continue;
                this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
        }

        public void writeToNBT(NBTTagCompound tagCompound) {
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < this.inv.length; ++i) {
                ItemStack stack = this.inv[i];
                if (stack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        }

        public String func_145825_b() {
            return "inventory.fluidCrafter";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public void func_70296_d() {
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            if (stack.func_77973_b() instanceof ICraftingPatternItem) {
                ICraftingPatternDetails details = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, TileEntityFluidCrafter.this.func_145831_w());
                return details != null && details.isCraftable();
            }
            return false;
        }
    }
}

