/*
 * Decompiled with CFR 0.152.
 */
package extracells.network.packet.part;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.container.ContainerFluidInterface;
import extracells.gui.GuiFluidInterface;
import extracells.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PacketFluidInterface
extends AbstractPacket {
    FluidStack[] tank;
    Integer[] filter;
    int fluidID;
    int filterSlot;

    public PacketFluidInterface() {
    }

    public PacketFluidInterface(FluidStack[] _tank, Integer[] _filter, EntityPlayer _player) {
        super(_player);
        this.mode = 0;
        this.tank = _tank;
        this.filter = _filter;
    }

    public PacketFluidInterface(int _fluidID, int _filterSlot, EntityPlayer _player) {
        super(_player);
        this.mode = 1;
        this.fluidID = _fluidID;
        this.filterSlot = _filterSlot;
    }

    @Override
    public void writeData(ByteBuf out) {
        switch (this.mode) {
            case 0: {
                int i;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("lengthTank", this.tank.length);
                for (i = 0; i < this.tank.length; ++i) {
                    if (this.tank[i] == null) continue;
                    tag.func_74782_a("tank#" + i, (NBTBase)this.tank[i].writeToNBT(new NBTTagCompound()));
                }
                tag.func_74768_a("lengthFilter", this.filter.length);
                for (i = 0; i < this.filter.length; ++i) {
                    if (this.filter[i] == null) continue;
                    tag.func_74768_a("filter#" + i, this.filter[i].intValue());
                }
                ByteBufUtils.writeTag((ByteBuf)out, (NBTTagCompound)tag);
                break;
            }
            case 1: {
                out.writeInt(this.filterSlot);
                out.writeInt(this.fluidID);
                break;
            }
        }
    }

    @Override
    public void readData(ByteBuf in) {
        switch (this.mode) {
            case 0: {
                int i;
                NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)in);
                this.tank = new FluidStack[tag.func_74762_e("lengthTank")];
                for (i = 0; i < this.tank.length; ++i) {
                    this.tank[i] = tag.func_74764_b("tank#" + i) ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("tank#" + i)) : null;
                }
                this.filter = new Integer[tag.func_74762_e("lengthFilter")];
                for (i = 0; i < this.filter.length; ++i) {
                    this.filter[i] = tag.func_74764_b("filter#" + i) ? Integer.valueOf(tag.func_74762_e("filter#" + i)) : Integer.valueOf(-1);
                }
                break;
            }
            case 1: {
                this.filterSlot = in.readInt();
                this.fluidID = in.readInt();
                break;
            }
        }
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                this.mode0();
                break;
            }
            case 1: {
                if (this.player.field_71070_bA == null || !(this.player.field_71070_bA instanceof ContainerFluidInterface)) break;
                ContainerFluidInterface container = (ContainerFluidInterface)this.player.field_71070_bA;
                container.fluidInterface.setFilter(ForgeDirection.getOrientation((int)this.filterSlot), FluidRegistry.getFluid((int)this.fluidID));
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void mode0() {
        EntityClientPlayerMP p = Minecraft.func_71410_x().field_71439_g;
        if (p.field_71070_bA != null && p.field_71070_bA instanceof ContainerFluidInterface) {
            ContainerFluidInterface container = (ContainerFluidInterface)p.field_71070_bA;
            if (Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof GuiFluidInterface) {
                int i;
                GuiFluidInterface gui = (GuiFluidInterface)Minecraft.func_71410_x().field_71462_r;
                for (i = 0; i < this.tank.length; ++i) {
                    container.fluidInterface.setFluidTank(ForgeDirection.getOrientation((int)i), this.tank[i]);
                }
                for (i = 0; i < this.filter.length; ++i) {
                    if (gui.filter[i] == null) continue;
                    gui.filter[i].setFluid(FluidRegistry.getFluid((int)this.filter[i]));
                }
            }
        }
    }
}

