/*
 * Decompiled with CFR 0.152.
 */
package extracells.gui;

import appeng.api.storage.data.IAEFluidStack;
import extracells.Extracells;
import extracells.api.ECApi;
import extracells.container.ContainerFluidStorage;
import extracells.gui.widget.FluidWidgetComparator;
import extracells.gui.widget.fluid.AbstractFluidWidget;
import extracells.gui.widget.fluid.IFluidSelectorContainer;
import extracells.gui.widget.fluid.IFluidSelectorGui;
import extracells.gui.widget.fluid.WidgetFluidSelector;
import extracells.network.packet.part.PacketFluidStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiFluidStorage
extends GuiContainer
implements IFluidSelectorGui {
    private EntityPlayer player;
    private int currentScroll = 0;
    private GuiTextField searchbar;
    private List<AbstractFluidWidget> fluidWidgets = new ArrayList<AbstractFluidWidget>();
    private ResourceLocation guiTexture = new ResourceLocation("extracells", "textures/gui/terminalfluid.png");
    public IAEFluidStack currentFluid;
    private ContainerFluidStorage containerFluidStorage = (ContainerFluidStorage)this.field_147002_h;
    private final String guiName;

    public GuiFluidStorage(EntityPlayer _player, String _guiName) {
        super((Container)new ContainerFluidStorage(_player));
        this.containerFluidStorage.setGui(this);
        this.player = _player;
        this.field_146999_f = 176;
        this.field_147000_g = 204;
        this.guiName = _guiName;
        new PacketFluidStorage(this.player).sendPacketToServer();
    }

    public void updateFluids() {
        this.fluidWidgets = new ArrayList<AbstractFluidWidget>();
        for (IAEFluidStack fluidStack : this.containerFluidStorage.getFluidStackList()) {
            if (!fluidStack.getFluid().getLocalizedName(fluidStack.getFluidStack()).toLowerCase().contains(this.searchbar.func_146179_b().toLowerCase()) || !ECApi.instance().canFluidSeeInTerminal(fluidStack.getFluid())) continue;
            this.fluidWidgets.add(new WidgetFluidSelector(this, fluidStack));
        }
        this.updateSelectedFluid();
    }

    public void updateSelectedFluid() {
        this.currentFluid = null;
        for (IAEFluidStack stack : this.containerFluidStorage.getFluidStackList()) {
            if (stack.getFluid() != this.containerFluidStorage.getSelectedFluid()) continue;
            this.currentFluid = stack;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Mouse.getDWheel();
        this.updateFluids();
        Collections.sort(this.fluidWidgets, new FluidWidgetComparator());
        this.searchbar = new GuiTextField(this.field_146289_q, this.field_147003_i + 81, this.field_147009_r - 12, 88, 10){
            private int xPos;
            private int yPos;
            private int width;
            private int height;
            {
                this.xPos = 0;
                this.yPos = 0;
                this.width = 0;
                this.height = 0;
            }

            public void func_146192_a(int x, int y, int mouseBtn) {
                boolean flag;
                boolean bl = flag = x >= this.xPos && x < this.xPos + this.width && y >= this.yPos && y < this.yPos + this.height;
                if (flag && mouseBtn == 3) {
                    this.func_146180_a("");
                }
            }
        };
        this.searchbar.func_146185_a(false);
        this.searchbar.func_146195_b(true);
        this.searchbar.func_146203_f(15);
    }

    protected void func_146976_a(float alpha, int sizeX, int sizeY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.guiTexture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r - 18, 0, 0, this.field_146999_f, this.field_147000_g);
        this.searchbar.func_146194_f();
        new PacketFluidStorage(this.player).sendPacketToServer();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)this.guiName).replace("ME ", ""), 5, -12, 0);
        this.drawWidgets(mouseX, mouseY);
        if (this.currentFluid != null) {
            long currentFluidAmount = this.currentFluid.getStackSize();
            String amountToText = Long.toString(currentFluidAmount) + "mB";
            if (Extracells.shortenedBuckets) {
                if (currentFluidAmount > 1000000000L) {
                    amountToText = Long.toString(currentFluidAmount / 1000000000L) + "MegaB";
                } else if (currentFluidAmount > 1000000L) {
                    amountToText = Long.toString(currentFluidAmount / 1000000L) + "KiloB";
                } else if (currentFluidAmount > 9999L) {
                    amountToText = Long.toString(currentFluidAmount / 1000L) + "B";
                }
            }
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"extracells.tooltip.amount") + ": " + amountToText, 45, 73, 0);
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"extracells.tooltip.fluid") + ": " + this.currentFluid.getFluid().getLocalizedName(this.currentFluid.getFluidStack()), 45, 83, 0);
        }
    }

    public void drawWidgets(int mouseX, int mouseY) {
        int listSize = this.fluidWidgets.size();
        if (!this.containerFluidStorage.getFluidStackList().isEmpty()) {
            int widgetIndex;
            block0: for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 9; ++x) {
                    widgetIndex = y * 9 + x + this.currentScroll * 9;
                    if (0 > widgetIndex || widgetIndex >= listSize) break block0;
                    AbstractFluidWidget widget = this.fluidWidgets.get(widgetIndex);
                    widget.drawWidget(x * 18 + 7, y * 18 - 1);
                }
            }
            for (int x = 0; x < 9; ++x) {
                for (int y = 0; y < 4 && 0 <= (widgetIndex = y * 9 + x) && widgetIndex < listSize; ++y) {
                    this.fluidWidgets.get(widgetIndex).drawTooltip(x * 18 + 7, y * 18 - 1, mouseX, mouseY);
                }
            }
            int deltaWheel = Mouse.getDWheel();
            if (deltaWheel > 0) {
                ++this.currentScroll;
            } else if (deltaWheel < 0) {
                --this.currentScroll;
            }
            if (this.currentScroll < 0) {
                this.currentScroll = 0;
            }
            if (listSize / 9 < 4 && this.currentScroll < listSize / 9 + 4) {
                this.currentScroll = 0;
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseBtn) {
        super.func_73864_a(mouseX, mouseY, mouseBtn);
        this.searchbar.func_146192_a(mouseX, mouseY, mouseBtn);
        int listSize = this.fluidWidgets.size();
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 4; ++y) {
                int index = y * 9 + x;
                if (0 > index || index >= listSize) continue;
                AbstractFluidWidget widget = this.fluidWidgets.get(index);
                widget.mouseClicked(x * 18 + 7, y * 18 - 1, mouseX, mouseY);
            }
        }
    }

    protected void func_73869_a(char key, int keyID) {
        if (keyID == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.searchbar.func_146201_a(key, keyID);
        this.updateFluids();
    }

    @Override
    public int guiLeft() {
        return this.field_147003_i;
    }

    @Override
    public int guiTop() {
        return this.field_147009_r;
    }

    @Override
    public IFluidSelectorContainer getContainer() {
        return this.containerFluidStorage;
    }

    @Override
    public IAEFluidStack getCurrentFluid() {
        return this.containerFluidStorage.getSelectedFluidStack();
    }
}

