/*
 * Decompiled with CFR 0.152.
 */
package extracells.item;

import extracells.registries.ItemEnum;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemFluidPattern
extends Item {
    IIcon icon;

    public ItemFluidPattern() {
        this.func_77625_d(1);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("extracells:fluid.pattern");
    }

    public String func_77653_i(ItemStack itemStack) {
        Fluid fluid = ItemFluidPattern.getFluid(itemStack);
        if (fluid == null) {
            return StatCollector.func_74838_a((String)this.func_77667_c(itemStack));
        }
        return StatCollector.func_74838_a((String)this.func_77667_c(itemStack)) + ": " + fluid.getLocalizedName(new FluidStack(fluid, 1));
    }

    public String func_77667_c(ItemStack itemStack) {
        return "extracells.item.fluid.pattern";
    }

    public int func_94901_k() {
        return 1;
    }

    public static Fluid getFluid(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return FluidRegistry.getFluid((String)itemStack.func_77978_p().func_74779_i("fluidID"));
    }

    public static ItemStack getPatternForFluid(Fluid fluid) {
        ItemStack itemStack = new ItemStack(ItemEnum.FLUIDPATTERN.getItem(), 1);
        itemStack.func_77982_d(new NBTTagCompound());
        if (fluid != null) {
            itemStack.func_77978_p().func_74778_a("fluidID", fluid.getName());
        }
        return itemStack;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List itemList) {
        for (String fluidID : FluidRegistry.getRegisteredFluidIDs().keySet()) {
            ItemStack itemStack = new ItemStack((Item)this, 1);
            itemStack.func_77982_d(new NBTTagCompound());
            itemStack.func_77978_p().func_74778_a("fluidID", fluidID);
            itemList.add(itemStack);
        }
    }

    public boolean func_77623_v() {
        return true;
    }

    public IIcon getIcon(ItemStack itemStack, int pass) {
        switch (pass) {
            case 0: {
                Fluid fluid = ItemFluidPattern.getFluid(itemStack);
                if (fluid == null) {
                    return null;
                }
                return fluid.getIcon();
            }
        }
        return this.icon;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (entityPlayer.func_70093_af()) {
            return ItemEnum.FLUIDPATTERN.getSizedStack(itemStack.field_77994_a);
        }
        return itemStack;
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.uncommon;
    }
}

