/*
 * Decompiled with CFR 0.152.
 */
package extracells.network;

import appeng.api.parts.IPartHost;
import com.google.common.base.Charsets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.network.ChannelHandler;
import extracells.part.PartECBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public abstract class AbstractPacket
implements IMessage {
    protected EntityPlayer player;
    protected byte mode;

    public AbstractPacket(EntityPlayer _player) {
        this.player = _player;
    }

    public AbstractPacket() {
        this.player = null;
    }

    public void toBytes(ByteBuf out) {
        out.writeByte((int)this.mode);
        AbstractPacket.writePlayer(this.player, out);
        this.writeData(out);
    }

    public abstract void writeData(ByteBuf var1);

    public void fromBytes(ByteBuf in) {
        this.mode = in.readByte();
        this.player = AbstractPacket.readPlayer(in);
        this.readData(in);
    }

    public abstract void readData(ByteBuf var1);

    public abstract void execute();

    public static String readString(ByteBuf in) {
        byte[] stringBytes = new byte[in.readInt()];
        in.readBytes(stringBytes);
        return new String(stringBytes, Charsets.UTF_8);
    }

    public static void writeString(String string, ByteBuf out) {
        byte[] stringBytes = string.getBytes(Charsets.UTF_8);
        out.writeInt(stringBytes.length);
        out.writeBytes(stringBytes);
    }

    public static World readWorld(ByteBuf in) {
        WorldServer world = DimensionManager.getWorld((int)in.readInt());
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return world != null ? world : AbstractPacket.getClientWorld();
        }
        return world;
    }

    @SideOnly(value=Side.CLIENT)
    public static World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static void writeWorld(World world, ByteBuf out) {
        out.writeInt(world.field_73011_w.field_76574_g);
    }

    public static EntityPlayer readPlayer(ByteBuf in) {
        if (!in.readBoolean()) {
            return null;
        }
        World playerWorld = AbstractPacket.readWorld(in);
        return playerWorld.func_72924_a(AbstractPacket.readString(in));
    }

    public static void writePlayer(EntityPlayer player, ByteBuf out) {
        if (player == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        AbstractPacket.writeWorld(player.field_70170_p, out);
        AbstractPacket.writeString(player.func_70005_c_(), out);
    }

    public static TileEntity readTileEntity(ByteBuf in) {
        return AbstractPacket.readWorld(in).func_147438_o(in.readInt(), in.readInt(), in.readInt());
    }

    public static void writeTileEntity(TileEntity tileEntity, ByteBuf out) {
        AbstractPacket.writeWorld(tileEntity.func_145831_w(), out);
        out.writeInt(tileEntity.field_145851_c);
        out.writeInt(tileEntity.field_145848_d);
        out.writeInt(tileEntity.field_145849_e);
    }

    public static PartECBase readPart(ByteBuf in) {
        return (PartECBase)((IPartHost)AbstractPacket.readTileEntity(in)).getPart(ForgeDirection.getOrientation((int)in.readByte()));
    }

    public static void writePart(PartECBase part, ByteBuf out) {
        AbstractPacket.writeTileEntity(part.getHost().getTile(), out);
        out.writeByte(part.getSide().ordinal());
    }

    public static Fluid readFluid(ByteBuf in) {
        return FluidRegistry.getFluid((String)AbstractPacket.readString(in));
    }

    public static void writeFluid(Fluid fluid, ByteBuf out) {
        if (fluid == null) {
            AbstractPacket.writeString("", out);
            return;
        }
        AbstractPacket.writeString(fluid.getName(), out);
    }

    public void sendPacketToServer() {
        ChannelHandler.sendPacketToServer(this);
    }

    public void sendPacketToPlayer(EntityPlayer player) {
        ChannelHandler.sendPacketToPlayer(this, player);
    }

    public void sendPacketToAllPlayers() {
        ChannelHandler.sendPacketToAllPlayers(this);
    }

    public void sendPacketToPlayersAround(NetworkRegistry.TargetPoint point) {
        ChannelHandler.sendPacketToPlayersAround(this, point);
    }
}

