/*
 * Decompiled with CFR 0.152.
 */
package extracells.item;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import extracells.api.ECApi;
import extracells.api.IHandlerFluidStorage;
import extracells.api.IPortableFluidStorageCell;
import extracells.util.inventory.ECFluidFilterInventory;
import extracells.util.inventory.ECPrivateInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

@Optional.Interface(iface="cofh.api.energy.IEnergyContainerItem", modid="CoFHAPI|energy")
public class ItemStoragePortableCell
extends Item
implements IPortableFluidStorageCell,
IAEItemPowerStorage,
IEnergyContainerItem {
    IIcon icon;
    private static final int MAX_POWER = 20000;

    public ItemStoragePortableCell() {
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public IIcon func_77617_a(int dmg) {
        return this.icon;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("extracells:storage.fluid.portable");
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List itemList) {
        itemList.add(new ItemStack(item));
        ItemStack itemStack = new ItemStack(item);
        this.injectAEPower(itemStack, 20000.0);
        itemList.add(itemStack);
    }

    public String func_77667_c(ItemStack itemStack) {
        return "extracells.item.storage.fluid.portable";
    }

    @Override
    public int getMaxTypes(ItemStack unused) {
        return 3;
    }

    @Override
    public int getMaxBytes(ItemStack is) {
        return 512;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        IMEInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory(itemStack, null, StorageChannel.FLUIDS);
        if (!(handler instanceof IHandlerFluidStorage)) {
            return;
        }
        IHandlerFluidStorage cellHandler = (IHandlerFluidStorage)handler;
        boolean partitioned = cellHandler.isFormatted();
        long usedBytes = cellHandler.usedBytes();
        double aeCurrentPower = this.getAECurrentPower(itemStack);
        list.add(String.format(StatCollector.func_74838_a((String)"extracells.tooltip.storage.fluid.bytes"), usedBytes / 250L, cellHandler.totalBytes() / 250));
        list.add(String.format(StatCollector.func_74838_a((String)"extracells.tooltip.storage.fluid.types"), cellHandler.usedTypes(), cellHandler.totalTypes()));
        if (usedBytes != 0L) {
            list.add(String.format(StatCollector.func_74838_a((String)"extracells.tooltip.storage.fluid.content"), usedBytes));
        }
        if (partitioned) {
            list.add(StatCollector.func_74838_a((String)"gui.appliedenergistics2.Partitioned") + " - " + StatCollector.func_74838_a((String)"gui.appliedenergistics2.Precise"));
        }
        list.add(StatCollector.func_74838_a((String)"gui.appliedenergistics2.StoredEnergy") + ": " + aeCurrentPower + " AE - " + Math.floor(aeCurrentPower / 20000.0 * 10000.0) / 100.0 + "%");
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return 1.0 - this.getAECurrentPower(itemStack) / 20000.0;
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        return ECApi.instance().openPortableCellGui(player, itemStack, world);
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.rare;
    }

    public boolean isEditable(ItemStack is) {
        if (is == null) {
            return false;
        }
        return is.func_77973_b() == this;
    }

    public IInventory getUpgradesInventory(ItemStack is) {
        return new ECPrivateInventory("configInventory", 0, 64);
    }

    public IInventory getConfigInventory(ItemStack is) {
        return new ECFluidFilterInventory("configFluidCell", 63, is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        if (is == null) {
            return null;
        }
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        if (is.func_77978_p().func_74764_b("fuzzyMode")) {
            return FuzzyMode.valueOf((String)is.func_77978_p().func_74779_i("fuzzyMode"));
        }
        is.func_77978_p().func_74778_a("fuzzyMode", FuzzyMode.IGNORE_ALL.name());
        return FuzzyMode.IGNORE_ALL;
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        if (is == null) {
            return;
        }
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = is.func_77978_p();
        tag.func_74778_a("fuzzyMode", fzMode.name());
    }

    @Override
    public ArrayList<Fluid> getFilter(ItemStack stack) {
        ECFluidFilterInventory inventory = new ECFluidFilterInventory("", 63, stack);
        ItemStack[] stacks = inventory.slots;
        ArrayList<Fluid> filter = new ArrayList<Fluid>();
        if (stacks.length == 0) {
            return null;
        }
        for (ItemStack s : stacks) {
            Fluid f;
            if (s == null || (f = FluidRegistry.getFluid((int)s.func_77960_j())) == null) continue;
            filter.add(f);
        }
        return filter;
    }

    @Override
    public boolean usePower(EntityPlayer player, double amount, ItemStack is) {
        this.extractAEPower(is, amount);
        return true;
    }

    @Override
    public boolean hasPower(EntityPlayer player, double amount, ItemStack is) {
        return this.getAECurrentPower(is) >= amount;
    }

    public double injectAEPower(ItemStack itemStack, double amt) {
        NBTTagCompound tagCompound = this.ensureTagCompound(itemStack);
        double currentPower = tagCompound.func_74769_h("power");
        double toInject = Math.min(amt, 20000.0 - currentPower);
        tagCompound.func_74780_a("power", currentPower + toInject);
        return toInject;
    }

    public double extractAEPower(ItemStack itemStack, double amt) {
        NBTTagCompound tagCompound = this.ensureTagCompound(itemStack);
        double currentPower = tagCompound.func_74769_h("power");
        double toExtract = Math.min(amt, currentPower);
        tagCompound.func_74780_a("power", currentPower - toExtract);
        return toExtract;
    }

    public double getAEMaxPower(ItemStack itemStack) {
        return 20000.0;
    }

    public double getAECurrentPower(ItemStack itemStack) {
        NBTTagCompound tagCompound = this.ensureTagCompound(itemStack);
        return tagCompound.func_74769_h("power");
    }

    public AccessRestriction getPowerFlow(ItemStack itemStack) {
        return AccessRestriction.READ_WRITE;
    }

    private NBTTagCompound ensureTagCompound(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p();
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container == null) {
            return 0;
        }
        if (simulate) {
            return this.getEnergyStored(container) >= maxExtract ? maxExtract : this.getEnergyStored(container);
        }
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.extractAEPower(container, PowerUnits.RF.convertTo(PowerUnits.AE, (double)maxExtract)));
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getEnergyStored(ItemStack arg0) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower(arg0));
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getMaxEnergyStored(ItemStack arg0) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower(arg0));
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container == null) {
            return 0;
        }
        if (simulate) {
            double current = PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower(container));
            double max = PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower(container));
            if (max - current >= (double)maxReceive) {
                return maxReceive;
            }
            return (int)(max - current);
        }
        int notStored = (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.injectAEPower(container, PowerUnits.RF.convertTo(PowerUnits.AE, (double)maxReceive)));
        return maxReceive - notStored;
    }
}

