/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.api_compat;

import ic2classic.api_compat.DirectItemAccessClassAdapter;
import ic2classic.api_compat.EnergyInterfaceClassAdapter;
import ic2classic.api_compat.MiscChangesClassAdapter;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.tree.ClassNode;

public class Transformer
implements IClassTransformer {
    static Remapper remapper = new Remapper(){

        public String map(String type) {
            if (type.equals("ic2/api/item/IC2Items")) {
                type = "ic2classic/api_compat/CompatItems";
            } else if (!(type.startsWith("ic2/core/Adv") || type.equals("ic2/core/WorldData") || type.equals("ic2/core/WindSim") || type.equals("ic2/core/util/SideGateway"))) {
                if (type.startsWith("ic2/core/audio") || type.equals("ic2/core/CreativeTabIC2") || type.equals("ic2/core/IC2") || type.equals("ic2/core/item/tool/ItemToolCutter") || type.equals("ic2/core/Platform") || type.equals("ic2/core/network/NetworkManager") || type.equals("ic2/core/util/StackUtil")) {
                    type = "ic2classic/" + type.substring(4);
                } else if (type.equals("ic2/api/network/NetworkHelper")) {
                    type = "ic2classic/api_compat/network/NetworkHelper";
                } else if (type.startsWith("ic2/") && !type.startsWith("ic2/api/")) {
                    System.err.println("IC2 Classic API Compatibility: unknown IC2 core class " + type);
                    type = "ic2classic/" + type.substring(4);
                }
            }
            return type;
        }
    };
    private static byte[] PRE_CHECK_MARKER = new byte[]{105, 99, 50, 47};
    private static byte[] PRE_CHECK_MARKER2 = new byte[]{105, 99, 50, 99, 108, 97, 115, 115, 105, 99, 47};

    public byte[] transform(String arg0, String arg1, byte[] arg2) {
        if (arg2 == null) {
            return null;
        }
        if (arg0.startsWith("ic2classic.api_compat.")) {
            return arg2;
        }
        if (!this.byteArrayContains(arg2, PRE_CHECK_MARKER) && !this.byteArrayContains(arg2, PRE_CHECK_MARKER2)) {
            return arg2;
        }
        ClassNode cn = new ClassNode();
        ClassWriter cw = new ClassWriter(0);
        new ClassReader(arg2).accept((ClassVisitor)new MiscChangesClassAdapter(new DirectItemAccessClassAdapter(new EnergyInterfaceClassAdapter((ClassVisitor)new RemappingClassAdapter((ClassVisitor)cw, remapper)))), 8);
        return cw.toByteArray();
    }

    private boolean byteArrayContains(byte[] haystack, byte[] needle) {
        int k = 0;
        while (k <= haystack.length - needle.length) {
            int j = 0;
            while (j < needle.length) {
                if (needle[j] != haystack[k + j]) break;
                ++j;
            }
            if (j == needle.length) {
                return true;
            }
            ++k;
        }
        return false;
    }
}

