/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.api_compat;

import ic2.api.recipe.ICannerBottleRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class CannerBottleRecipeManager
implements ICannerBottleRecipeManager {
    final List<Entry> entries = new ArrayList<Entry>();

    @Override
    public void addRecipe(IRecipeInput container, IRecipeInput fill, ItemStack output) {
        if (container == null || fill == null || output == null) {
            throw new NullPointerException();
        }
        this.entries.add(new Entry(container, fill, new RecipeOutput(null, output)));
    }

    @Override
    public RecipeOutput getOutputFor(ItemStack container, ItemStack fill, boolean adjustInput, boolean acceptTest) {
        if (!(acceptTest || container != null && fill != null)) {
            return null;
        }
        for (Entry entry : this.entries) {
            if (container != null && !entry.container.matches(container) || fill != null && !entry.fill.matches(fill)) continue;
            if (adjustInput) {
                if (container != null) {
                    container.field_77994_a -= entry.container.getAmount();
                }
                if (fill != null) {
                    fill.field_77994_a -= entry.fill.getAmount();
                }
            }
            return entry.output;
        }
        return null;
    }

    @Override
    public Map<ICannerBottleRecipeManager.Input, RecipeOutput> getRecipes() {
        HashMap<ICannerBottleRecipeManager.Input, RecipeOutput> result = new HashMap<ICannerBottleRecipeManager.Input, RecipeOutput>();
        for (Entry e : this.entries) {
            result.put(new ICannerBottleRecipeManager.Input(e.container, e.fill), e.output);
        }
        return result;
    }

    static class Entry {
        IRecipeInput container;
        IRecipeInput fill;
        RecipeOutput output;

        Entry(IRecipeInput c, IRecipeInput f, RecipeOutput o) {
            this.container = c;
            this.fill = f;
            this.output = o;
        }
    }
}

