/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkItemEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.WorldData;
import ic2.core.item.IHandHeldInventory;
import ic2.core.network.DataEncoder;
import ic2.core.network.IPlayerItemDataListener;
import ic2.core.network.IRpcProvider;
import ic2.core.network.RpcHandler;
import ic2.core.util.ReflectionUtil;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class NetworkManager {
    private static FMLEventChannel channel;
    public static final int updatePeriod = 1;
    private static final int maxPacketDataLength = 32766;
    public static final String channelName = "ic2";

    public NetworkManager() {
        if (channel == null) {
            channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channelName);
        }
        channel.register((Object)this);
    }

    public void onTickEnd(World world) {
        WorldData worldData = WorldData.get(world);
        if (--worldData.ticksLeftToNetworkUpdate == 0) {
            this.sendUpdatePacket(world);
            worldData.ticksLeftToNetworkUpdate = 1;
        }
    }

    public void sendPlayerItemData(EntityPlayer player, int slot, Object ... data) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(buffer);
        try {
            os.writeByte(10);
            os.writeByte(slot);
            DataEncoder.encode(os, player.field_71071_by.field_70462_a[slot].func_77973_b(), false);
            os.writeShort(data.length);
            for (Object o : data) {
                DataEncoder.encode(os, o);
            }
            os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] packetData = buffer.toByteArray();
        if (IC2.platform.isSimulating()) {
            this.sendPacket(packetData, (EntityPlayerMP)player);
        } else {
            this.sendPacket(packetData);
        }
    }

    public void updateTileEntityField(TileEntity te, String field) {
        if (IC2.platform.isSimulating()) {
            WorldData worldData = WorldData.get(te.func_145831_w());
            worldData.networkedFieldsToUpdate.add(new TileEntityField(te, field));
        } else {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            try {
                os.writeByte(13);
                DataEncoder.encode(os, te, false);
                NetworkManager.retrieveFieldData(te, field, os);
                os.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            byte[] packetData = buffer.toByteArray();
            this.sendPacket(packetData);
        }
    }

    public void updateTileEntityFieldTo(TileEntity te, String field, EntityPlayerMP player) {
        assert (IC2.platform.isSimulating());
        WorldData worldData = WorldData.get(te.func_145831_w());
        worldData.networkedFieldsToUpdate.add(new TileEntityField(te, field, player));
    }

    public void initiateTileEntityEvent(TileEntity te, int event, boolean limitRange) {
        if (te.func_145831_w().field_73010_i.isEmpty()) {
            return;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(buffer);
        try {
            os.writeByte(1);
            DataEncoder.encode(os, te, false);
            os.writeInt(event);
            os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] packetData = buffer.toByteArray();
        int maxDistance = limitRange ? 400 : MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16;
        for (Object obj : te.func_145831_w().field_73010_i) {
            if (!(obj instanceof EntityPlayerMP)) continue;
            EntityPlayerMP entityPlayer = (EntityPlayerMP)obj;
            int distanceX = te.field_145851_c - (int)entityPlayer.field_70165_t;
            int distanceZ = te.field_145849_e - (int)entityPlayer.field_70161_v;
            int distance = limitRange ? distanceX * distanceX + distanceZ * distanceZ : Math.max(Math.abs(distanceX), Math.abs(distanceZ));
            if (distance > maxDistance) continue;
            this.sendPacket(packetData, entityPlayer);
        }
    }

    public void initiateItemEvent(EntityPlayer player, ItemStack itemStack, int event, boolean limitRange) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(buffer);
        try {
            os.writeByte(2);
            os.writeLong(player.func_146103_bH().getId().getMostSignificantBits());
            os.writeLong(player.func_146103_bH().getId().getLeastSignificantBits());
            DataEncoder.encode(os, itemStack, false);
            os.writeInt(event);
            os.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] packetData = buffer.toByteArray();
        int maxDistance = limitRange ? 400 : MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16;
        for (Object obj : player.field_70170_p.field_73010_i) {
            if (!(obj instanceof EntityPlayerMP)) continue;
            EntityPlayerMP entityPlayer = (EntityPlayerMP)obj;
            int distanceX = (int)player.field_70165_t - (int)entityPlayer.field_70165_t;
            int distanceZ = (int)player.field_70161_v - (int)entityPlayer.field_70161_v;
            int distance = limitRange ? distanceX * distanceX + distanceZ * distanceZ : Math.max(Math.abs(distanceX), Math.abs(distanceZ));
            if (distance > maxDistance) continue;
            this.sendPacket(packetData, entityPlayer);
        }
    }

    @Deprecated
    public void requestInitialData(INetworkDataProvider dataProvider) {
    }

    public void initiateClientItemEvent(ItemStack itemStack, int event) {
    }

    public void initiateClientTileEntityEvent(TileEntity te, int event) {
    }

    public void initiateRpc(int id, Class<? extends IRpcProvider<?>> provider, Object[] args) {
    }

    public void initiateGuiDisplay(EntityPlayerMP entityPlayer, IHasGui inventory, int windowId) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(4);
            MinecraftServer server = MinecraftServer.func_71276_C();
            boolean isAdmin = server.func_71203_ab().func_152596_g(entityPlayer.func_146103_bH());
            os.writeByte(isAdmin ? 1 : 0);
            if (inventory instanceof TileEntity) {
                TileEntity te = (TileEntity)inventory;
                os.writeByte(0);
                DataEncoder.encode(os, te, false);
            } else if (entityPlayer.field_71071_by.func_70448_g() != null && entityPlayer.field_71071_by.func_70448_g().func_77973_b() instanceof IHandHeldInventory) {
                os.writeByte(1);
                os.writeInt(entityPlayer.field_71071_by.field_70461_c);
            } else {
                IC2.platform.displayError("An unknown GUI type was attempted to be displayed.\nThis could happen due to corrupted data from a player or a bug.\n\n(Technical information: " + inventory + ")", new Object[0]);
            }
            os.writeInt(windowId);
            os.close();
            this.sendPacket(buffer.toByteArray(), entityPlayer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendInitialData(TileEntity te, EntityPlayerMP player) {
        if (te instanceof INetworkDataProvider) {
            WorldData worldData = WorldData.get(te.func_145831_w());
            for (String field : ((INetworkDataProvider)te).getNetworkedFields()) {
                worldData.networkedFieldsToUpdate.add(new TileEntityField(te, field, player));
            }
        }
    }

    public void sendChat(EntityPlayerMP player, String message) {
        try {
            this.sendLargePacket(player, 1, message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void sendConsole(EntityPlayerMP player, String message) {
        try {
            this.sendLargePacket(player, 2, message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void sendContainerFields(ContainerBase<?> container, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.sendContainerField(container, fieldName);
        }
    }

    public void sendContainerField(ContainerBase<?> container, String fieldName) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(buffer);
        try {
            os.writeByte(11);
            DataEncoder.writeVarInt(os, container.field_75152_c);
            NetworkManager.retrieveFieldData(container, fieldName, os);
            os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] packetData = buffer.toByteArray();
        if (IC2.platform.isSimulating()) {
            for (ICrafting crafter : container.getCrafters()) {
                if (!(crafter instanceof EntityPlayerMP)) continue;
                this.sendPacket(packetData, (EntityPlayerMP)crafter);
            }
        } else {
            this.sendPacket(packetData);
        }
    }

    public void sendContainerEvent(ContainerBase<?> container, String event) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(buffer);
        try {
            os.writeByte(12);
            DataEncoder.writeVarInt(os, container.field_75152_c);
            os.writeUTF(event);
            os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] packetData = buffer.toByteArray();
        if (IC2.platform.isSimulating()) {
            for (ICrafting crafter : container.getCrafters()) {
                if (!(crafter instanceof EntityPlayerMP)) continue;
                this.sendPacket(packetData, (EntityPlayerMP)crafter);
            }
        } else {
            this.sendPacket(packetData);
        }
    }

    private void sendUpdatePacket(World world) {
        WorldData worldData = WorldData.get(world);
        if (worldData.networkedFieldsToUpdate.isEmpty()) {
            return;
        }
        HashMap data = new HashMap();
        for (TileEntityField tef : worldData.networkedFieldsToUpdate) {
            List<EntityPlayerMP> receivers;
            if (tef.te.func_145837_r()) continue;
            if (tef.target == null) {
                receivers = NetworkManager.getPlayersInRange(world, tef.te);
            } else {
                if (tef.te.func_145831_w() != tef.target.field_70170_p) continue;
                receivers = Arrays.asList(tef.target);
            }
            for (EntityPlayerMP player : receivers) {
                ByteArrayOutputStream teData;
                HashMap<TileEntity, ByteArrayOutputStream> playerData = (HashMap<TileEntity, ByteArrayOutputStream>)data.get(player);
                if (playerData == null) {
                    playerData = new HashMap<TileEntity, ByteArrayOutputStream>();
                    data.put(player, playerData);
                }
                if ((teData = (ByteArrayOutputStream)playerData.get(tef.te)) == null) {
                    teData = new ByteArrayOutputStream(512);
                    playerData.put(tef.te, teData);
                }
                try {
                    NetworkManager.retrieveFieldData(tef.te, tef.field, teData);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        worldData.networkedFieldsToUpdate.clear();
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(16384);
            for (Map.Entry entry : data.entrySet()) {
                EntityPlayerMP player = (EntityPlayerMP)entry.getKey();
                Map playerData = (Map)entry.getValue();
                DataOutputStream os = new DataOutputStream(buffer);
                os.writeInt(player.field_70170_p.field_73011_w.field_76574_g);
                for (Map.Entry entry2 : playerData.entrySet()) {
                    TileEntity te = (TileEntity)entry2.getKey();
                    ByteArrayOutputStream fieldData = (ByteArrayOutputStream)entry2.getValue();
                    os.writeInt(te.field_145851_c);
                    os.writeInt(te.field_145848_d);
                    os.writeInt(te.field_145849_e);
                    os.writeInt(fieldData.size());
                    fieldData.writeTo(os);
                }
                os.close();
                this.sendLargePacket(player, 0, buffer.toByteArray());
                buffer.reset();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<EntityPlayerMP> getPlayersInRange(World world, TileEntity te) {
        ArrayList<EntityPlayerMP> ret = new ArrayList<EntityPlayerMP>();
        for (Object obj : world.field_73010_i) {
            if (!(obj instanceof EntityPlayerMP)) continue;
            EntityPlayerMP player = (EntityPlayerMP)obj;
            int distance = Math.min(Math.abs(te.field_145851_c - (int)player.field_70165_t), Math.abs(te.field_145849_e - (int)player.field_70161_v));
            if (distance > MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16) continue;
            ret.add(player);
        }
        return ret;
    }

    private void sendLargePacket(EntityPlayerMP player, int id, byte[] data) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(16384);
        try {
            DeflaterOutputStream deflate = new DeflaterOutputStream(buffer);
            deflate.write(data);
            deflate.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        data = buffer.toByteArray();
        int maxSize = 32764;
        for (int offset = 0; offset < data.length; offset += maxSize) {
            buffer.reset();
            buffer.write(0);
            int state = 0;
            if (offset == 0) {
                state |= 1;
            }
            if (offset + maxSize > data.length) {
                state |= 2;
            }
            buffer.write(state |= id << 2);
            buffer.write(data, offset, Math.min(maxSize, data.length - offset));
            byte[] packetData = buffer.toByteArray();
            this.sendPacket(packetData, player);
        }
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        if (this.getClass() == NetworkManager.class) {
            this.onPacketData((InputStream)new ByteBufInputStream(event.packet.payload()), (EntityPlayer)((NetHandlerPlayServer)event.handler).field_147369_b);
        }
    }

    protected void onPacketData(InputStream isRaw, EntityPlayer player) {
        try {
            if (isRaw.available() == 0) {
                return;
            }
            int id = isRaw.read();
            DataInputStream is = new DataInputStream(isRaw);
            switch (id) {
                case 1: {
                    ItemStack stack = DataEncoder.decode(is, ItemStack.class);
                    int event = is.readInt();
                    if (!(stack.func_77973_b() instanceof INetworkItemEventListener)) break;
                    ((INetworkItemEventListener)stack.func_77973_b()).onNetworkEvent(stack, player, event);
                    break;
                }
                case 2: {
                    int keyState = is.readInt();
                    IC2.keyboard.processKeyUpdate(player, keyState);
                    break;
                }
                case 3: {
                    TileEntity te = DataEncoder.decode(is, TileEntity.class);
                    int event = is.readInt();
                    if (!(te instanceof INetworkClientTileEntityEventListener)) break;
                    ((INetworkClientTileEntityEventListener)te).onNetworkEvent(player, event);
                    break;
                }
                case 4: {
                    RpcHandler.processRpcRequest(is, (EntityPlayerMP)player);
                    break;
                }
                case 10: {
                    byte slot = is.readByte();
                    Item item = DataEncoder.decode(is, Item.class);
                    int dataCount = is.readShort();
                    Object[] subData = new Object[dataCount];
                    for (int i = 0; i < dataCount; ++i) {
                        subData[i] = DataEncoder.decode(is);
                    }
                    if (slot < 0 || slot > 9) break;
                    ItemStack itemStack = player.field_71071_by.field_70462_a[slot];
                    if (itemStack != null && itemStack.func_77973_b() == item && item instanceof IPlayerItemDataListener) {
                        ((IPlayerItemDataListener)item).onPlayerItemNetworkData(player, slot, subData);
                    }
                    break;
                }
                case 11: {
                    int windowId = DataEncoder.readVarInt(is);
                    String fieldName = is.readUTF();
                    Object value = DataEncoder.decode(is);
                    if (!(player.field_71070_bA instanceof ContainerBase) || player.field_71070_bA.field_75152_c != windowId) break;
                    ReflectionUtil.setValueRecursive(player.field_71070_bA, fieldName, value);
                    break;
                }
                case 12: {
                    int windowId = DataEncoder.readVarInt(is);
                    String event = is.readUTF();
                    if (!(player.field_71070_bA instanceof ContainerBase) || player.field_71070_bA.field_75152_c != windowId) break;
                    ((ContainerBase)player.field_71070_bA).onContainerEvent(event);
                    break;
                }
                case 13: {
                    TileEntity te = DataEncoder.decode(is, TileEntity.class);
                    String fieldName = is.readUTF();
                    Object value = DataEncoder.decode(is);
                    if (te == null) break;
                    ReflectionUtil.setValueRecursive(te, fieldName, value);
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initiateKeyUpdate(int keyState) {
    }

    public void sendLoginData() {
    }

    public void initiateExplosionEffect(World world, double x, double y, double z) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(5);
            os.writeInt(world.field_73011_w.field_76574_g);
            os.writeDouble(x);
            os.writeDouble(y);
            os.writeDouble(z);
            os.close();
            byte[] packetData = buffer.toByteArray();
            for (Object obj : world.field_73010_i) {
                EntityPlayerMP player;
                if (!(obj instanceof EntityPlayerMP) || !((player = (EntityPlayerMP)obj).func_70092_e(x, y, z) < 128.0)) continue;
                this.sendPacket(packetData, player);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void sendPacket(byte[] data) {
        if (IC2.platform.isSimulating()) {
            channel.sendToAll(NetworkManager.makePacket(data));
        } else {
            channel.sendToServer(NetworkManager.makePacket(data));
        }
    }

    protected void sendPacket(byte[] data, EntityPlayerMP player) {
        channel.sendTo(NetworkManager.makePacket(data), player);
    }

    private static void retrieveFieldData(Object object, String fieldName, OutputStream out) throws IOException {
        DataOutputStream os = new DataOutputStream(out);
        os.writeUTF(fieldName);
        try {
            DataEncoder.encode(os, ReflectionUtil.getValueRecursive(object, fieldName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        os.flush();
    }

    private static FMLProxyPacket makePacket(byte[] data) {
        return new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])data), channelName);
    }

    public static class TileEntityField {
        TileEntity te;
        String field;
        EntityPlayerMP target = null;

        TileEntityField(TileEntity te1, String field1) {
            this.te = te1;
            this.field = field1;
        }

        TileEntityField(TileEntity te1, String field1, EntityPlayerMP target1) {
            this.te = te1;
            this.field = field1;
            this.target = target1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TileEntityField) {
                TileEntityField tef = (TileEntityField)obj;
                return tef.te == this.te && tef.field.equals(this.field) && tef.target == this.target;
            }
            return false;
        }

        public int hashCode() {
            return this.te.hashCode() * 31 ^ this.field.hashCode();
        }
    }
}

