/*
 * Decompiled with CFR 0.152.
 */
package ic2.api;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public enum Direction {
    XN,
    XP,
    YN,
    YP,
    ZN,
    ZP;

    public static final Direction[] directions;

    public static Direction fromSideValue(int side) {
        return directions[(side + 2) % 6];
    }

    public static Direction fromForgeDirection(ForgeDirection dir) {
        if (dir == ForgeDirection.UNKNOWN) {
            return null;
        }
        return Direction.fromSideValue(dir.ordinal());
    }

    public TileEntity applyToTileEntity(TileEntity te) {
        return this.applyTo(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public TileEntity applyTo(World world, int x, int y, int z) {
        int[] coords = new int[]{x, y, z};
        int n = this.ordinal() / 2;
        coords[n] = coords[n] + this.getSign();
        if (world != null && world.func_72899_e(coords[0], coords[1], coords[2])) {
            try {
                return world.func_147438_o(coords[0], coords[1], coords[2]);
            }
            catch (Exception e) {
                throw new RuntimeException("error getting TileEntity at dim " + world.field_73011_w.field_76574_g + " " + coords[0] + "/" + coords[1] + "/" + coords[2]);
            }
        }
        return null;
    }

    public Direction getInverse() {
        return directions[this.ordinal() ^ 1];
    }

    public int toSideValue() {
        return (this.ordinal() + 4) % 6;
    }

    private int getSign() {
        return this.ordinal() % 2 * 2 - 1;
    }

    public ForgeDirection toForgeDirection() {
        return ForgeDirection.getOrientation((int)this.toSideValue());
    }

    static {
        directions = Direction.values();
    }
}

