/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IKineticSource;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.generator.container.ContainerKineticGenerator;
import ic2.core.block.generator.gui.GuiKineticGenerator;
import ic2.core.init.MainConfig;
import ic2.core.util.ConfigUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityKineticGenerator
extends TileEntityInventory
implements IEnergySource,
IHasGui {
    public int updateTicker;
    private double guiproduction = 0.0;
    private double production = 0.0;
    private int receivedkinetic = 0;
    public double EUstorage = 0.0;
    private final int maxEUStorage;
    private final double productionpeerkineticunit = 0.25 * (double)ConfigUtil.getFloat(MainConfig.get(), "balance/energy/generator/Kinetic");
    public boolean addedToEnergyNet = false;

    public TileEntityKineticGenerator() {
        this.maxEUStorage = 200000;
        this.updateTicker = IC2.random.nextInt(this.getTickRate());
    }

    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = false;
        boolean newActive = this.gainEnergy();
        if (this.updateTicker++ >= this.getTickRate()) {
            this.guiproduction = this.production;
            this.updateTicker = 0;
        }
        if (this.EUstorage > (double)this.maxEUStorage) {
            this.EUstorage = this.maxEUStorage;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
        if (this.getActive() != newActive) {
            this.setActive(newActive);
        }
    }

    protected boolean gainEnergy() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing());
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        if (te instanceof IKineticSource) {
            int kineticbandwith = ((IKineticSource)te).maxrequestkineticenergyTick(dir.getOpposite());
            double freeEUstorage = (double)this.maxEUStorage - this.EUstorage;
            if (freeEUstorage > 0.0 && freeEUstorage < this.productionpeerkineticunit * (double)kineticbandwith) {
                freeEUstorage = this.productionpeerkineticunit * (double)kineticbandwith;
            }
            if (freeEUstorage >= this.productionpeerkineticunit * (double)kineticbandwith) {
                this.receivedkinetic = ((IKineticSource)te).requestkineticenergy(dir.getOpposite(), kineticbandwith);
                if (this.receivedkinetic != 0) {
                    this.production = (double)this.receivedkinetic * this.productionpeerkineticunit;
                    this.EUstorage += this.production;
                    return true;
                }
            }
        }
        this.production = 0.0;
        this.receivedkinetic = 0;
        return false;
    }

    public ContainerBase<TileEntityKineticGenerator> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerKineticGenerator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiKineticGenerator(new ContainerKineticGenerator(entityPlayer, this));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.EUstorage = nbttagcompound.func_74769_h("EUstorage");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("EUstorage", this.EUstorage);
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        return Math.min(this.EUstorage, EnergyNet.instance.getPowerFromTier(this.getSourceTier()));
    }

    @Override
    public int getSourceTier() {
        return 3;
    }

    @Override
    public void drawEnergy(double amount) {
        this.EUstorage -= amount;
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int gaugeEUStorageScaled(int i) {
        return (int)(this.EUstorage * (double)i / (double)this.maxEUStorage);
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short side) {
        super.setFacing(side);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    @Override
    public float getWrenchDropRate() {
        return 0.9f;
    }

    @Override
    public String func_145825_b() {
        return "StirlingGenerator";
    }

    public double getproduction() {
        return this.guiproduction;
    }

    public int getTickRate() {
        return 20;
    }
}

