/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.invslot;

import ic2.api.info.Info;
import ic2.api.item.ElectricItem;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class InvSlotDischarge
extends InvSlot {
    public int tier;
    public boolean redstoneallowed = true;

    public InvSlotDischarge(TileEntityInventory base1, int oldStartIndex1, int tier1) {
        this(base1, oldStartIndex1, tier1, InvSlot.InvSide.ANY);
    }

    public InvSlotDischarge(TileEntityInventory base1, int oldStartIndex1, int tier1, InvSlot.InvSide preferredSide1) {
        super(base1, "discharge", oldStartIndex1, InvSlot.Access.IO, 1, preferredSide1);
        this.tier = tier1;
    }

    public InvSlotDischarge(TileEntityInventory base1, int oldStartIndex1, int tier1, boolean redstoneallowed, InvSlot.InvSide preferredSide1) {
        super(base1, "discharge", oldStartIndex1, InvSlot.Access.IO, 1, preferredSide1);
        this.tier = tier1;
        this.redstoneallowed = redstoneallowed;
    }

    @Override
    public boolean accepts(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() == Items.field_151137_ax && !this.redstoneallowed) {
            return false;
        }
        return Info.itemEnergy.getEnergyValue(stack) > 0.0 || ElectricItem.manager.discharge(stack, Double.POSITIVE_INFINITY, this.tier, true, true, true) > 0.0;
    }

    public double discharge(double amount, boolean ignoreLimit) {
        if (amount <= 0.0) {
            throw new IllegalArgumentException("Amount must be > 0.");
        }
        ItemStack stack = this.get(0);
        if (stack == null) {
            return 0.0;
        }
        double realAmount = ElectricItem.manager.discharge(stack, amount, this.tier, ignoreLimit, true, false);
        if (realAmount <= 0.0) {
            realAmount = Info.itemEnergy.getEnergyValue(stack);
            if (realAmount <= 0.0) {
                return 0.0;
            }
            --stack.field_77994_a;
            if (stack.field_77994_a <= 0) {
                this.put(0, null);
            }
        }
        return realAmount;
    }

    public void setTier(int tier1) {
        this.tier = tier1;
    }
}

