/*
 * Decompiled with CFR 0.152.
 */
package ic2.bcIntegration.core;

import buildcraft.api.gates.ITriggerParameter;
import ic2.bcIntegration.core.Trigger;
import ic2.bcIntegration.core.TriggerType;
import ic2.core.block.machine.tileentity.TileEntityBlastFurnace;
import ic2.core.block.machine.tileentity.TileEntityInduction;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerHeat
extends Trigger {
    public TriggerHeat(TriggerType type) {
        super(type);
    }

    @Override
    public String getDescription() {
        switch (this.type) {
            case FullHeat: {
                return "Fully Heated Up";
            }
            case NoFullHeat: {
                return "Not Fully Heated Up";
            }
        }
        return "";
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        if (tile instanceof TileEntityInduction) {
            TileEntityInduction tei = (TileEntityInduction)tile;
            return this.type == TriggerType.FullHeat && tei.heat >= TileEntityInduction.maxHeat || this.type == TriggerType.NoFullHeat && tei.heat < TileEntityInduction.maxHeat;
        }
        if (tile instanceof TileEntityBlastFurnace) {
            TileEntityBlastFurnace tei = (TileEntityBlastFurnace)tile;
            return this.type == TriggerType.FullHeat && tei.heat >= TileEntityBlastFurnace.maxHeat || this.type == TriggerType.NoFullHeat && tei.heat < TileEntityBlastFurnace.maxHeat;
        }
        return false;
    }
}

