/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IHeatSource;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.generator.container.ContainerStirlingGenerator;
import ic2.core.block.generator.gui.GuiStirlingGenerator;
import ic2.core.init.MainConfig;
import ic2.core.util.ConfigUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityStirlingGenerator
extends TileEntityInventory
implements IEnergySource,
IHasGui {
    public double production = 0.0;
    public int receivedheat = 0;
    public double EUstorage = 0.0;
    public final short maxEUStorage;
    public final double productionpeerheat = 0.5f * ConfigUtil.getFloat(MainConfig.get(), "balance/energy/generator/Stirling");
    public boolean addedToEnergyNet = false;

    public TileEntityStirlingGenerator() {
        this.maxEUStorage = (short)30000;
    }

    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = false;
        boolean newActive = this.gainEnergy();
        if (this.EUstorage > (double)this.maxEUStorage) {
            this.EUstorage = this.maxEUStorage;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
        if (this.getActive() != newActive) {
            this.setActive(newActive);
        }
    }

    protected boolean gainEnergy() {
        int heatbandwith;
        double freeEUstorage;
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing());
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        if (te instanceof IHeatSource && (freeEUstorage = (double)this.maxEUStorage - this.EUstorage) >= this.productionpeerheat * (double)(heatbandwith = ((IHeatSource)te).maxrequestHeatTick(dir.getOpposite()))) {
            this.receivedheat = ((IHeatSource)te).requestHeat(dir.getOpposite(), heatbandwith);
            if (this.receivedheat != 0) {
                this.production = (double)this.receivedheat * this.productionpeerheat;
                this.EUstorage += this.production;
                return true;
            }
        }
        this.production = 0.0;
        this.receivedheat = 0;
        return false;
    }

    public ContainerBase<TileEntityStirlingGenerator> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerStirlingGenerator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiStirlingGenerator(new ContainerStirlingGenerator(entityPlayer, this));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.EUstorage = nbttagcompound.func_74769_h("EUstorage");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("EUstorage", this.EUstorage);
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        return Math.min(this.EUstorage, EnergyNet.instance.getPowerFromTier(this.getSourceTier()));
    }

    @Override
    public int getSourceTier() {
        return 2;
    }

    @Override
    public void drawEnergy(double amount) {
        this.EUstorage -= amount;
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int gaugeEUStorageScaled(int i) {
        return (int)(this.EUstorage * (double)i / (double)this.maxEUStorage);
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short side) {
        super.setFacing(side);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    @Override
    public float getWrenchDropRate() {
        return 0.9f;
    }

    @Override
    public String func_145825_b() {
        return "StirlingGenerator";
    }
}

