/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.kineticgenerator.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IKineticSource;
import ic2.api.item.IKineticWindRotor;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotConsumableIKineticWindRotor;
import ic2.core.block.kineticgenerator.container.ContainerWaterKineticGenerator;
import ic2.core.block.kineticgenerator.gui.GuiWaterKineticGenerator;
import ic2.core.item.ItemGradualInt;
import java.util.List;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWaterKineticGenerator
extends TileEntityInventory
implements IKineticSource,
IHasGui {
    private int updateTicker = IC2.random.nextInt(this.getTickRate());
    public InvSlotConsumableIKineticWindRotor rotorSlot = new InvSlotConsumableIKineticWindRotor(this, "rotorslot", 0, 1);
    private int crossSection;
    private int obstructedCrossSection;
    public short type = 0;
    private int rotationSpeed;
    private int waterFlow;
    private static final float speedMultiplier = 1.0f;
    private static final float outputModifier = 0.2f;
    private double efficiencyRollOffExponent = 2.0;
    private boolean firsttick = true;
    private static final int nominalRotationPeriod = 500;
    private int distanceToNormalBiome;
    private boolean rightFacing;

    private int getTickRate() {
        return 20;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.firsttick) {
            this.updateSeaInfo();
            this.firsttick = false;
        }
        if (this.updateTicker++ % this.getTickRate() != 0) {
            return;
        }
        if (this.type == 0) {
            BiomeGenBase biome = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
            this.type = biome == BiomeGenBase.field_76771_b || biome == BiomeGenBase.field_150575_M ? (short)1 : (biome == BiomeGenBase.field_76781_i ? (short)2 : (short)-1);
        }
        if (this.type == -1) {
            return;
        }
        boolean needsInvUpdate = false;
        if (!this.rotorSlot.isEmpty()) {
            if (this.checkSpace(1, true) == 0) {
                if (!this.getActive()) {
                    this.setActive(true);
                    needsInvUpdate = true;
                }
            } else if (this.getActive()) {
                this.setActive(false);
                needsInvUpdate = true;
            }
        } else if (this.getActive()) {
            this.setActive(false);
            needsInvUpdate = true;
        }
        if (this.getActive()) {
            this.crossSection = this.getRotorDiameter() / 2 * 2 * 2 + 1;
            this.crossSection *= this.crossSection;
            this.obstructedCrossSection = this.checkSpace(this.getRotorDiameter() * 3, false);
            if (this.obstructedCrossSection > 0 && this.obstructedCrossSection <= (this.getRotorDiameter() + 1) / 2) {
                this.obstructedCrossSection = 0;
            } else if (this.obstructedCrossSection < 0) {
                this.obstructedCrossSection = this.crossSection;
            }
            int rotordamage = 0;
            if (this.type == 1) {
                int diff = (int)Math.abs(this.field_145850_b.func_72820_D() % 12000L - 6000L) - 3000;
                this.waterFlow = this.rotationSpeed = (int)((double)((float)(Math.abs(diff) * this.distanceToNormalBiome) / 100.0f) * (1.0 - Math.pow((double)this.obstructedCrossSection / (double)this.crossSection, this.efficiencyRollOffExponent)));
                if (diff < 0 ^ this.rightFacing) {
                    this.rotationSpeed *= -1;
                }
                IC2.network.get().updateTileEntityField(this, "rotationSpeed");
                this.waterFlow = (int)((float)this.waterFlow * this.getefficiency());
                rotordamage = 2;
            } else if (this.type == 2) {
                this.waterFlow = this.rotationSpeed = Math.min(this.distanceToNormalBiome, 20) * 50;
                if (this.getFacing() == ForgeDirection.EAST.ordinal() || this.getFacing() == ForgeDirection.NORTH.ordinal()) {
                    this.rotationSpeed *= -1;
                }
                IC2.network.get().updateTileEntityField(this, "rotationSpeed");
                this.waterFlow = (int)((float)this.waterFlow * (this.getefficiency() * (1.0f - 0.3f * this.field_145850_b.field_73012_v.nextFloat() - 0.1f * ((float)this.obstructedCrossSection / (float)this.crossSection))));
                rotordamage = 1;
            }
            if (this.rotorSlot.get() != null) {
                ItemGradualInt rotor = (ItemGradualInt)this.rotorSlot.get().func_77973_b();
                rotor.damageItemStack(this.rotorSlot.get(), rotordamage);
            }
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    @Override
    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.add("rotationSpeed");
        ret.add("rotorSlot");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    public int getRotorDiameter() {
        if (this.rotorSlot.get() != null && this.rotorSlot.get().func_77973_b() instanceof IKineticWindRotor) {
            return (((IKineticWindRotor)this.rotorSlot.get().func_77973_b()).getDiameter() + 1) / 2;
        }
        return 0;
    }

    public int checkSpace(int length, boolean onlyrotor) {
        int box = this.getRotorDiameter() / 2;
        int lentemp = 0;
        if (onlyrotor) {
            length = 1;
            lentemp = length + 1;
        }
        if (!onlyrotor) {
            box *= 2;
        }
        ForgeDirection fwdDir = ForgeDirection.VALID_DIRECTIONS[this.getFacing()];
        ForgeDirection rightDir = fwdDir.getRotation(ForgeDirection.DOWN);
        int ret = 0;
        for (int up = -box; up <= box; ++up) {
            int y = this.field_145848_d + up;
            for (int right = -box; right <= box; ++right) {
                boolean occupied = false;
                for (int fwd = lentemp - length; fwd <= length; ++fwd) {
                    int x = this.field_145851_c + fwd * fwdDir.offsetX + right * rightDir.offsetX;
                    int z = this.field_145849_e + fwd * fwdDir.offsetZ + right * rightDir.offsetZ;
                    Block block = this.field_145850_b.func_147439_a(x, y, z);
                    if (block == Blocks.field_150355_j) continue;
                    occupied = true;
                    if (up == 0 && right == 0 && fwd == 0 || !(this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityWaterKineticGenerator) || onlyrotor) continue;
                    return -1;
                }
                if (!occupied) continue;
                ++ret;
            }
        }
        return ret;
    }

    @Override
    public ContainerBase<?> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerWaterKineticGenerator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiWaterKineticGenerator((ContainerWaterKineticGenerator)this.getGuiContainer(entityPlayer));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public String func_145825_b() {
        return "Water Kinetic Generator";
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        if (side == 0 || side == 1) {
            return false;
        }
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short side) {
        super.setFacing(side);
        this.updateSeaInfo();
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void updateSeaInfo() {
        ForgeDirection facing = ForgeDirection.VALID_DIRECTIONS[this.getFacing()];
        for (int i = 1; i < 200; ++i) {
            BiomeGenBase biometmp = this.field_145850_b.func_72807_a(this.field_145851_c + facing.offsetX * i, this.field_145849_e + facing.offsetZ * i);
            if (!this.isValidBiome(biometmp)) {
                this.distanceToNormalBiome = i;
                this.rightFacing = true;
                return;
            }
            biometmp = this.field_145850_b.func_72807_a(this.field_145851_c - facing.offsetX * i, this.field_145849_e - facing.offsetZ * i);
            if (this.isValidBiome(biometmp)) continue;
            this.distanceToNormalBiome = i;
            this.rightFacing = false;
            return;
        }
        this.distanceToNormalBiome = 200;
        this.rightFacing = true;
    }

    public boolean isValidBiome(BiomeGenBase biome) {
        return biome == BiomeGenBase.field_150575_M || biome == BiomeGenBase.field_76771_b || biome == BiomeGenBase.field_76781_i;
    }

    public ResourceLocation getRotorRenderTexture() {
        if (this.rotorSlot.get() != null && this.rotorSlot.get().func_77973_b() instanceof IKineticWindRotor) {
            return ((IKineticWindRotor)this.rotorSlot.get().func_77973_b()).getRotorRenderTexture();
        }
        return new ResourceLocation(IC2.textureDomain, "textures/items/rotors/rotorWoodmodel.png");
    }

    public float getAngle() {
        if (this.rotationSpeed > 0) {
            long period = 500000000 / this.rotationSpeed;
            return (float)(System.nanoTime() % period) / (float)period * 360.0f;
        }
        return 0.0f;
    }

    @Override
    public int maxrequestkineticenergyTick(ForgeDirection directionFrom) {
        return this.getKuOutput();
    }

    @Override
    public int requestkineticenergy(ForgeDirection directionFrom, int requestkineticenergy) {
        if (directionFrom.getOpposite().ordinal() == this.getFacing()) {
            return Math.min(requestkineticenergy, this.getKuOutput());
        }
        return 0;
    }

    public int getKuOutput() {
        if (this.getActive()) {
            return (int)((float)this.waterFlow * 0.2f);
        }
        return 0;
    }

    public float getefficiency() {
        if (this.rotorSlot.get() != null && this.rotorSlot.get().func_77973_b() instanceof IKineticWindRotor) {
            return ((IKineticWindRotor)this.rotorSlot.get().func_77973_b()).getefficiency();
        }
        return 0.0f;
    }

    public String getRotorhealth() {
        if (!this.rotorSlot.isEmpty()) {
            return StatCollector.func_74837_a((String)"ic2.WaterKineticGenerator.gui.rotorhealth", (Object[])new Object[]{(int)(100.0f - (float)this.rotorSlot.get().func_77960_j() / (float)this.rotorSlot.get().func_77958_k() * 100.0f)});
        }
        return "";
    }
}

