/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.resources;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ILatheItem;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.init.InternalName;
import ic2.core.item.ItemIC2;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;

public class ItemLatheDefault
extends ItemIC2
implements ILatheItem {
    private static final String location = IC2.textureDomain + ":textures/items/turnables/";
    private static final int ironStateHandle = ItemLatheDefault.getNumericState(new int[]{4, 3, 2, 2, 2});
    private static final int ironStateDrill = ItemLatheDefault.getNumericState(new int[]{5, 4, 3, 2, 1});
    private static final String tooltipPrefix = "ic2." + (Object)((Object)InternalName.itemTurningBlanks) + ".tooltip.";

    public ItemLatheDefault(InternalName internalName) {
        super(internalName);
        this.func_77625_d(1);
        this.func_77627_a(true);
        Ic2Items.turningBlankWood = new ItemStack((Item)this, 1, 0);
        Ic2Items.turningBlankIron = new ItemStack((Item)this, 1, 1);
        OreDictionary.registerOre((String)"turningBlankIronHandle", (ItemStack)ItemLatheDefault.getStackForState(Ic2Items.turningBlankIron, ironStateHandle));
        OreDictionary.registerOre((String)"turningBlankIronDrill", (ItemStack)ItemLatheDefault.getStackForState(Ic2Items.turningBlankIron, ironStateDrill));
    }

    @Override
    public int getWidth(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return 3;
            }
            case 1: {
                return 5;
            }
        }
        return 1;
    }

    @Override
    public String func_77667_c(ItemStack itemStack) {
        String n = null;
        switch (itemStack.func_77960_j()) {
            case 0: {
                n = "WOOD";
                break;
            }
            case 1: {
                n = "IRON";
            }
        }
        if (n == null) {
            return null;
        }
        return "ic2." + (Object)((Object)InternalName.itemTurningBlanks) + n;
    }

    @Override
    public int[] getCurrentState(ItemStack stack) {
        if (stack == null) {
            return new int[0];
        }
        int[] ret = new int[5];
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("state")) {
            NBTTagCompound tag = (NBTTagCompound)stack.func_77978_p().func_74781_a("state");
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = tag.func_74764_b("l" + i) ? tag.func_74762_e("l" + i) : this.getWidth(stack);
            }
        } else {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.getWidth(stack);
            }
        }
        return ret;
    }

    @Override
    public void setState(ItemStack stack, int position, int value) {
        if (stack == null) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (!stack.func_77978_p().func_74764_b("state")) {
            stack.field_77990_d.func_74782_a("state", (NBTBase)new NBTTagCompound());
        }
        ((NBTTagCompound)stack.func_77978_p().func_74781_a("state")).func_74768_a("l" + position, Math.max(Math.min(value, this.getWidth(stack)), 1));
    }

    @Override
    public ItemStack getOutputItem(ItemStack stack, int position) {
        switch (stack.func_77960_j()) {
            case 0: {
                return new ItemStack(Items.field_151055_y);
            }
            case 1: {
                return Ic2Items.smallIronDust;
            }
        }
        return null;
    }

    @Override
    public ResourceLocation getTexture(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return new ResourceLocation(location + "WOOD.png");
            }
            case 1: {
                return new ResourceLocation(location + "IRON.png");
            }
        }
        return null;
    }

    @Override
    public float getOutputChance(ItemStack stack, int position) {
        switch (stack.func_77960_j()) {
            case 0: {
                return 0.1f;
            }
            case 1: {
                return 0.5f;
            }
        }
        return 0.0f;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        ItemStack stack;
        for (int meta = 0; meta < Short.MAX_VALUE && this.func_77667_c(stack = new ItemStack((Item)this, 1, meta)) != null; ++meta) {
            itemList.add(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean p_77624_4_) {
        int[] state = this.getCurrentState(stack);
        int numState = ItemLatheDefault.getNumericState(state);
        switch (stack.func_77960_j()) {
            case 2: {
                break;
            }
            case 1: {
                if (numState == ironStateHandle) {
                    list.add(tooltipPrefix + "handle");
                    break;
                }
                if (numState != ironStateDrill) break;
                list.add(tooltipPrefix + "drill");
            }
        }
        if (Keyboard.isKeyDown((int)42)) {
            int max = this.getWidth(stack);
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < 5; ++j) {
                sb.append(StatCollector.func_74837_a((String)"ic2.Lathe.gui.info", (Object[])new Object[]{state[j], max}));
                sb.append("   ");
            }
            list.add(sb.toString());
        }
    }

    public static ItemStack getStackForState(ItemStack stack, int[] state) {
        if (stack == null) {
            return null;
        }
        if (state == null || state.length != 5 || !(stack.func_77973_b() instanceof ILatheItem)) {
            return stack.func_77946_l();
        }
        stack = stack.func_77946_l();
        ILatheItem l = (ILatheItem)stack.func_77973_b();
        for (int i = 0; i < 5; ++i) {
            l.setState(stack, i, state[i]);
        }
        return stack;
    }

    public static ItemStack getStackForState(ItemStack stack, int state) {
        return ItemLatheDefault.getStackForState(stack, ItemLatheDefault.getStateFromNumeric(state));
    }

    public static int getNumericState(int[] state) {
        if (state == null || state.length != 5) {
            return -1;
        }
        int i = 0;
        for (int j = 0; j < 5; ++j) {
            if (state[j] >= 16) continue;
            i += state[j];
            if (j == 4) continue;
            i <<= 4;
        }
        return i;
    }

    public static int[] getStateFromNumeric(int state) {
        int[] ret = new int[5];
        if (state == -1) {
            return ret;
        }
        for (int j = 4; j >= 0; --j) {
            ret[j] = state % 16;
            if (j == 0) continue;
            state >>= 4;
        }
        return ret;
    }
}

