/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.WorldData;
import ic2.core.init.InternalName;
import ic2.core.item.tool.ItemElectricTool;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemWindmeter
extends ItemElectricTool {
    public ItemWindmeter(InternalName internalName) {
        super(internalName, Item.ToolMaterial.IRON, 50);
        this.func_77625_d(1);
        this.maxCharge = 10000;
        this.transferLimit = 100;
        this.tier = 1;
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!IC2.platform.isSimulating()) {
            return itemstack;
        }
        if (!ElectricItem.manager.canUse(itemstack, this.operationEnergyCost)) {
            return itemstack;
        }
        ElectricItem.manager.use(itemstack, this.operationEnergyCost, (EntityLivingBase)entityplayer);
        double windStrength = WorldData.get((World)world).windSim.getWindAt(entityplayer.field_70163_u);
        if (windStrength < 0.0) {
            windStrength = 0.0;
        }
        IC2.platform.messagePlayer(entityplayer, StatCollector.func_74837_a((String)"ic2.itemwindmeter.info", (Object[])new Object[]{Float.valueOf((float)Math.round(windStrength * 100.0) / 100.0f)}), new Object[0]);
        return itemstack;
    }
}

