/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.tile.IWrenchable;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.BlockBase;
import ic2.core.block.BlockTextureStitched;
import ic2.core.block.TileEntityBlock;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockIC2;
import ic2.core.util.Util;
import java.lang.reflect.Constructor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.mutable.MutableObject;

public abstract class BlockMultiID
extends BlockBase {
    public int renderMask = 63;
    private static final Class<?>[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjArray = new Object[0];
    private static final int tesBeforeBreakLimit = 8;
    private static ArrayDeque<TileEntity> tesBeforeBreak = new ArrayDeque(8);

    public BlockMultiID(InternalName internalName1, Material material) {
        super(internalName1, material);
    }

    public BlockMultiID(InternalName internalName1, Material material, Class<? extends ItemBlockIC2> itemClass) {
        super(internalName1, material, itemClass);
    }

    @Override
    public int getFacing(IBlockAccess iBlockAccess, int x, int y, int z) {
        TileEntity te = this.getOwnTe(iBlockAccess, x, y, z);
        if (te instanceof TileEntityBlock) {
            return ((TileEntityBlock)te).getFacing();
        }
        int meta = iBlockAccess.func_72805_g(x, y, z);
        return this.getFacing(meta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        int metaCount = this.getMetaCount();
        this.textures = new IIcon[metaCount][12];
        for (int index = 0; index < metaCount; ++index) {
            String textureFolder = this.getTextureFolder(index);
            textureFolder = textureFolder == null ? "" : textureFolder + "/";
            String name = IC2.textureDomain + ":" + textureFolder + this.getTextureName(index);
            for (int active = 0; active < 2; ++active) {
                for (int side = 0; side < 6; ++side) {
                    int subIndex = active * 6 + side;
                    String subName = name + ":" + subIndex;
                    BlockTextureStitched texture = new BlockTextureStitched(subName, subIndex);
                    this.textures[index][subIndex] = texture;
                    ((TextureMap)iconRegister).setTextureEntry(subName, (TextureAtlasSprite)texture);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess iBlockAccess, int x, int y, int z, int side) {
        int facing = this.getFacing(iBlockAccess, x, y, z);
        boolean active = this.isActive(iBlockAccess, x, y, z);
        int meta = iBlockAccess.func_72805_g(x, y, z);
        int index = this.getTextureIndex(meta);
        if (index >= this.textures.length) {
            return null;
        }
        int subIndex = BlockMultiID.getTextureSubIndex(facing, side);
        if (active) {
            subIndex += 6;
        }
        try {
            return this.textures[index][subIndex];
        }
        catch (Exception e) {
            IC2.platform.displayError(e, "Coordinates: %d/%d/%d\nSide: %d\nBlock: %s\nMeta: %d\nFacing: %d\nActive: %s\nIndex: %d\nSubIndex: %d", new Object[]{x, y, z, side, this, meta, facing, active, index, subIndex});
            return null;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int facing = this.getFacing(meta);
        int index = this.getTextureIndex(meta);
        int subIndex = BlockMultiID.getTextureSubIndex(facing, side);
        if (index >= this.textures.length) {
            return null;
        }
        try {
            return this.textures[index][subIndex];
        }
        catch (Exception e) {
            IC2.platform.displayError(e, "Side: " + side + "\n" + "Block: " + (Object)((Object)this) + "\n" + "Meta: " + meta + "\n" + "Facing: " + facing + "\n" + "Index: " + index + "\n" + "SubIndex: " + subIndex, new Object[0]);
            return null;
        }
    }

    public int func_149645_b() {
        return IC2.platform.getRenderId("default");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        if ((this.renderMask & 1 << side) != 0) {
            return super.func_149646_a(blockAccess, x, y, z, side);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void onRender(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity te = this.getOwnTe(blockAccess, x, y, z);
        if (te instanceof TileEntityBlock) {
            ((TileEntityBlock)te).onRender();
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float a, float b, float c) {
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        TileEntity te = this.getOwnTe((IBlockAccess)world, x, y, z);
        if (te instanceof IHasGui) {
            if (IC2.platform.isSimulating()) {
                return IC2.platform.launchGui(entityPlayer, (IHasGui)te);
            }
            return true;
        }
        return false;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList ret = super.getDrops(world, x, y, z, metadata, fortune);
        TileEntity te = this.getOwnTe((IBlockAccess)world, x, y, z);
        if (te == null) {
            Iterator<TileEntity> it = tesBeforeBreak.descendingIterator();
            while (it.hasNext()) {
                TileEntity te2 = it.next();
                if (te2.func_145831_w() != world || te2.field_145851_c != x || te2.field_145848_d != y || te2.field_145849_e != z) continue;
                te = te2;
                it.remove();
                break;
            }
        }
        if (te instanceof IInventory) {
            IInventory inv = (IInventory)te;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack itemStack = inv.func_70301_a(i);
                if (itemStack == null) continue;
                ret.add(itemStack);
            }
        }
        return ret;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = this.getOwnTe((IBlockAccess)world, x, y, z);
        if (te instanceof TileEntityBlock) {
            ((TileEntityBlock)te).onBlockBreak(block, meta);
        }
        if (te != null) {
            if (te instanceof IHasGui) {
                for (Object obj : world.field_73010_i) {
                    if (!(obj instanceof EntityPlayerMP)) continue;
                    EntityPlayerMP player = (EntityPlayerMP)obj;
                    if (!(player.field_71070_bA instanceof ContainerBase)) continue;
                    ContainerBase container = (ContainerBase)player.field_71070_bA;
                    if (container.base != te) continue;
                    player.func_71053_j();
                }
            }
            if (tesBeforeBreak.size() >= 8) {
                tesBeforeBreak.pop();
            }
            tesBeforeBreak.push(te);
        }
        if (Ic2Items.copperOre != null && this.func_149739_a().equals(Ic2Items.copperOre.func_77977_a())) {
            this.func_149657_c(world, x, y, z, 1);
        }
        if (Ic2Items.tinOre != null && this.func_149739_a().equals(Ic2Items.tinOre.func_77977_a())) {
            this.func_149657_c(world, x, y, z, 1);
        }
        if (Ic2Items.uraniumOre != null && this.func_149739_a().equals(Ic2Items.uraniumOre.func_77977_a())) {
            this.func_149657_c(world, x, y, z, 2);
        }
        if (Ic2Items.leadOre != null && this.func_149739_a().equals(Ic2Items.leadOre.func_77977_a())) {
            this.func_149657_c(world, x, y, z, 1);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemStack) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        TileEntity tileEntity = this.getOwnTe((IBlockAccess)world, x, y, z);
        if (tileEntity instanceof IWrenchable) {
            IWrenchable te = (IWrenchable)tileEntity;
            if (entityliving == null) {
                te.setFacing((short)2);
            } else {
                int l = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                switch (l) {
                    case 0: {
                        te.setFacing((short)2);
                        break;
                    }
                    case 1: {
                        te.setFacing((short)5);
                        break;
                    }
                    case 2: {
                        te.setFacing((short)3);
                        break;
                    }
                    case 3: {
                        te.setFacing((short)4);
                    }
                }
            }
        }
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        super.func_149725_f(world, x, y, z, meta);
        TileEntity te = this.getOwnTe((IBlockAccess)world, x, y, z);
        if (te instanceof TileEntityBlock) {
            TileEntityBlock teb = (TileEntityBlock)te;
            if (teb.loaded) {
                teb.onUnloaded();
            }
        }
    }

    public final boolean hasTileEntity(int metadata) {
        return true;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public final TileEntity createTileEntity(World world, int metadata) {
        MutableObject ctorArgTypes = new MutableObject(emptyClassArray);
        MutableObject ctorArgs = new MutableObject((Object)emptyObjArray);
        Class<? extends TileEntity> teClass = this.getTeClass(metadata, (MutableObject<Class<?>[]>)ctorArgTypes, (MutableObject<Object[]>)ctorArgs);
        if (teClass == null) {
            return null;
        }
        try {
            Constructor<? extends TileEntity> ctor = teClass.getConstructor((Class[])ctorArgTypes.getValue());
            return ctor.newInstance((Object[])ctorArgs.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException("Error constructing " + teClass + " with " + Arrays.asList((Object[])ctorArgTypes.getValue()) + ", " + Arrays.asList((Object[])ctorArgs.getValue()) + ".", e);
        }
    }

    public abstract Class<? extends TileEntity> getTeClass(int var1, MutableObject<Class<?>[]> var2, MutableObject<Object[]> var3);

    public TileEntity getOwnTe(IBlockAccess blockAccess, int x, int y, int z) {
        Class<?> actualClass;
        TileEntity te;
        int meta;
        Block block;
        if (blockAccess instanceof World) {
            Chunk chunk = Util.getLoadedChunk((World)blockAccess, x >> 4, z >> 4);
            if (chunk == null) {
                return null;
            }
            block = chunk.func_150810_a(x & 0xF, y, z & 0xF);
            meta = chunk.func_76628_c(x & 0xF, y, z & 0xF);
            te = chunk.func_150806_e(x & 0xF, y, z & 0xF);
        } else {
            block = blockAccess.func_147439_a(x, y, z);
            meta = blockAccess.func_72805_g(x, y, z);
            te = blockAccess.func_147438_o(x, y, z);
        }
        Class<? extends TileEntity> expectedClass = this.getTeClass(meta, null, null);
        Class<?> clazz = actualClass = te != null ? te.getClass() : null;
        if (actualClass != expectedClass) {
            if (block != this) {
                if (Util.inDev()) {
                    StackTraceElement[] st = new Throwable().getStackTrace();
                    IC2.log.warn("Own tile entity query from {} to foreign block {} instead of {} at dim {}, {}/{}/{}.", new Object[]{st.length > 1 ? st[1] : "?", block != null ? block.getClass() : null, ((Object)((Object)this)).getClass(), blockAccess instanceof World ? Integer.valueOf(((World)blockAccess).field_73011_w.field_76574_g) : "?", x, y, z});
                }
                return null;
            }
            IC2.log.warn("Mismatched tile entity at dim {}, {}/{}/{}, got {}, expected {}.", new Object[]{blockAccess instanceof World ? Integer.valueOf(((World)blockAccess).field_73011_w.field_76574_g) : "?", x, y, z, actualClass, expectedClass});
            if (blockAccess instanceof World) {
                World world = (World)blockAccess;
                te = this.createTileEntity(world, meta);
                world.func_147455_a(x, y, z, te);
            } else {
                return null;
            }
        }
        return te;
    }

    public final boolean isActive(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity te = this.getOwnTe(blockAccess, x, y, z);
        if (te instanceof TileEntityBlock) {
            return ((TileEntityBlock)te).getActive();
        }
        return false;
    }

    public void func_149666_a(Item j, CreativeTabs tabs, List itemList) {
        Item item = Item.func_150898_a((Block)this);
        if (!item.func_77614_k()) {
            itemList.add(new ItemStack((Block)this));
        } else {
            ItemStack is;
            for (int i = 0; i < 16 && (is = new ItemStack((Block)this, 1, i)).func_77973_b().func_77667_c(is) != null; ++i) {
                itemList.add(is);
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        int newFacing;
        IWrenchable te;
        if (axis == ForgeDirection.UNKNOWN) {
            return false;
        }
        TileEntity tileEntity = this.getOwnTe((IBlockAccess)worldObj, x, y, z);
        if (tileEntity instanceof IWrenchable && (te = (IWrenchable)tileEntity).wrenchCanSetFacing(null, newFacing = ForgeDirection.getOrientation((int)te.getFacing()).getRotation(axis).ordinal())) {
            te.setFacing((short)newFacing);
        }
        return false;
    }
}

