/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.invslot;

import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.util.StackUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public abstract class InvSlotConsumable
extends InvSlot {
    public InvSlotConsumable(TileEntityInventory base1, String name1, int oldStartIndex1, int count) {
        super(base1, name1, oldStartIndex1, InvSlot.Access.I, count, InvSlot.InvSide.TOP);
    }

    public InvSlotConsumable(TileEntityInventory base1, String name1, int oldStartIndex1, InvSlot.Access access1, int count, InvSlot.InvSide preferredSide1) {
        super(base1, name1, oldStartIndex1, access1, count, preferredSide1);
    }

    @Override
    public abstract boolean accepts(ItemStack var1);

    @Override
    public boolean canOutput() {
        return super.canOutput() || this.access != InvSlot.Access.NONE && this.get() != null && !this.accepts(this.get());
    }

    public ItemStack consume(int amount) {
        return this.consume(amount, false, false);
    }

    public ItemStack consume(int amount, boolean simulate, boolean consumeContainers) {
        ItemStack ret = null;
        for (int i = 0; i < this.size(); ++i) {
            ItemStack stack = this.get(i);
            if (stack == null || stack.field_77994_a < 1 || !this.accepts(stack) || ret != null && !StackUtil.isStackEqualStrict(stack, ret) || stack.field_77994_a != 1 && !consumeContainers && stack.func_77973_b().hasContainerItem(stack)) continue;
            int currentAmount = Math.min(amount, stack.field_77994_a);
            amount -= currentAmount;
            if (!simulate) {
                if (stack.field_77994_a == currentAmount) {
                    if (!consumeContainers && stack.func_77973_b().hasContainerItem(stack)) {
                        this.put(i, stack.func_77973_b().getContainerItem(stack));
                    } else {
                        this.put(i, null);
                    }
                } else {
                    stack.field_77994_a -= currentAmount;
                }
            }
            if (ret == null) {
                ret = StackUtil.copyWithSize(stack, currentAmount);
            } else {
                ret.field_77994_a += currentAmount;
            }
            if (amount == 0) break;
        }
        return ret;
    }

    public ItemStack damage(int amount, boolean simulate) {
        return this.damage(amount, simulate, null);
    }

    public ItemStack damage(int amount, boolean simulate, EntityLivingBase src) {
        ItemStack ret = null;
        int damageApplied = 0;
        for (int i = 0; i < this.size() && amount > 0; ++i) {
            ItemStack itemStack = this.get(i);
            if (itemStack == null || !this.accepts(itemStack) || !itemStack.func_77973_b().func_77645_m() || ret != null && (itemStack.func_77973_b() != ret.func_77973_b() || !ItemStack.func_77970_a((ItemStack)itemStack, ret))) continue;
            if (simulate) {
                itemStack = itemStack.func_77946_l();
            }
            while (amount > 0 && itemStack.field_77994_a > 0) {
                int currentAmount = Math.min(amount, itemStack.func_77958_k() - itemStack.func_77960_j());
                damageApplied += currentAmount;
                amount -= currentAmount;
                if (src != null) {
                    itemStack.func_77972_a(currentAmount, src);
                } else {
                    itemStack.func_96631_a(currentAmount, IC2.random);
                }
                if (itemStack.func_77960_j() >= itemStack.func_77958_k()) {
                    --itemStack.field_77994_a;
                    itemStack.func_77964_b(0);
                }
                if (ret != null) continue;
                ret = itemStack.func_77946_l();
            }
            if (itemStack.field_77994_a != 0 || simulate) continue;
            this.put(i, null);
        }
        if (ret != null) {
            ret.field_77994_a = damageApplied / ret.func_77958_k();
            ret.func_77964_b(damageApplied % ret.func_77958_k());
        }
        return ret;
    }
}

