/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.kineticgenerator.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IKineticSource;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotConsumableItemStack;
import ic2.core.block.invslot.InvSlotDischarge;
import ic2.core.block.kineticgenerator.container.ContainerElectricKineticGenerator;
import ic2.core.block.kineticgenerator.gui.GuiElectricKineticGenertor;
import ic2.core.init.MainConfig;
import ic2.core.util.ConfigUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityElectricKineticGenerator
extends TileEntityInventory
implements IKineticSource,
IHasGui,
IEnergySink {
    public InvSlotConsumableItemStack slotMotor;
    public InvSlotDischarge dischargeSlot;
    private double productionpeerkineticunit = 0.25 * (double)ConfigUtil.getFloat(MainConfig.get(), "balance/energy/generator/Kinetic");
    private boolean newActive;
    public double energy = 0.0;
    public double ku = 0.0;
    public final int maxEnergy = 10000;
    public final int maxKU = 1000;
    private boolean addedToEnergyNet = false;
    private float guiChargeLevel;

    public TileEntityElectricKineticGenerator() {
        this.slotMotor = new InvSlotConsumableItemStack((TileEntityInventory)this, "slotMotor", 0, 10, Ic2Items.elemotor);
        this.slotMotor.setStackSizeLimit(1);
        this.dischargeSlot = new InvSlotDischarge(this, 6, 4);
        this.newActive = false;
    }

    @Override
    public int maxrequestkineticenergyTick(ForgeDirection directionFrom) {
        if (directionFrom.ordinal() != this.getFacing()) {
            return 0;
        }
        return (int)Math.min((double)this.getMaxKU(), this.ku);
    }

    public int getMaxKU() {
        int counter = 0;
        int a = this.getMaxKUForGUI() / 10;
        for (int i = 0; i < this.slotMotor.size(); ++i) {
            if (this.slotMotor.get(i) == null) continue;
            counter += a;
        }
        return counter;
    }

    public int getMaxKUForGUI() {
        return 1000;
    }

    @Override
    public int requestkineticenergy(ForgeDirection directionFrom, int requestkineticenergy) {
        int max = this.maxrequestkineticenergyTick(directionFrom);
        int out = max > requestkineticenergy ? requestkineticenergy : max;
        this.ku -= (double)out;
        this.func_70296_d();
        return out;
    }

    @Override
    public String func_145825_b() {
        return "Electric Kinetic Generator";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74769_h("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (IC2.platform.isSimulating()) {
            double amount;
            if (10000.0 - this.energy >= 1.0 && (amount = this.dischargeSlot.discharge(10000.0 - this.energy, true)) > 0.0) {
                this.energy += amount;
                this.func_70296_d();
            }
            this.guiChargeLevel = Math.min(1.0f, (float)this.energy / 10000.0f);
        }
        if (1000.0 - this.ku > 1.0) {
            double max = Math.min(1000.0 - this.ku, this.energy / this.productionpeerkineticunit);
            this.energy -= max * this.productionpeerkineticunit;
            this.ku += max;
            this.func_70296_d();
        }
        if (this.getActive() != this.newActive) {
            this.setActive(this.newActive);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public ContainerBase<TileEntityElectricKineticGenerator> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerElectricKineticGenerator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiElectricKineticGenertor((ContainerElectricKineticGenerator)this.getGuiContainer(entityPlayer));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return direction.ordinal() != this.getFacing();
    }

    @Override
    public double getDemandedEnergy() {
        return 10000.0 - this.energy;
    }

    @Override
    public int getSinkTier() {
        return 4;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (directionFrom.ordinal() == this.getFacing()) {
            return amount;
        }
        int max = (int)Math.max(10000.0 - this.energy, 0.0);
        if ((max = (int)Math.min((double)max, amount)) < 1) {
            return amount;
        }
        this.energy += (double)max;
        return amount -= (double)max;
    }

    public final float getChargeLevel() {
        return this.guiChargeLevel;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return side != this.getFacing();
    }
}

