/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IBlockCuttingBlade;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.BasicMachineRecipeManager;
import ic2.core.ContainerBase;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotConsumableIBlockCuttingBlade;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.block.machine.container.ContainerBlockCutter;
import ic2.core.block.machine.gui.GuiBlockCutter;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityBlockCutter
extends TileEntityStandardMachine {
    private boolean bladetoweak = false;
    public final InvSlotConsumableIBlockCuttingBlade cutterSlot;

    public TileEntityBlockCutter() {
        super(128, 900, 1, 2);
        this.inputSlot = new InvSlotProcessableGeneric((TileEntityInventory)this, "input", 0, 1, Recipes.blockcutter);
        this.cutterSlot = new InvSlotConsumableIBlockCuttingBlade(this, "cutterSlot", 1, 1);
    }

    public static void init() {
        Recipes.blockcutter = new BasicMachineRecipeManager();
        TileEntityBlockCutter.addRecipe("blockLead", 1, 2, StackUtil.copyWithSize(Ic2Items.platelead, 9));
        TileEntityBlockCutter.addRecipe("blockTin", 1, 2, StackUtil.copyWithSize(Ic2Items.platetin, 9));
        TileEntityBlockCutter.addRecipe("blockCopper", 1, 2, StackUtil.copyWithSize(Ic2Items.platecopper, 9));
        TileEntityBlockCutter.addRecipe("blockBronze", 1, 2, StackUtil.copyWithSize(Ic2Items.platebronze, 9));
        TileEntityBlockCutter.addRecipe(new ItemStack(Blocks.field_150340_R), 1, 2, StackUtil.copyWithSize(Ic2Items.plategold, 9));
        TileEntityBlockCutter.addRecipe(new ItemStack(Blocks.field_150339_S), 1, 5, StackUtil.copyWithSize(Ic2Items.plateiron, 9));
        TileEntityBlockCutter.addRecipe(new ItemStack(Blocks.field_150368_y), 1, 5, StackUtil.copyWithSize(Ic2Items.platelapi, 9));
        TileEntityBlockCutter.addRecipe("blockSteel", 1, 8, StackUtil.copyWithSize(Ic2Items.plateadviron, 9));
        TileEntityBlockCutter.addRecipe(new ItemStack(Blocks.field_150343_Z), 1, 8, StackUtil.copyWithSize(Ic2Items.plateobsidian, 9));
    }

    public static void addRecipe(ItemStack input, int amount, int cutterlevel, ItemStack ... output) {
        TileEntityBlockCutter.addRecipe(new RecipeInputItemStack(input, amount), cutterlevel, output);
    }

    public static void addRecipe(String input, int amount, int cutterlevel, ItemStack ... output) {
        TileEntityBlockCutter.addRecipe(new RecipeInputOreDict(input, amount), cutterlevel, output);
    }

    public static void addRecipe(IRecipeInput input, int cutterlevel, ItemStack ... output) {
        NBTTagCompound metadata = new NBTTagCompound();
        metadata.func_74768_a("hardness", cutterlevel);
        Recipes.blockcutter.addRecipe(input, metadata, output);
    }

    @Override
    public RecipeOutput getOutput() {
        RecipeOutput ret;
        if (this.cutterSlot.isEmpty()) {
            if (!this.bladetoweak) {
                this.bladetoweak = true;
            }
            return null;
        }
        if (this.bladetoweak) {
            this.bladetoweak = false;
        }
        if ((ret = super.getOutput()) != null) {
            if (ret.metadata == null) {
                return null;
            }
            if (ret.metadata.func_74762_e("hardness") > ((IBlockCuttingBlade)this.cutterSlot.get().func_77973_b()).gethardness()) {
                if (!this.bladetoweak) {
                    this.bladetoweak = true;
                }
                return null;
            }
            if (this.bladetoweak) {
                this.bladetoweak = false;
            }
        }
        return ret;
    }

    @Override
    public String func_145825_b() {
        return "BlockCutter";
    }

    public ContainerBase<TileEntityBlockCutter> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerBlockCutter(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiBlockCutter(new ContainerBlockCutter(entityPlayer, this));
    }

    public boolean isbladetoweak() {
        return this.bladetoweak;
    }

    @Override
    public float getWrenchDropRate() {
        return 0.8f;
    }

    @Override
    public List<ItemStack> getCompatibleUpgradeList() {
        ArrayList<ItemStack> itemstack = new ArrayList<ItemStack>();
        itemstack.add(Ic2Items.overclockerUpgrade);
        itemstack.add(Ic2Items.transformerUpgrade);
        itemstack.add(Ic2Items.energyStorageUpgrade);
        itemstack.add(Ic2Items.ejectorUpgrade);
        return itemstack;
    }
}

