/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.tile.IEnergyStorage;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.wiring.ContainerChargepadBlock;
import ic2.core.block.wiring.GuiChargepadBlock;
import ic2.core.block.wiring.TileEntityElectricBlock;
import ic2.core.init.MainConfig;
import ic2.core.util.ConfigUtil;
import ic2.core.util.EntityIC2FX;
import ic2.core.util.StackUtil;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityChargepadBlock
extends TileEntityElectricBlock
implements IEnergySink,
IEnergySource,
IHasGui,
IEnergyStorage {
    private int updateTicker = IC2.random.nextInt(this.getTickRate());
    private EntityPlayer player = null;
    private boolean isEmittingRedstone = false;
    public boolean addedToEnergyNet = false;
    public static byte redstoneModes = (byte)2;

    public TileEntityChargepadBlock(int tier1, int output1, int maxStorage1) {
        super(tier1, output1, maxStorage1);
    }

    public void playerstandsat(EntityPlayer entity) {
        if (this.player == null) {
            this.player = entity;
        } else if (this.player.func_110124_au() != entity.func_110124_au()) {
            this.player = entity;
        }
    }

    protected int getTickRate() {
        return 2;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        if (side == 1) {
            return false;
        }
        return this.getFacing() != side;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = false;
        if (this.updateTicker++ % this.getTickRate() != 0) {
            return;
        }
        if (this.player != null && this.energy >= 1.0) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            this.getItems(this.player);
            this.player = null;
            needsInvUpdate = true;
        } else if (this.getActive()) {
            this.setActive(false);
            needsInvUpdate = true;
        }
        if (this.redstoneMode == 0 && this.getActive() || this.redstoneMode == 1 && !this.getActive()) {
            this.isEmittingRedstone = true;
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        } else {
            this.isEmittingRedstone = false;
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    protected abstract void getItems(EntityPlayer var1);

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        if (direction == ForgeDirection.UP) {
            return false;
        }
        return !this.facingMatchesDirection(direction);
    }

    public ContainerBase<TileEntityChargepadBlock> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerChargepadBlock(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiChargepadBlock(new ContainerChargepadBlock(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public boolean isEmittingRedstone() {
        return this.isEmittingRedstone;
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world, int blockX, int blockY, int blockZ, Random rand) {
        if (this.getActive()) {
            EffectRenderer effect = FMLClientHandler.instance().getClient().field_71452_i;
            for (int particles = 20; particles > 0; --particles) {
                double x = (float)blockX + 0.0f + rand.nextFloat();
                double y = (float)blockY + 0.9f + rand.nextFloat();
                double z = (float)blockZ + 0.0f + rand.nextFloat();
                effect.func_78873_a((EntityFX)new EntityIC2FX(world, x, y, z, 60, new double[]{0.0, 0.1, 0.0}, new float[]{0.2f, 0.2f, 1.0f}));
            }
        }
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        ItemStack ret = super.getWrenchDrop(entityPlayer);
        float energyRetainedInStorageBlockDrops = ConfigUtil.getFloat(MainConfig.get(), "balance/energyRetainedInStorageBlockDrops");
        if (energyRetainedInStorageBlockDrops > 0.0f) {
            NBTTagCompound nbttagcompound = StackUtil.getOrCreateNbtData(ret);
            nbttagcompound.func_74780_a("energy", this.energy * (double)energyRetainedInStorageBlockDrops);
        }
        return ret;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        this.redstoneMode = (byte)(this.redstoneMode + 1);
        if (this.redstoneMode >= redstoneModes) {
            this.redstoneMode = 0;
        }
        IC2.platform.messagePlayer(player, this.getredstoneMode(), new Object[0]);
    }

    @Override
    public String getredstoneMode() {
        if (this.redstoneMode > 1 || this.redstoneMode < 0) {
            return "";
        }
        return StatCollector.func_74838_a((String)("ic2.blockChargepad.gui.mod.redstone" + this.redstoneMode));
    }

    protected void chargeitems(ItemStack itemstack, int chargefactor) {
        if (!(itemstack.func_77973_b() instanceof IElectricItem)) {
            return;
        }
        if (itemstack.func_77973_b() == Ic2Items.debug.func_77973_b()) {
            return;
        }
        double freeamount = ElectricItem.manager.charge(itemstack, Double.POSITIVE_INFINITY, this.tier, true, true);
        double charge = 0.0;
        if (freeamount >= 0.0) {
            charge = this.energy >= freeamount ? (freeamount >= (double)(chargefactor * this.getTickRate()) ? (double)(chargefactor * this.getTickRate()) : freeamount) : this.energy;
            this.energy -= ElectricItem.manager.charge(itemstack, charge, this.tier, true, false);
        }
    }
}

